/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.events;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.AttributeBuilder;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.events.Event;
import org.apache.flink.events.SimpleEvent;

@Experimental
public class EventBuilder
implements AttributeBuilder {
    private long observedTsMillis;
    private String name;
    private String classScope;
    private String body;
    private String severity;
    private final Map<String, Object> attributes;

    public EventBuilder(String classScope, String name) {
        this.classScope = classScope;
        this.name = name;
        this.observedTsMillis = 0L;
        this.body = "";
        this.severity = "";
        this.attributes = new HashMap<String, Object>();
    }

    public EventBuilder() {
        this("", "");
    }

    public EventBuilder(Class<?> classScope) {
        this(classScope, "");
    }

    public EventBuilder(Class<?> classScope, String name) {
        this(classScope.getCanonicalName(), name);
    }

    public EventBuilder setObservedTsMillis(long observedTsMillis) {
        this.observedTsMillis = observedTsMillis;
        return this;
    }

    public EventBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public EventBuilder setClassScope(String classScope) {
        this.classScope = classScope;
        return this;
    }

    public EventBuilder setBody(String body) {
        this.body = body;
        return this;
    }

    public EventBuilder setSeverity(String severity) {
        this.severity = severity;
        return this;
    }

    @Override
    public EventBuilder setAttribute(String key, String value) {
        this.attributes.put(key, value);
        return this;
    }

    @Override
    public EventBuilder setAttribute(String key, long value) {
        this.attributes.put(key, value);
        return this;
    }

    @Override
    public EventBuilder setAttribute(String key, double value) {
        this.attributes.put(key, value);
        return this;
    }

    @Override
    public EventBuilder setAttribute(String key, boolean value) {
        this.attributes.put(key, value);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Event build(Map<String, String> additionalVariables) {
        if (this.observedTsMillis == 0L) {
            this.observedTsMillis = System.currentTimeMillis();
        }
        this.attributes.putAll(additionalVariables);
        return new SimpleEvent(this.observedTsMillis, this.name, this.classScope, this.body, this.severity, this.attributes);
    }

    public Event build() {
        return this.build(Collections.emptyMap());
    }
}

