/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.traces;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.AttributeBuilder;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.traces.SimpleSpan;
import org.apache.flink.traces.Span;

@Experimental
public class SpanBuilder
implements AttributeBuilder {
    private final HashMap<String, Object> attributes = new HashMap();
    private final Class<?> classScope;
    private final String name;
    private long startTsMillis;
    private long endTsMillis;

    SpanBuilder(Class<?> classScope, String name) {
        this.classScope = classScope;
        this.name = name;
    }

    public Span build() {
        return this.build(Collections.emptyMap());
    }

    public Span build(Map<String, String> additionalVariables) {
        long endTsMillisToBuild;
        long startTsMillisToBuild = this.startTsMillis;
        if (startTsMillisToBuild == 0L) {
            startTsMillisToBuild = System.currentTimeMillis();
        }
        if ((endTsMillisToBuild = this.endTsMillis) == 0L) {
            endTsMillisToBuild = startTsMillisToBuild;
        }
        this.attributes.putAll(additionalVariables);
        return new SimpleSpan(this.classScope.getCanonicalName(), this.name, startTsMillisToBuild, endTsMillisToBuild, this.attributes);
    }

    public SpanBuilder setStartTsMillis(long startTsMillis) {
        this.startTsMillis = startTsMillis;
        return this;
    }

    public SpanBuilder setEndTsMillis(long endTsMillis) {
        this.endTsMillis = endTsMillis;
        return this;
    }

    @Override
    public SpanBuilder setAttribute(String key, String value) {
        this.attributes.put(key, value);
        return this;
    }

    @Override
    public SpanBuilder setAttribute(String key, long value) {
        this.attributes.put(key, value);
        return this;
    }

    @Override
    public SpanBuilder setAttribute(String key, double value) {
        this.attributes.put(key, value);
        return this;
    }

    @Override
    public SpanBuilder setAttribute(String key, boolean value) {
        this.attributes.put(key, value);
        return this;
    }

    public String getName() {
        return this.name;
    }
}

