/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.dag;

import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.base.DeltaIterationBase;
import org.apache.flink.optimizer.DataStatistics;
import org.apache.flink.optimizer.dag.AbstractPartialSolutionNode;
import org.apache.flink.optimizer.dag.DagConnection;
import org.apache.flink.optimizer.dag.OptimizerNode;
import org.apache.flink.optimizer.dag.WorksetIterationNode;
import org.apache.flink.optimizer.dataproperties.GlobalProperties;
import org.apache.flink.optimizer.dataproperties.LocalProperties;
import org.apache.flink.optimizer.plan.Channel;
import org.apache.flink.optimizer.plan.WorksetPlanNode;

public class WorksetNode
extends AbstractPartialSolutionNode {
    private final WorksetIterationNode iterationNode;

    public WorksetNode(DeltaIterationBase.WorksetPlaceHolder<?> psph, WorksetIterationNode iterationNode) {
        super((Operator<?>)psph);
        this.iterationNode = iterationNode;
    }

    public void setCandidateProperties(GlobalProperties gProps, LocalProperties lProps, Channel initialInput) {
        if (this.cachedPlans != null) {
            throw new IllegalStateException();
        }
        WorksetPlanNode wspn = new WorksetPlanNode(this, "Workset (" + this.getOperator().getName() + ")", gProps, lProps, initialInput);
        this.cachedPlans = Collections.singletonList(wspn);
    }

    public WorksetPlanNode getCurrentWorksetPlanNode() {
        if (this.cachedPlans != null) {
            return (WorksetPlanNode)this.cachedPlans.get(0);
        }
        throw new IllegalStateException();
    }

    @Override
    public WorksetIterationNode getIterationNode() {
        return this.iterationNode;
    }

    @Override
    public void computeOutputEstimates(DataStatistics statistics) {
        this.copyEstimates(this.iterationNode.getInitialWorksetPredecessorNode());
    }

    public DeltaIterationBase.WorksetPlaceHolder<?> getOperator() {
        return (DeltaIterationBase.WorksetPlaceHolder)super.getOperator();
    }

    @Override
    public String getOperatorName() {
        return "Workset";
    }

    @Override
    public void computeUnclosedBranchStack() {
        if (this.openBranches != null) {
            return;
        }
        DagConnection worksetInput = this.iterationNode.getSecondIncomingConnection();
        OptimizerNode worksetSource = worksetInput.getSource();
        this.addClosedBranches(worksetSource.closedBranchingNodes);
        List<OptimizerNode.UnclosedBranchDescriptor> fromInput = worksetSource.getBranchesForParent(worksetInput);
        this.openBranches = fromInput == null || fromInput.isEmpty() ? Collections.emptyList() : fromInput;
    }
}

