/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.flink.runtime.checkpoint.CheckpointCoordinatorTestingUtils;
import org.apache.flink.runtime.checkpoint.InflightDataRescalingDescriptorUtil;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.RescaleMappings;
import org.apache.flink.runtime.checkpoint.StateHandleDummyUtil;
import org.apache.flink.runtime.checkpoint.StateObjectCollection;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.checkpoint.channel.ResultSubpartitionInfo;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.state.InputChannelStateHandle;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.ResultSubpartitionStateHandle;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.memory.ByteStreamStateHandle;
import org.junit.Assert;
import org.junit.Test;

public class OperatorSubtaskStateTest {
    @Test
    public void testDiscardDuplicatedDelegatesOnce() {
        DiscardOnceStreamStateHandle delegate = new DiscardOnceStreamStateHandle();
        OperatorSubtaskState.builder().setInputChannelState(new StateObjectCollection(Arrays.asList(this.buildInputChannelHandle((StreamStateHandle)delegate, 1), this.buildInputChannelHandle((StreamStateHandle)delegate, 2)))).setResultSubpartitionState(new StateObjectCollection(Arrays.asList(this.buildSubpartitionHandle((StreamStateHandle)delegate, 4), this.buildSubpartitionHandle((StreamStateHandle)delegate, 3)))).build().discardState();
    }

    @Test
    public void testToBuilderCorrectness() throws IOException {
        JobVertexID jobVertexID = new JobVertexID();
        int index = 0;
        Random random = new Random();
        OperatorSubtaskState operatorSubtaskState = OperatorSubtaskState.builder().setManagedOperatorState(CheckpointCoordinatorTestingUtils.generatePartitionableStateHandle(jobVertexID, index, 2, 8, false)).setRawOperatorState(CheckpointCoordinatorTestingUtils.generatePartitionableStateHandle(jobVertexID, index, 2, 8, true)).setManagedKeyedState((KeyedStateHandle)CheckpointCoordinatorTestingUtils.generateKeyGroupState(jobVertexID, new KeyGroupRange(0, 11), false)).setRawKeyedState((KeyedStateHandle)CheckpointCoordinatorTestingUtils.generateKeyGroupState(jobVertexID, new KeyGroupRange(0, 9), true)).setInputChannelState(StateObjectCollection.singleton((StateObject)StateHandleDummyUtil.createNewInputChannelStateHandle(3, random))).setResultSubpartitionState(StateObjectCollection.singleton((StateObject)StateHandleDummyUtil.createNewResultSubpartitionStateHandle(3, random))).setInputRescalingDescriptor(InflightDataRescalingDescriptorUtil.rescalingDescriptor(new int[1], new RescaleMappings[0], Collections.singleton(1))).setOutputRescalingDescriptor(InflightDataRescalingDescriptorUtil.rescalingDescriptor(new int[1], new RescaleMappings[0], Collections.singleton(2))).build();
        OperatorSubtaskState operatorSubtaskStateCopy = operatorSubtaskState.toBuilder().build();
        Assert.assertTrue((boolean)EqualsBuilder.reflectionEquals((Object)operatorSubtaskState, (Object)operatorSubtaskStateCopy, (String[])new String[0]));
    }

    private ResultSubpartitionStateHandle buildSubpartitionHandle(StreamStateHandle delegate, int subPartitionIdx1) {
        return new ResultSubpartitionStateHandle(new ResultSubpartitionInfo(0, subPartitionIdx1), delegate, Collections.singletonList(0L));
    }

    private InputChannelStateHandle buildInputChannelHandle(StreamStateHandle delegate, int inputChannelIdx) {
        return new InputChannelStateHandle(new InputChannelInfo(0, inputChannelIdx), delegate, Collections.singletonList(0L));
    }

    private static class DiscardOnceStreamStateHandle
    extends ByteStreamStateHandle {
        private static final long serialVersionUID = 1L;
        private boolean discarded = false;

        DiscardOnceStreamStateHandle() {
            super("test", new byte[0]);
        }

        public void discardState() {
            super.discardState();
            Assert.assertFalse((String)"state was discarded twice", (boolean)this.discarded);
            this.discarded = true;
        }
    }
}

