/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.checkpoint.SubtaskStateStats;
import org.junit.Assert;
import org.junit.Test;

public class SubtaskStateStatsTest {
    @Test
    public void testSimpleAccess() throws Exception {
        this.test(false);
    }

    @Test
    public void testIsJavaSerializable() throws Exception {
        this.test(true);
    }

    public void test(boolean serialize) throws Exception {
        SubtaskStateStats stats = new SubtaskStateStats(0, 0x80000000L, 0x80000001L, 0x80000001L, 0x80000002L, 0x80000003L, 0x80000007L, 0x80000008L, 0x80000005L, 0x80000006L, false, true);
        stats = serialize ? (SubtaskStateStats)CommonTestUtils.createCopySerializable((Serializable)stats) : stats;
        Assert.assertEquals((long)0L, (long)stats.getSubtaskIndex());
        Assert.assertEquals((long)0x80000000L, (long)stats.getAckTimestamp());
        Assert.assertEquals((long)0x80000001L, (long)stats.getStateSize());
        Assert.assertEquals((long)0x80000002L, (long)stats.getSyncCheckpointDuration());
        Assert.assertEquals((long)0x80000003L, (long)stats.getAsyncCheckpointDuration());
        Assert.assertEquals((long)0x80000005L, (long)stats.getAlignmentDuration());
        Assert.assertEquals((long)0x80000006L, (long)stats.getCheckpointStartDelay());
        long ackTimestamp = stats.getAckTimestamp();
        long triggerTimestamp = ackTimestamp - 10123L;
        Assert.assertEquals((long)10123L, (long)stats.getEndToEndDuration(triggerTimestamp));
        Assert.assertEquals((long)0L, (long)stats.getEndToEndDuration(ackTimestamp + 1L));
    }
}

