/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.active;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blocklist.BlockedNodeRetriever;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessSpec;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessUtils;
import org.apache.flink.runtime.clusterframework.types.ResourceIDRetrievable;
import org.apache.flink.runtime.resourcemanager.WorkerResourceSpec;
import org.apache.flink.runtime.resourcemanager.active.ResourceManagerDriver;
import org.apache.flink.runtime.resourcemanager.active.TestingResourceEventHandler;
import org.apache.flink.util.TestLoggerExtension;
import org.apache.flink.util.concurrent.ScheduledExecutor;
import org.apache.flink.util.concurrent.ScheduledExecutorServiceAdapter;
import org.apache.flink.util.function.RunnableWithException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={TestLoggerExtension.class})
public abstract class ResourceManagerDriverTestBase<WorkerType extends ResourceIDRetrievable> {
    protected static final long TIMEOUT_SEC = 5L;
    protected static final TaskExecutorProcessSpec TASK_EXECUTOR_PROCESS_SPEC = TaskExecutorProcessUtils.processSpecFromWorkerResourceSpec((Configuration)new Configuration(), (WorkerResourceSpec)WorkerResourceSpec.ZERO);
    private static final String MAIN_THREAD_NAME = "testing-rpc-main-thread";
    private static final ScheduledExecutor MAIN_THREAD_EXECUTOR = new ScheduledExecutorServiceAdapter(Executors.newSingleThreadScheduledExecutor(runnable -> new Thread(runnable, MAIN_THREAD_NAME)));

    @Test
    public void testInitialize() throws Exception {
        Context context = this.createContext();
        context.runTest(context::validateInitialization);
    }

    @Test
    public void testRecoverPreviousAttemptWorkers() throws Exception {
        CompletableFuture recoveredWorkersFuture = new CompletableFuture();
        Context context = this.createContext();
        context.resourceEventHandlerBuilder.setOnPreviousAttemptWorkersRecoveredConsumer(recoveredWorkersFuture::complete);
        context.preparePreviousAttemptWorkers();
        context.runTest(() -> context.validateWorkersRecoveredFromPreviousAttempt((Collection)recoveredWorkersFuture.get(5L, TimeUnit.SECONDS)));
    }

    @Test
    public void testTerminate() throws Exception {
        Context context = this.createContext();
        context.runTest(() -> {
            context.getDriver().terminate();
            context.validateTermination();
        });
    }

    @Test
    public void testDeregisterApplicationSucceeded() throws Exception {
        this.testDeregisterApplication(ApplicationStatus.SUCCEEDED);
    }

    @Test
    public void testDeregisterApplicationFailed() throws Exception {
        this.testDeregisterApplication(ApplicationStatus.FAILED);
    }

    @Test
    public void testDeregisterApplicationCanceled() throws Exception {
        this.testDeregisterApplication(ApplicationStatus.CANCELED);
    }

    @Test
    public void testDeregisterApplicationUnknown() throws Exception {
        this.testDeregisterApplication(ApplicationStatus.UNKNOWN);
    }

    private void testDeregisterApplication(ApplicationStatus status) throws Exception {
        Context context = this.createContext();
        context.runTest(() -> {
            context.getDriver().deregisterApplication(status, null);
            context.validateDeregisterApplication();
        });
    }

    @Test
    public void testRequestResource() throws Exception {
        Context context = this.createContext();
        context.runTest(() -> {
            context.runInMainThread(() -> context.getDriver().requestResource(TASK_EXECUTOR_PROCESS_SPEC));
            context.validateRequestedResources(Collections.singleton(TASK_EXECUTOR_PROCESS_SPEC));
        });
    }

    @Test
    public void testReleaseResource() throws Exception {
        CompletableFuture requestResourceFuture = new CompletableFuture();
        CompletableFuture releaseResourceFuture = new CompletableFuture();
        Context context = this.createContext();
        context.runTest(() -> {
            context.runInMainThread(() -> context.getDriver().requestResource(TASK_EXECUTOR_PROCESS_SPEC).thenAccept(requestResourceFuture::complete));
            requestResourceFuture.thenApply(workerNode -> context.runInMainThread(() -> {
                context.getDriver().releaseResource(workerNode);
                releaseResourceFuture.complete(workerNode);
            }));
            ResourceIDRetrievable worker = (ResourceIDRetrievable)releaseResourceFuture.get(5L, TimeUnit.SECONDS);
            context.validateReleaseResources(Collections.singleton(worker));
        });
    }

    protected abstract Context createContext();

    protected abstract class Context {
        protected final Configuration flinkConfig = new Configuration();
        protected final TestingResourceEventHandler.Builder<WorkerType> resourceEventHandlerBuilder = TestingResourceEventHandler.builder();
        private ResourceManagerDriver<WorkerType> driver;
        private ScheduledExecutor mainThreadExecutor;
        private BlockedNodeRetriever blockedNodeRetriever = () -> Collections.emptySet();

        protected Context() {
        }

        protected ResourceManagerDriver<WorkerType> getDriver() {
            return this.driver;
        }

        public void setBlockedNodeRetriever(BlockedNodeRetriever blockedNodeRetriever) {
            this.blockedNodeRetriever = blockedNodeRetriever;
        }

        protected final void runTest(RunnableWithException testMethod) throws Exception {
            this.prepareRunTest();
            this.driver = this.createResourceManagerDriver();
            this.mainThreadExecutor = MAIN_THREAD_EXECUTOR;
            this.driver.initialize(this.resourceEventHandlerBuilder.build(), this.mainThreadExecutor, (Executor)ForkJoinPool.commonPool(), this.blockedNodeRetriever);
            testMethod.run();
        }

        protected final CompletableFuture<Void> runInMainThread(RunnableWithException command) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            this.mainThreadExecutor.execute(() -> {
                try {
                    command.run();
                    future.complete(null);
                }
                catch (Throwable e) {
                    future.completeExceptionally(e);
                }
            });
            return future;
        }

        protected final <T> CompletableFuture<T> runInMainThread(Supplier<T> supplier) {
            return CompletableFuture.supplyAsync(supplier, (Executor)this.mainThreadExecutor);
        }

        protected final void validateInMainThread() {
            Assertions.assertThat((String)Thread.currentThread().getName()).isEqualTo(ResourceManagerDriverTestBase.MAIN_THREAD_NAME);
        }

        protected abstract void prepareRunTest() throws Exception;

        protected abstract ResourceManagerDriver<WorkerType> createResourceManagerDriver();

        protected abstract void preparePreviousAttemptWorkers();

        protected abstract void validateInitialization() throws Exception;

        protected abstract void validateWorkersRecoveredFromPreviousAttempt(Collection<WorkerType> var1);

        protected abstract void validateTermination() throws Exception;

        protected abstract void validateDeregisterApplication() throws Exception;

        protected abstract void validateRequestedResources(Collection<TaskExecutorProcessSpec> var1) throws Exception;

        protected abstract void validateReleaseResources(Collection<WorkerType> var1) throws Exception;
    }
}

