/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.util.Collections;
import java.util.HashMap;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.runtime.accumulators.StringifiedAccumulatorResult;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.executiongraph.ArchivedExecution;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionVertex;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.executiongraph.ExecutionHistory;
import org.apache.flink.runtime.executiongraph.IOMetrics;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerConfiguration;
import org.apache.flink.runtime.rest.handler.job.SubtaskCurrentAttemptDetailsHandler;
import org.apache.flink.runtime.rest.handler.legacy.DefaultExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcherImpl;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.job.SubtaskCurrentAttemptDetailsHeaders;
import org.apache.flink.runtime.rest.messages.job.SubtaskExecutionAttemptDetailsInfo;
import org.apache.flink.runtime.rest.messages.job.SubtaskMessageParameters;
import org.apache.flink.runtime.rest.messages.job.metrics.IOMetricsInfo;
import org.apache.flink.runtime.taskmanager.LocalTaskManagerLocation;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.concurrent.Executors;
import org.junit.Assert;
import org.junit.Test;

public class SubtaskCurrentAttemptDetailsHandlerTest
extends TestLogger {
    @Test
    public void testHandleRequest() throws Exception {
        JobID jobID = new JobID();
        JobVertexID jobVertexID = new JobVertexID();
        long deployingTs = System.currentTimeMillis() - 1024L;
        long finishedTs = System.currentTimeMillis();
        long bytesIn = 1L;
        long bytesOut = 10L;
        long recordsIn = 20L;
        long recordsOut = 30L;
        long accumulateIdleTime = 40L;
        long accumulateBusyTime = 50L;
        long accumulateBackPressuredTime = 60L;
        IOMetrics ioMetrics = new IOMetrics(1L, 10L, 20L, 30L, 40L, 50L, 60L);
        long[] timestamps = new long[ExecutionState.values().length];
        long[] endTimestamps = new long[ExecutionState.values().length];
        timestamps[ExecutionState.DEPLOYING.ordinal()] = deployingTs;
        endTimestamps[ExecutionState.DEPLOYING.ordinal()] = deployingTs + 10L;
        ExecutionState expectedState = ExecutionState.FINISHED;
        timestamps[expectedState.ordinal()] = finishedTs;
        LocalTaskManagerLocation assignedResourceLocation = new LocalTaskManagerLocation();
        AllocationID allocationID = new AllocationID();
        boolean subtaskIndex = true;
        int attempt = 2;
        ArchivedExecution execution = new ArchivedExecution(new StringifiedAccumulatorResult[0], ioMetrics, ExecutionGraphTestUtils.createExecutionAttemptId(jobVertexID, 1, 2), expectedState, null, (TaskManagerLocation)assignedResourceLocation, allocationID, timestamps, endTimestamps);
        ArchivedExecutionVertex executionVertex = new ArchivedExecutionVertex(1, "Test archived execution vertex", execution, new ExecutionHistory(0));
        RestHandlerConfiguration restHandlerConfiguration = RestHandlerConfiguration.fromConfiguration((Configuration)new Configuration());
        MetricFetcherImpl metricFetcher = new MetricFetcherImpl(() -> null, address -> null, Executors.directExecutor(), Time.milliseconds((long)1000L), ((Long)MetricOptions.METRIC_FETCHER_UPDATE_INTERVAL.defaultValue()).longValue());
        SubtaskCurrentAttemptDetailsHandler handler = new SubtaskCurrentAttemptDetailsHandler(() -> null, Time.milliseconds((long)100L), Collections.emptyMap(), (MessageHeaders)SubtaskCurrentAttemptDetailsHeaders.getInstance(), (ExecutionGraphCache)new DefaultExecutionGraphCache(restHandlerConfiguration.getTimeout(), Time.milliseconds((long)restHandlerConfiguration.getRefreshInterval())), Executors.directExecutor(), (MetricFetcher)metricFetcher);
        HashMap<String, String> receivedPathParameters = new HashMap<String, String>(2);
        receivedPathParameters.put("jobid", jobID.toString());
        receivedPathParameters.put("vertexid", jobVertexID.toString());
        HandlerRequest request = HandlerRequest.resolveParametersAndCreate((RequestBody)EmptyRequestBody.getInstance(), (MessageParameters)new SubtaskMessageParameters(), receivedPathParameters, Collections.emptyMap(), Collections.emptyList());
        SubtaskExecutionAttemptDetailsInfo detailsInfo = handler.handleRequest(request, (AccessExecutionVertex)executionVertex);
        IOMetricsInfo ioMetricsInfo = new IOMetricsInfo(1L, true, 10L, true, 20L, true, 30L, true, 60L, 40L, 50.0);
        HashMap<ExecutionState, Long> statusDuration = new HashMap<ExecutionState, Long>();
        statusDuration.put(ExecutionState.CREATED, -1L);
        statusDuration.put(ExecutionState.SCHEDULED, -1L);
        statusDuration.put(ExecutionState.DEPLOYING, 10L);
        statusDuration.put(ExecutionState.INITIALIZING, -1L);
        statusDuration.put(ExecutionState.RUNNING, -1L);
        SubtaskExecutionAttemptDetailsInfo expectedDetailsInfo = new SubtaskExecutionAttemptDetailsInfo(1, expectedState, 2, assignedResourceLocation.getHostname(), deployingTs, finishedTs, finishedTs - deployingTs, ioMetricsInfo, assignedResourceLocation.getResourceID().getResourceIdString(), statusDuration, null);
        Assert.assertEquals((Object)expectedDetailsInfo, (Object)detailsInfo);
    }
}

