/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.rest.messages.AggregatedTaskDetailsInfo;
import org.apache.flink.runtime.rest.messages.RestResponseMarshallingTestBase;
import org.apache.flink.runtime.rest.messages.job.SubtaskExecutionAttemptDetailsInfo;
import org.apache.flink.runtime.rest.messages.job.metrics.IOMetricsInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AggregatedTaskDetailsInfoTest
extends RestResponseMarshallingTestBase<AggregatedTaskDetailsInfo> {
    @Override
    protected Class<AggregatedTaskDetailsInfo> getTestResponseClass() {
        return AggregatedTaskDetailsInfo.class;
    }

    @Override
    protected AggregatedTaskDetailsInfo getTestResponseInstance() throws Exception {
        Random random = new Random();
        IOMetricsInfo ioMetricsInfo = new IOMetricsInfo(Math.abs(random.nextLong()), random.nextBoolean(), Math.abs(random.nextLong()), random.nextBoolean(), Math.abs(random.nextLong()), random.nextBoolean(), Math.abs(random.nextLong()), random.nextBoolean(), Math.abs(random.nextLong()), Math.abs(random.nextLong()), Math.abs(random.nextDouble()));
        HashMap<ExecutionState, Long> statusDuration = new HashMap<ExecutionState, Long>();
        statusDuration.put(ExecutionState.CREATED, 10L);
        statusDuration.put(ExecutionState.SCHEDULED, 20L);
        statusDuration.put(ExecutionState.DEPLOYING, 30L);
        statusDuration.put(ExecutionState.INITIALIZING, 40L);
        statusDuration.put(ExecutionState.RUNNING, 50L);
        return AggregatedTaskDetailsInfo.create(Collections.singletonList(new SubtaskExecutionAttemptDetailsInfo(Math.abs(random.nextInt()), ExecutionState.values()[random.nextInt(ExecutionState.values().length)], Math.abs(random.nextInt()), "localhost:" + random.nextInt(65536), Math.abs(random.nextLong()), Math.abs(random.nextLong()), Math.abs(random.nextLong()), ioMetricsInfo, "taskmanagerId", statusDuration, null)));
    }

    @Test
    public void testMetricsStatistics() {
        AggregatedTaskDetailsInfo.MetricsStatistics metricsStatistics = new AggregatedTaskDetailsInfo.MetricsStatistics("test");
        for (int i = 0; i < 100; ++i) {
            metricsStatistics.addValue((long)i);
        }
        Assertions.assertEquals((long)0L, (long)metricsStatistics.getMin());
        Assertions.assertEquals((long)99L, (long)metricsStatistics.getMax());
        Assertions.assertEquals((long)49L, (long)metricsStatistics.getPercentile(50));
        Assertions.assertEquals((long)24L, (long)metricsStatistics.getPercentile(25));
        Assertions.assertEquals((long)74L, (long)metricsStatistics.getPercentile(75));
        Assertions.assertEquals((long)94L, (long)metricsStatistics.getPercentile(95));
        Assertions.assertEquals((long)4950L, (long)metricsStatistics.getSum());
        Assertions.assertEquals((long)49L, (long)metricsStatistics.getAvg());
    }
}

