/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.json;

import org.apache.flink.runtime.rest.messages.json.SerializedThrowableDeserializer;
import org.apache.flink.runtime.rest.messages.json.SerializedThrowableSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.Module;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.flink.util.SerializedThrowable;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.jackson.JacksonMapperFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SerializedThrowableSerializerTest
extends TestLogger {
    private ObjectMapper objectMapper;

    @Before
    public void setUp() {
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addDeserializer(SerializedThrowable.class, (JsonDeserializer)new SerializedThrowableDeserializer());
        simpleModule.addSerializer(SerializedThrowable.class, (JsonSerializer)new SerializedThrowableSerializer());
        this.objectMapper = JacksonMapperFactory.createObjectMapper();
        this.objectMapper.registerModule((Module)simpleModule);
    }

    @Test
    public void testSerializationDeserialization() throws Exception {
        Exception cause = new Exception("cause");
        Exception root = new Exception("message", cause);
        Exception suppressed = new Exception("suppressed");
        root.addSuppressed(suppressed);
        SerializedThrowable serializedThrowable = new SerializedThrowable((Throwable)root);
        String json = this.objectMapper.writeValueAsString((Object)serializedThrowable);
        SerializedThrowable deserializedSerializedThrowable = (SerializedThrowable)this.objectMapper.readValue(json, SerializedThrowable.class);
        Assert.assertEquals((Object)"java.lang.Exception: message", (Object)deserializedSerializedThrowable.getMessage());
        Assert.assertEquals((Object)serializedThrowable.getFullStringifiedStackTrace(), (Object)deserializedSerializedThrowable.getFullStringifiedStackTrace());
        Assert.assertEquals((Object)"java.lang.Exception: cause", (Object)deserializedSerializedThrowable.getCause().getMessage());
        Assert.assertTrue((boolean)(deserializedSerializedThrowable.getCause() instanceof SerializedThrowable));
        Assert.assertEquals((long)1L, (long)deserializedSerializedThrowable.getSuppressed().length);
        Assert.assertEquals((Object)"java.lang.Exception: suppressed", (Object)deserializedSerializedThrowable.getSuppressed()[0].getMessage());
        Assert.assertTrue((boolean)(deserializedSerializedThrowable.getSuppressed()[0] instanceof SerializedThrowable));
    }
}

