/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.core.testutils.CompletedScheduledFuture;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutorServiceAdapter;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.scheduler.ExecutionGraphHandler;
import org.apache.flink.runtime.scheduler.GlobalFailureHandler;
import org.apache.flink.runtime.scheduler.OperatorCoordinatorHandler;
import org.apache.flink.runtime.scheduler.adaptive.CreatingExecutionGraph;
import org.apache.flink.runtime.scheduler.adaptive.State;
import org.apache.flink.runtime.scheduler.adaptive.StateTrackingMockExecutionGraph;
import org.apache.flink.runtime.scheduler.adaptive.StateValidator;
import org.apache.flink.runtime.scheduler.adaptive.TestingOperatorCoordinatorHandler;
import org.apache.flink.runtime.scheduler.adaptive.allocator.VertexParallelism;
import org.apache.flink.runtime.scheduler.exceptionhistory.ExceptionHistoryEntry;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.TestLoggerExtension;
import org.apache.flink.util.concurrent.Executors;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={TestLoggerExtension.class})
public class CreatingExecutionGraphTest
extends TestLogger {
    @Test
    public void testCancelTransitionsToFinished() throws Exception {
        try (MockCreatingExecutionGraphContext context = new MockCreatingExecutionGraphContext();){
            CreatingExecutionGraph creatingExecutionGraph = new CreatingExecutionGraph((CreatingExecutionGraph.Context)context, new CompletableFuture(), this.log, CreatingExecutionGraphTest::createTestingOperatorCoordinatorHandler);
            context.setExpectFinished(archivedExecutionGraph -> {
                AbstractComparableAssert cfr_ignored_0 = (AbstractComparableAssert)Assertions.assertThat((Comparable)archivedExecutionGraph.getState()).isEqualTo((Object)JobStatus.CANCELED);
            });
            creatingExecutionGraph.cancel();
        }
    }

    @Test
    public void testSuspendTransitionsToFinished() throws Exception {
        try (MockCreatingExecutionGraphContext context = new MockCreatingExecutionGraphContext();){
            CreatingExecutionGraph creatingExecutionGraph = new CreatingExecutionGraph((CreatingExecutionGraph.Context)context, new CompletableFuture(), this.log, CreatingExecutionGraphTest::createTestingOperatorCoordinatorHandler);
            context.setExpectFinished(archivedExecutionGraph -> {
                AbstractComparableAssert cfr_ignored_0 = (AbstractComparableAssert)Assertions.assertThat((Comparable)archivedExecutionGraph.getState()).isEqualTo((Object)JobStatus.SUSPENDED);
            });
            creatingExecutionGraph.suspend((Throwable)new FlinkException("Job has been suspended."));
        }
    }

    @Test
    public void testGlobalFailureTransitionsToFinished() throws Exception {
        try (MockCreatingExecutionGraphContext context = new MockCreatingExecutionGraphContext();){
            CreatingExecutionGraph creatingExecutionGraph = new CreatingExecutionGraph((CreatingExecutionGraph.Context)context, new CompletableFuture(), this.log, CreatingExecutionGraphTest::createTestingOperatorCoordinatorHandler);
            context.setExpectFinished(archivedExecutionGraph -> {
                AbstractComparableAssert cfr_ignored_0 = (AbstractComparableAssert)Assertions.assertThat((Comparable)archivedExecutionGraph.getState()).isEqualTo((Object)JobStatus.FAILED);
            });
            creatingExecutionGraph.handleGlobalFailure((Throwable)new FlinkException("Test exception"));
        }
    }

    @Test
    public void testFailedExecutionGraphCreationTransitionsToFinished() throws Exception {
        try (MockCreatingExecutionGraphContext context = new MockCreatingExecutionGraphContext();){
            CompletableFuture executionGraphWithVertexParallelismFuture = new CompletableFuture();
            new CreatingExecutionGraph((CreatingExecutionGraph.Context)context, executionGraphWithVertexParallelismFuture, this.log, CreatingExecutionGraphTest::createTestingOperatorCoordinatorHandler);
            context.setExpectFinished(archivedExecutionGraph -> {
                AbstractComparableAssert cfr_ignored_0 = (AbstractComparableAssert)Assertions.assertThat((Comparable)archivedExecutionGraph.getState()).isEqualTo((Object)JobStatus.FAILED);
            });
            executionGraphWithVertexParallelismFuture.completeExceptionally(new FlinkException("Test exception"));
        }
    }

    @Test
    public void testNotPossibleSlotAssignmentTransitionsToWaitingForResources() throws Exception {
        try (MockCreatingExecutionGraphContext context = new MockCreatingExecutionGraphContext();){
            CompletableFuture<CreatingExecutionGraph.ExecutionGraphWithVertexParallelism> executionGraphWithVertexParallelismFuture = new CompletableFuture<CreatingExecutionGraph.ExecutionGraphWithVertexParallelism>();
            new CreatingExecutionGraph((CreatingExecutionGraph.Context)context, executionGraphWithVertexParallelismFuture, this.log, CreatingExecutionGraphTest::createTestingOperatorCoordinatorHandler);
            context.setTryToAssignSlotsFunction(ignored -> CreatingExecutionGraph.AssignmentResult.notPossible());
            context.setExpectWaitingForResources();
            executionGraphWithVertexParallelismFuture.complete(CreatingExecutionGraph.ExecutionGraphWithVertexParallelism.create((ExecutionGraph)new StateTrackingMockExecutionGraph(), (VertexParallelism)new TestingVertexParallelism()));
        }
    }

    @Test
    public void testSuccessfulSlotAssignmentTransitionsToExecuting() throws Exception {
        try (MockCreatingExecutionGraphContext context = new MockCreatingExecutionGraphContext();){
            CompletableFuture<CreatingExecutionGraph.ExecutionGraphWithVertexParallelism> executionGraphWithVertexParallelismFuture = new CompletableFuture<CreatingExecutionGraph.ExecutionGraphWithVertexParallelism>();
            new CreatingExecutionGraph((CreatingExecutionGraph.Context)context, executionGraphWithVertexParallelismFuture, this.log, CreatingExecutionGraphTest::createTestingOperatorCoordinatorHandler);
            StateTrackingMockExecutionGraph executionGraph = new StateTrackingMockExecutionGraph();
            context.setTryToAssignSlotsFunction(CreatingExecutionGraphTest::successfulAssignment);
            context.setExpectedExecuting(actualExecutionGraph -> {
                ObjectAssert cfr_ignored_0 = (ObjectAssert)Assertions.assertThat((Object)actualExecutionGraph).isEqualTo((Object)executionGraph);
            });
            executionGraphWithVertexParallelismFuture.complete(CreatingExecutionGraph.ExecutionGraphWithVertexParallelism.create((ExecutionGraph)executionGraph, (VertexParallelism)new TestingVertexParallelism()));
        }
    }

    @Test
    public void testOperatorCoordinatorUsesFailureHandlerOfTheCurrentState() throws Exception {
        try (MockCreatingExecutionGraphContext context = new MockCreatingExecutionGraphContext();){
            CompletableFuture<CreatingExecutionGraph.ExecutionGraphWithVertexParallelism> executionGraphWithVertexParallelismFuture = new CompletableFuture<CreatingExecutionGraph.ExecutionGraphWithVertexParallelism>();
            AtomicReference operatorCoordinatorGlobalFailureHandlerRef = new AtomicReference();
            new CreatingExecutionGraph((CreatingExecutionGraph.Context)context, executionGraphWithVertexParallelismFuture, this.log, (executionGraph, errorHandler) -> {
                operatorCoordinatorGlobalFailureHandlerRef.set(errorHandler);
                return new TestingOperatorCoordinatorHandler();
            });
            StateTrackingMockExecutionGraph executionGraph2 = new StateTrackingMockExecutionGraph();
            context.setTryToAssignSlotsFunction(CreatingExecutionGraphTest::successfulAssignment);
            context.setExpectedExecuting(actualExecutionGraph -> {
                ObjectAssert cfr_ignored_0 = (ObjectAssert)Assertions.assertThat((Object)actualExecutionGraph).isEqualTo((Object)executionGraph2);
            });
            executionGraphWithVertexParallelismFuture.complete(CreatingExecutionGraph.ExecutionGraphWithVertexParallelism.create((ExecutionGraph)executionGraph2, (VertexParallelism)new TestingVertexParallelism()));
            Assertions.assertThat(operatorCoordinatorGlobalFailureHandlerRef.get()).isSameAs((Object)context);
        }
    }

    private static CreatingExecutionGraph.AssignmentResult successfulAssignment(CreatingExecutionGraph.ExecutionGraphWithVertexParallelism executionGraphWithVertexParallelism) {
        return CreatingExecutionGraph.AssignmentResult.success((ExecutionGraph)executionGraphWithVertexParallelism.getExecutionGraph());
    }

    private static OperatorCoordinatorHandler createTestingOperatorCoordinatorHandler(ExecutionGraph executionGraph, GlobalFailureHandler globalFailureHandler) {
        return new TestingOperatorCoordinatorHandler();
    }

    static final class TestingVertexParallelism
    implements VertexParallelism {
        TestingVertexParallelism() {
        }

        public Map<JobVertexID, Integer> getMaxParallelismForVertices() {
            throw new UnsupportedOperationException("Is not supported");
        }

        public int getParallelism(JobVertexID jobVertexId) {
            throw new UnsupportedOperationException("Is not supported");
        }
    }

    static class MockCreatingExecutionGraphContext
    implements CreatingExecutionGraph.Context,
    AutoCloseable {
        private final StateValidator<ArchivedExecutionGraph> finishedStateValidator = new StateValidator("Finished");
        private final StateValidator<Void> waitingForResourcesStateValidator = new StateValidator("WaitingForResources");
        private final StateValidator<ExecutionGraph> executingStateValidator = new StateValidator("Executing");
        private Function<CreatingExecutionGraph.ExecutionGraphWithVertexParallelism, CreatingExecutionGraph.AssignmentResult> tryToAssignSlotsFunction = e -> CreatingExecutionGraph.AssignmentResult.success((ExecutionGraph)e.getExecutionGraph());
        private GlobalFailureHandler globalFailureHandler = t -> {};
        private boolean hadStateTransitionHappened = false;

        MockCreatingExecutionGraphContext() {
        }

        public void setExpectFinished(Consumer<ArchivedExecutionGraph> asserter) {
            this.finishedStateValidator.expectInput(asserter);
        }

        public void setExpectWaitingForResources() {
            this.waitingForResourcesStateValidator.expectInput(none -> {});
        }

        public void setExpectedExecuting(Consumer<ExecutionGraph> asserter) {
            this.executingStateValidator.expectInput(asserter);
        }

        public void setTryToAssignSlotsFunction(Function<CreatingExecutionGraph.ExecutionGraphWithVertexParallelism, CreatingExecutionGraph.AssignmentResult> tryToAssignSlotsFunction) {
            this.tryToAssignSlotsFunction = tryToAssignSlotsFunction;
        }

        public void setGlobalFailureHandler(GlobalFailureHandler globalFailureHandler) {
            this.globalFailureHandler = globalFailureHandler;
        }

        public void goToFinished(ArchivedExecutionGraph archivedExecutionGraph) {
            this.finishedStateValidator.validateInput(archivedExecutionGraph);
            this.hadStateTransitionHappened = true;
        }

        public void goToExecuting(ExecutionGraph executionGraph, ExecutionGraphHandler executionGraphHandler, OperatorCoordinatorHandler operatorCoordinatorHandler, List<ExceptionHistoryEntry> failureCollection) {
            this.executingStateValidator.validateInput(executionGraph);
            this.hadStateTransitionHappened = true;
        }

        public ArchivedExecutionGraph getArchivedExecutionGraph(JobStatus jobStatus, @Nullable Throwable cause) {
            return ArchivedExecutionGraph.createSparseArchivedExecutionGraph((JobID)new JobID(), (String)"testJob", (JobStatus)jobStatus, (Throwable)cause, null, (long)0L);
        }

        public ScheduledFuture<?> runIfState(State expectedState, Runnable action, Duration delay) {
            if (!this.hadStateTransitionHappened) {
                action.run();
            }
            return CompletedScheduledFuture.create(null);
        }

        public void handleGlobalFailure(Throwable cause) {
            this.globalFailureHandler.handleGlobalFailure(cause);
        }

        public CreatingExecutionGraph.AssignmentResult tryToAssignSlots(CreatingExecutionGraph.ExecutionGraphWithVertexParallelism executionGraphWithVertexParallelism) {
            return this.tryToAssignSlotsFunction.apply(executionGraphWithVertexParallelism);
        }

        public void goToWaitingForResources() {
            this.waitingForResourcesStateValidator.validateInput(null);
            this.hadStateTransitionHappened = true;
        }

        public Executor getIOExecutor() {
            return Executors.directExecutor();
        }

        public ComponentMainThreadExecutor getMainThreadExecutor() {
            return ComponentMainThreadExecutorServiceAdapter.forMainThread();
        }

        @Override
        public void close() throws Exception {
            this.finishedStateValidator.close();
            this.waitingForResourcesStateValidator.close();
            this.executingStateValidator.close();
        }
    }
}

