/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.StateSerializerProvider;
import org.apache.flink.runtime.testutils.statemigration.TestType;
import org.junit.Assert;
import org.junit.Test;

public class StateSerializerProviderTest {
    @Test
    public void testCurrentSchemaSerializerForEagerlyRegisteredStateSerializerProvider() {
        StateSerializerProvider testProvider = StateSerializerProvider.fromNewRegisteredSerializer((TypeSerializer)new TestType.V1TestTypeSerializer());
        Assert.assertTrue((boolean)(testProvider.currentSchemaSerializer() instanceof TestType.V1TestTypeSerializer));
    }

    @Test
    public void testCurrentSchemaSerializerForLazilyRegisteredStateSerializerProvider() {
        TestType.V1TestTypeSerializer serializer = new TestType.V1TestTypeSerializer();
        StateSerializerProvider testProvider = StateSerializerProvider.fromPreviousSerializerSnapshot(serializer.snapshotConfiguration());
        Assert.assertTrue((boolean)(testProvider.currentSchemaSerializer() instanceof TestType.V1TestTypeSerializer));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testPreviousSchemaSerializerForEagerlyRegisteredStateSerializerProvider() {
        StateSerializerProvider testProvider = StateSerializerProvider.fromNewRegisteredSerializer((TypeSerializer)new TestType.V1TestTypeSerializer());
        testProvider.previousSchemaSerializer();
    }

    @Test
    public void testPreviousSchemaSerializerForLazilyRegisteredStateSerializerProvider() {
        TestType.V1TestTypeSerializer serializer = new TestType.V1TestTypeSerializer();
        StateSerializerProvider testProvider = StateSerializerProvider.fromPreviousSerializerSnapshot(serializer.snapshotConfiguration());
        Assert.assertTrue((boolean)(testProvider.previousSchemaSerializer() instanceof TestType.V1TestTypeSerializer));
    }

    @Test
    public void testLazyInstantiationOfPreviousSchemaSerializer() {
        StateSerializerProvider testProvider = StateSerializerProvider.fromPreviousSerializerSnapshot((TypeSerializerSnapshot)new ExceptionThrowingSerializerSnapshot());
        try {
            testProvider.previousSchemaSerializer();
            Assert.fail((String)"expected to fail when accessing the restore serializer.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRegisterNewSerializerWithEagerlyRegisteredStateSerializerProviderShouldFail() {
        StateSerializerProvider testProvider = StateSerializerProvider.fromNewRegisteredSerializer((TypeSerializer)new TestType.V1TestTypeSerializer());
        testProvider.registerNewSerializerForRestoredState((TypeSerializer)new TestType.V2TestTypeSerializer());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRegisterNewSerializerTwiceWithLazilyRegisteredStateSerializerProviderShouldFail() {
        TestType.V1TestTypeSerializer serializer = new TestType.V1TestTypeSerializer();
        StateSerializerProvider testProvider = StateSerializerProvider.fromPreviousSerializerSnapshot(serializer.snapshotConfiguration());
        testProvider.registerNewSerializerForRestoredState((TypeSerializer)new TestType.V2TestTypeSerializer());
        testProvider.registerNewSerializerForRestoredState((TypeSerializer)new TestType.V2TestTypeSerializer());
    }

    @Test
    public void testLazilyRegisterNewCompatibleAsIsSerializer() {
        TestType.V1TestTypeSerializer serializer = new TestType.V1TestTypeSerializer();
        StateSerializerProvider testProvider = StateSerializerProvider.fromPreviousSerializerSnapshot(serializer.snapshotConfiguration());
        TypeSerializerSchemaCompatibility schemaCompatibility = testProvider.registerNewSerializerForRestoredState((TypeSerializer)new TestType.V1TestTypeSerializer());
        Assert.assertTrue((boolean)schemaCompatibility.isCompatibleAsIs());
        Assert.assertTrue((boolean)(testProvider.currentSchemaSerializer() instanceof TestType.V1TestTypeSerializer));
        Assert.assertTrue((boolean)(testProvider.previousSchemaSerializer() instanceof TestType.V1TestTypeSerializer));
    }

    @Test
    public void testLazilyRegisterNewCompatibleAfterMigrationSerializer() {
        TestType.V1TestTypeSerializer serializer = new TestType.V1TestTypeSerializer();
        StateSerializerProvider testProvider = StateSerializerProvider.fromPreviousSerializerSnapshot(serializer.snapshotConfiguration());
        TypeSerializerSchemaCompatibility schemaCompatibility = testProvider.registerNewSerializerForRestoredState((TypeSerializer)new TestType.V2TestTypeSerializer());
        Assert.assertTrue((boolean)schemaCompatibility.isCompatibleAfterMigration());
        Assert.assertTrue((boolean)(testProvider.currentSchemaSerializer() instanceof TestType.V2TestTypeSerializer));
        Assert.assertTrue((boolean)(testProvider.previousSchemaSerializer() instanceof TestType.V1TestTypeSerializer));
    }

    @Test
    public void testLazilyRegisterNewSerializerRequiringReconfiguration() {
        TestType.V1TestTypeSerializer serializer = new TestType.V1TestTypeSerializer();
        StateSerializerProvider testProvider = StateSerializerProvider.fromPreviousSerializerSnapshot(serializer.snapshotConfiguration());
        TypeSerializerSchemaCompatibility schemaCompatibility = testProvider.registerNewSerializerForRestoredState((TypeSerializer)new TestType.ReconfigurationRequiringTestTypeSerializer());
        Assert.assertTrue((boolean)schemaCompatibility.isCompatibleWithReconfiguredSerializer());
        Assert.assertTrue((testProvider.currentSchemaSerializer().getClass() == TestType.V1TestTypeSerializer.class ? 1 : 0) != 0);
    }

    @Test
    public void testLazilyRegisterIncompatibleSerializer() {
        TestType.V1TestTypeSerializer serializer = new TestType.V1TestTypeSerializer();
        StateSerializerProvider testProvider = StateSerializerProvider.fromPreviousSerializerSnapshot(serializer.snapshotConfiguration());
        TypeSerializerSchemaCompatibility schemaCompatibility = testProvider.registerNewSerializerForRestoredState((TypeSerializer)new TestType.IncompatibleTestTypeSerializer());
        Assert.assertTrue((boolean)schemaCompatibility.isIncompatible());
        try {
            testProvider.currentSchemaSerializer();
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSetSerializerSnapshotWithLazilyRegisteredSerializerProviderShouldFail() {
        TestType.V1TestTypeSerializer serializer = new TestType.V1TestTypeSerializer();
        StateSerializerProvider testProvider = StateSerializerProvider.fromPreviousSerializerSnapshot(serializer.snapshotConfiguration());
        testProvider.setPreviousSerializerSnapshotForRestoredState(serializer.snapshotConfiguration());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSetSerializerSnapshotTwiceWithEagerlyRegisteredSerializerProviderShouldFail() {
        TestType.V1TestTypeSerializer serializer = new TestType.V1TestTypeSerializer();
        StateSerializerProvider testProvider = StateSerializerProvider.fromNewRegisteredSerializer((TypeSerializer)serializer);
        testProvider.setPreviousSerializerSnapshotForRestoredState(serializer.snapshotConfiguration());
        testProvider.setPreviousSerializerSnapshotForRestoredState(serializer.snapshotConfiguration());
    }

    @Test
    public void testEagerlyRegisterNewCompatibleAsIsSerializer() {
        StateSerializerProvider testProvider = StateSerializerProvider.fromNewRegisteredSerializer((TypeSerializer)new TestType.V1TestTypeSerializer());
        TypeSerializerSchemaCompatibility schemaCompatibility = testProvider.setPreviousSerializerSnapshotForRestoredState(new TestType.V1TestTypeSerializer().snapshotConfiguration());
        Assert.assertTrue((boolean)schemaCompatibility.isCompatibleAsIs());
        Assert.assertTrue((boolean)(testProvider.currentSchemaSerializer() instanceof TestType.V1TestTypeSerializer));
        Assert.assertTrue((boolean)(testProvider.previousSchemaSerializer() instanceof TestType.V1TestTypeSerializer));
    }

    @Test
    public void testEagerlyRegisterCompatibleAfterMigrationSerializer() {
        StateSerializerProvider testProvider = StateSerializerProvider.fromNewRegisteredSerializer((TypeSerializer)new TestType.V2TestTypeSerializer());
        TypeSerializerSchemaCompatibility schemaCompatibility = testProvider.setPreviousSerializerSnapshotForRestoredState(new TestType.V1TestTypeSerializer().snapshotConfiguration());
        Assert.assertTrue((boolean)schemaCompatibility.isCompatibleAfterMigration());
        Assert.assertTrue((boolean)(testProvider.currentSchemaSerializer() instanceof TestType.V2TestTypeSerializer));
        Assert.assertTrue((boolean)(testProvider.previousSchemaSerializer() instanceof TestType.V1TestTypeSerializer));
    }

    @Test
    public void testEagerlyRegisterNewSerializerRequiringReconfiguration() {
        StateSerializerProvider testProvider = StateSerializerProvider.fromNewRegisteredSerializer((TypeSerializer)new TestType.ReconfigurationRequiringTestTypeSerializer());
        TypeSerializerSchemaCompatibility schemaCompatibility = testProvider.setPreviousSerializerSnapshotForRestoredState(new TestType.V1TestTypeSerializer().snapshotConfiguration());
        Assert.assertTrue((boolean)schemaCompatibility.isCompatibleWithReconfiguredSerializer());
        Assert.assertTrue((testProvider.currentSchemaSerializer().getClass() == TestType.V1TestTypeSerializer.class ? 1 : 0) != 0);
    }

    @Test
    public void testEagerlyRegisterIncompatibleSerializer() {
        StateSerializerProvider testProvider = StateSerializerProvider.fromNewRegisteredSerializer((TypeSerializer)new TestType.IncompatibleTestTypeSerializer());
        TypeSerializerSchemaCompatibility schemaCompatibility = testProvider.setPreviousSerializerSnapshotForRestoredState(new TestType.V1TestTypeSerializer().snapshotConfiguration());
        Assert.assertTrue((boolean)schemaCompatibility.isIncompatible());
        try {
            testProvider.currentSchemaSerializer();
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class ExceptionThrowingSerializerSnapshot
    implements TypeSerializerSnapshot<String> {
        public TypeSerializer<String> restoreSerializer() {
            throw new UnsupportedOperationException();
        }

        public void writeSnapshot(DataOutputView out) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
            throw new UnsupportedOperationException();
        }

        public TypeSerializerSchemaCompatibility<String> resolveSchemaCompatibility(TypeSerializer<String> newSerializer) {
            throw new UnsupportedOperationException();
        }

        public int getCurrentVersion() {
            throw new UnsupportedOperationException();
        }
    }
}

