/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.types;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.clusterframework.types.SlotProfileTestingUtils;
import org.apache.flink.runtime.clusterframework.types.SlotSelectionStrategyTestBase;
import org.apache.flink.runtime.jobmanager.scheduler.Locality;
import org.apache.flink.runtime.jobmaster.SlotInfo;
import org.apache.flink.runtime.jobmaster.slotpool.LocationPreferenceSlotSelectionStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.SlotSelectionStrategy;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.hamcrest.CoreMatchers;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class LocationPreferenceSlotSelectionStrategyTest
extends SlotSelectionStrategyTestBase {
    public LocationPreferenceSlotSelectionStrategyTest() {
        super((SlotSelectionStrategy)LocationPreferenceSlotSelectionStrategy.createDefault());
    }

    protected LocationPreferenceSlotSelectionStrategyTest(SlotSelectionStrategy slotSelectionStrategy) {
        super(slotSelectionStrategy);
    }

    @Test
    public void testPhysicalSlotResourceProfileRespected() {
        SlotProfile slotProfile = SlotProfile.priorAllocation((ResourceProfile)this.resourceProfile, (ResourceProfile)this.biggerResourceProfile, Collections.emptyList(), Collections.emptyList(), Collections.emptySet());
        Optional<SlotSelectionStrategy.SlotInfoAndLocality> match = this.runMatching(slotProfile);
        Assert.assertTrue((boolean)match.get().getSlotInfo().getResourceProfile().isMatching(slotProfile.getPhysicalSlotResourceProfile()));
        ResourceProfile evenBiggerResourceProfile = ResourceProfile.fromResources((double)(this.biggerResourceProfile.getCpuCores().getValue().doubleValue() + 1.0), (int)this.resourceProfile.getTaskHeapMemory().getMebiBytes());
        slotProfile = SlotProfile.priorAllocation((ResourceProfile)this.resourceProfile, (ResourceProfile)evenBiggerResourceProfile, Collections.emptyList(), Collections.emptyList(), Collections.emptySet());
        match = this.runMatching(slotProfile);
        Assert.assertFalse((boolean)match.isPresent());
    }

    @Test
    public void matchNoRequirements() {
        SlotProfile slotProfile = SlotProfileTestingUtils.noRequirements();
        Optional<SlotSelectionStrategy.SlotInfoAndLocality> match = this.runMatching(slotProfile);
        Assert.assertTrue((boolean)match.isPresent());
        SlotSelectionStrategy.SlotInfoAndLocality slotInfoAndLocality = match.get();
        Assert.assertThat((Object)this.candidates, (Matcher)CoreMatchers.hasItem(this.withSlotInfo(slotInfoAndLocality.getSlotInfo())));
        Assert.assertThat((Object)slotInfoAndLocality, this.hasLocality(Locality.UNCONSTRAINED));
    }

    @Test
    public void returnsHostLocalMatchingIfExactTMLocationCannotBeFulfilled() {
        SlotProfile slotProfile = SlotProfileTestingUtils.preferredLocality(this.resourceProfile, Collections.singletonList(this.tmlX));
        Optional<SlotSelectionStrategy.SlotInfoAndLocality> match = this.runMatching(slotProfile);
        Assert.assertTrue((boolean)match.isPresent());
        SlotSelectionStrategy.SlotInfoAndLocality slotInfoAndLocality = match.get();
        SlotInfo slotInfo = slotInfoAndLocality.getSlotInfo();
        Assert.assertThat((Object)this.candidates, (Matcher)CoreMatchers.hasItem(this.withSlotInfo(slotInfo)));
        Assert.assertThat((Object)slotInfoAndLocality, this.hasLocality(Locality.HOST_LOCAL));
    }

    private Matcher<SlotSelectionStrategy.SlotInfoAndLocality> hasLocality(Locality locality) {
        return new LocalityFeatureMatcher(locality);
    }

    private Matcher<SlotSelectionStrategy.SlotInfoAndResources> withSlotInfo(SlotInfo slotInfo) {
        return new SlotInfoFeatureMatcher(slotInfo);
    }

    @Test
    public void returnsNonLocalMatchingIfResourceProfileCanBeFulfilledButNotTheTMLocationPreferences() throws Exception {
        InetAddress nonHostLocalInetAddress = InetAddress.getByAddress(new byte[]{10, 0, 0, 24});
        TaskManagerLocation nonLocalTm = new TaskManagerLocation(new ResourceID("non-local-tm"), nonHostLocalInetAddress, 42);
        SlotProfile slotProfile = SlotProfileTestingUtils.preferredLocality(this.resourceProfile, Collections.singletonList(nonLocalTm));
        Optional<SlotSelectionStrategy.SlotInfoAndLocality> match = this.runMatching(slotProfile);
        Assert.assertTrue((boolean)match.isPresent());
        SlotSelectionStrategy.SlotInfoAndLocality slotInfoAndLocality = match.get();
        Assert.assertThat((Object)this.candidates, (Matcher)CoreMatchers.hasItem(this.withSlotInfo(slotInfoAndLocality.getSlotInfo())));
        Assert.assertThat((Object)slotInfoAndLocality, this.hasLocality(Locality.NON_LOCAL));
    }

    @Test
    public void matchPreferredLocation() {
        SlotProfile slotProfile = SlotProfileTestingUtils.preferredLocality(this.biggerResourceProfile, Collections.singletonList(this.tml2));
        Optional<SlotSelectionStrategy.SlotInfoAndLocality> match = this.runMatching(slotProfile);
        Assert.assertEquals((Object)this.slotInfo2, (Object)match.get().getSlotInfo());
        slotProfile = SlotProfileTestingUtils.preferredLocality(this.resourceProfile, Arrays.asList(this.tmlX, this.tml4));
        match = this.runMatching(slotProfile);
        Assert.assertEquals((Object)this.slotInfo4, (Object)match.get().getSlotInfo());
        slotProfile = SlotProfileTestingUtils.preferredLocality(this.resourceProfile, Arrays.asList(this.tml3, this.tml1, this.tml3, this.tmlX));
        match = this.runMatching(slotProfile);
        Assert.assertEquals((Object)this.slotInfo3, (Object)match.get().getSlotInfo());
    }

    @Test
    public void matchPreviousLocationAvailableButAlsoBlacklisted() {
        HashSet<AllocationID> blacklisted = new HashSet<AllocationID>(4);
        blacklisted.add(this.aid1);
        blacklisted.add(this.aid2);
        blacklisted.add(this.aid3);
        blacklisted.add(this.aid4);
        SlotProfile slotProfile = SlotProfile.priorAllocation((ResourceProfile)this.resourceProfile, (ResourceProfile)this.resourceProfile, Collections.singletonList(this.tml3), Collections.singletonList(this.aid3), blacklisted);
        Optional<SlotSelectionStrategy.SlotInfoAndLocality> match = this.runMatching(slotProfile);
        Assert.assertEquals((Object)this.slotInfo3, (Object)match.get().getSlotInfo());
    }

    private static class LocalityFeatureMatcher
    extends FeatureMatcher<SlotSelectionStrategy.SlotInfoAndLocality, Locality> {
        LocalityFeatureMatcher(Locality locality) {
            super(CoreMatchers.is((Object)locality), "Locality of SlotInfoAndLocality instance", "locality");
        }

        protected Locality featureValueOf(SlotSelectionStrategy.SlotInfoAndLocality actual) {
            return actual.getLocality();
        }
    }

    private static class SlotInfoFeatureMatcher
    extends FeatureMatcher<SlotSelectionStrategy.SlotInfoAndResources, SlotInfo> {
        SlotInfoFeatureMatcher(SlotInfo slotInfo) {
            super(CoreMatchers.is((Object)slotInfo), "Slot info of a SlotInfoAndResources instance", "slotInfo");
        }

        protected SlotInfo featureValueOf(SlotSelectionStrategy.SlotInfoAndResources actual) {
            return actual.getSlotInfo();
        }
    }
}

