/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.changelog.inmemory;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.operators.MailboxExecutor;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.StateChangelogOptions;
import org.apache.flink.core.plugin.PluginManager;
import org.apache.flink.runtime.metrics.groups.TaskManagerJobMetricGroup;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.LocalRecoveryConfig;
import org.apache.flink.runtime.state.TestLocalRecoveryConfig;
import org.apache.flink.runtime.state.changelog.ChangelogStateHandle;
import org.apache.flink.runtime.state.changelog.StateChangelogHandleReader;
import org.apache.flink.runtime.state.changelog.StateChangelogStorage;
import org.apache.flink.runtime.state.changelog.StateChangelogStorageFactory;
import org.apache.flink.runtime.state.changelog.StateChangelogStorageLoader;
import org.apache.flink.runtime.state.changelog.StateChangelogStorageView;
import org.apache.flink.runtime.state.changelog.StateChangelogWriter;
import org.apache.flink.util.Preconditions;
import org.junit.Assert;
import org.junit.Test;

public class StateChangelogStorageLoaderTest {
    @Test
    public void testLoadSpiImplementation() throws IOException {
        StateChangelogStorageLoader.initialize((PluginManager)this.getPluginManager(Collections.emptyIterator()));
        Assert.assertNotNull((Object)StateChangelogStorageLoader.load((JobID)JobID.generate(), (Configuration)new Configuration(), (TaskManagerJobMetricGroup)UnregisteredMetricGroups.createUnregisteredTaskManagerJobMetricGroup(), (LocalRecoveryConfig)TestLocalRecoveryConfig.disabled()));
    }

    @Test
    public void testLoadNotExist() throws IOException {
        StateChangelogStorageLoader.initialize((PluginManager)this.getPluginManager(Collections.emptyIterator()));
        Assert.assertNull((Object)StateChangelogStorageLoader.load((JobID)JobID.generate(), (Configuration)new Configuration().set(StateChangelogOptions.STATE_CHANGE_LOG_STORAGE, (Object)"not_exist"), (TaskManagerJobMetricGroup)UnregisteredMetricGroups.createUnregisteredTaskManagerJobMetricGroup(), (LocalRecoveryConfig)TestLocalRecoveryConfig.disabled()));
    }

    @Test
    public void testLoadPluginImplementation() throws IOException {
        TestStateChangelogStorageFactory factory = new TestStateChangelogStorageFactory();
        PluginManager pluginManager = this.getPluginManager(Collections.singletonList(factory).iterator());
        StateChangelogStorageLoader.initialize((PluginManager)pluginManager);
        StateChangelogStorage loaded = StateChangelogStorageLoader.load((JobID)JobID.generate(), (Configuration)new Configuration(), (TaskManagerJobMetricGroup)UnregisteredMetricGroups.createUnregisteredTaskManagerJobMetricGroup(), (LocalRecoveryConfig)TestLocalRecoveryConfig.disabled());
        Assert.assertTrue((boolean)(loaded instanceof TestStateChangelogStorage));
    }

    private PluginManager getPluginManager(final Iterator<? extends StateChangelogStorageFactory> iterator) {
        return new PluginManager(){

            public <P> Iterator<P> load(Class<P> service) {
                Preconditions.checkArgument((boolean)service.equals(StateChangelogStorageFactory.class));
                return iterator;
            }
        };
    }

    private static class TestStateChangelogStorageFactory
    implements StateChangelogStorageFactory {
        private TestStateChangelogStorageFactory() {
        }

        public String getIdentifier() {
            return "memory";
        }

        public StateChangelogStorage<?> createStorage(JobID jobID, Configuration configuration, TaskManagerJobMetricGroup metricGroup, LocalRecoveryConfig localRecoveryConfig) {
            return new TestStateChangelogStorage();
        }

        public StateChangelogStorageView<?> createStorageView(Configuration configuration) throws IOException {
            return new TestStateChangelogStorage();
        }
    }

    private static class TestStateChangelogStorage
    implements StateChangelogStorage<ChangelogStateHandle> {
        private TestStateChangelogStorage() {
        }

        public StateChangelogWriter<ChangelogStateHandle> createWriter(String operatorID, KeyGroupRange keyGroupRange, MailboxExecutor mailboxExecutor) {
            return null;
        }

        public StateChangelogHandleReader<ChangelogStateHandle> createReader() {
            return null;
        }
    }
}

