/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.blob.TransientBlobKey;
import org.apache.flink.util.StringUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

final class BlobKeyTest {
    private static final byte[] KEY_ARRAY_1;
    private static final byte[] KEY_ARRAY_2;
    private static final byte[] RANDOM_ARRAY_1;
    private static final byte[] RANDOM_ARRAY_2;

    BlobKeyTest() {
    }

    @Test
    void testCreateKey() {
        BlobKey key = BlobKey.createKey((BlobKey.BlobType)BlobKey.BlobType.PERMANENT_BLOB, (byte[])KEY_ARRAY_1);
        BlobKeyTest.verifyType(BlobKey.BlobType.PERMANENT_BLOB, key);
        Assertions.assertThat((byte[])key.getHash()).isEqualTo((Object)KEY_ARRAY_1);
        key = BlobKey.createKey((BlobKey.BlobType)BlobKey.BlobType.TRANSIENT_BLOB, (byte[])KEY_ARRAY_1);
        BlobKeyTest.verifyType(BlobKey.BlobType.TRANSIENT_BLOB, key);
        Assertions.assertThat((byte[])key.getHash()).isEqualTo((Object)KEY_ARRAY_1);
    }

    @Test
    void testSerializationTransient() throws Exception {
        this.testSerialization(BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    void testSerializationPermanent() throws Exception {
        this.testSerialization(BlobKey.BlobType.PERMANENT_BLOB);
    }

    private void testSerialization(BlobKey.BlobType blobType) throws Exception {
        BlobKey k1 = BlobKey.createKey((BlobKey.BlobType)blobType, (byte[])KEY_ARRAY_1, (byte[])RANDOM_ARRAY_1);
        BlobKey k2 = (BlobKey)CommonTestUtils.createCopySerializable((Serializable)k1);
        Assertions.assertThat((Comparable)k2).isEqualTo((Object)k1);
        Assertions.assertThat((Comparable)k2).hasSameHashCodeAs((Object)k1);
        Assertions.assertThat((Comparable)k1).isEqualByComparingTo((Comparable)k2);
    }

    @Test
    void testEqualsTransient() {
        this.testEquals(BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    void testEqualsPermanent() {
        this.testEquals(BlobKey.BlobType.PERMANENT_BLOB);
    }

    private void testEquals(BlobKey.BlobType blobType) {
        BlobKey k1 = BlobKey.createKey((BlobKey.BlobType)blobType, (byte[])KEY_ARRAY_1, (byte[])RANDOM_ARRAY_1);
        BlobKey k2 = BlobKey.createKey((BlobKey.BlobType)blobType, (byte[])KEY_ARRAY_1, (byte[])RANDOM_ARRAY_1);
        BlobKey k3 = BlobKey.createKey((BlobKey.BlobType)blobType, (byte[])KEY_ARRAY_2, (byte[])RANDOM_ARRAY_1);
        BlobKey k4 = BlobKey.createKey((BlobKey.BlobType)blobType, (byte[])KEY_ARRAY_1, (byte[])RANDOM_ARRAY_2);
        Assertions.assertThat((Comparable)k1).isEqualTo((Object)k2);
        Assertions.assertThat((Comparable)k2).isEqualTo((Object)k1);
        Assertions.assertThat((Comparable)k2).hasSameHashCodeAs((Object)k1);
        Assertions.assertThat((Comparable)k1).isNotEqualTo((Object)k3);
        Assertions.assertThat((Comparable)k3).isNotEqualTo((Object)k1);
        Assertions.assertThat((Comparable)k1).isNotEqualTo((Object)k4);
        Assertions.assertThat((Comparable)k4).isNotEqualTo((Object)k1);
        Assertions.assertThat((Comparable)k1).isNotEqualTo(null);
        Assertions.assertThat((Comparable)k1).isNotEqualTo((Object)this);
    }

    @Test
    void testEqualsDifferentBlobType() {
        BlobKey k1 = BlobKey.createKey((BlobKey.BlobType)BlobKey.BlobType.TRANSIENT_BLOB, (byte[])KEY_ARRAY_1, (byte[])RANDOM_ARRAY_1);
        BlobKey k2 = BlobKey.createKey((BlobKey.BlobType)BlobKey.BlobType.PERMANENT_BLOB, (byte[])KEY_ARRAY_1, (byte[])RANDOM_ARRAY_1);
        Assertions.assertThat((Comparable)k1).isNotEqualTo((Object)k2);
        Assertions.assertThat((Comparable)k2).isNotEqualTo((Object)k1);
    }

    @Test
    void testComparesTransient() {
        this.testCompares(BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    void testComparesPermanent() {
        this.testCompares(BlobKey.BlobType.PERMANENT_BLOB);
    }

    private void testCompares(BlobKey.BlobType blobType) {
        BlobKey k1 = BlobKey.createKey((BlobKey.BlobType)blobType, (byte[])KEY_ARRAY_1, (byte[])RANDOM_ARRAY_1);
        BlobKey k2 = BlobKey.createKey((BlobKey.BlobType)blobType, (byte[])KEY_ARRAY_1, (byte[])RANDOM_ARRAY_1);
        BlobKey k3 = BlobKey.createKey((BlobKey.BlobType)blobType, (byte[])KEY_ARRAY_2, (byte[])RANDOM_ARRAY_1);
        BlobKey k4 = BlobKey.createKey((BlobKey.BlobType)blobType, (byte[])KEY_ARRAY_1, (byte[])RANDOM_ARRAY_2);
        Assertions.assertThat((Comparable)k1).isEqualByComparingTo((Comparable)k2);
        Assertions.assertThat((Comparable)k2).isEqualByComparingTo((Comparable)k1);
        Assertions.assertThat((Comparable)k1).isLessThan((Comparable)k3);
        Assertions.assertThat((Comparable)k1).isLessThan((Comparable)k4);
        Assertions.assertThat((Comparable)k3).isGreaterThan((Comparable)k1);
        Assertions.assertThat((Comparable)k4).isGreaterThan((Comparable)k1);
    }

    @Test
    void testComparesDifferentBlobType() {
        BlobKey k1 = BlobKey.createKey((BlobKey.BlobType)BlobKey.BlobType.TRANSIENT_BLOB, (byte[])KEY_ARRAY_1, (byte[])RANDOM_ARRAY_1);
        BlobKey k2 = BlobKey.createKey((BlobKey.BlobType)BlobKey.BlobType.PERMANENT_BLOB, (byte[])KEY_ARRAY_1, (byte[])RANDOM_ARRAY_1);
        Assertions.assertThat((Comparable)k1).isGreaterThan((Comparable)k2);
        Assertions.assertThat((Comparable)k2).isLessThan((Comparable)k1);
    }

    @Test
    void testStreamsTransient() throws Exception {
        this.testStreams(BlobKey.BlobType.TRANSIENT_BLOB);
    }

    @Test
    void testStreamsPermanent() throws Exception {
        this.testStreams(BlobKey.BlobType.PERMANENT_BLOB);
    }

    @Test
    void testToFromStringPermanentKey() {
        this.testToFromString(BlobKey.createKey((BlobKey.BlobType)BlobKey.BlobType.PERMANENT_BLOB));
    }

    @Test
    void testToFromStringTransientKey() {
        this.testToFromString(BlobKey.createKey((BlobKey.BlobType)BlobKey.BlobType.TRANSIENT_BLOB));
    }

    private void testToFromString(BlobKey blobKey) {
        String stringRepresentation = blobKey.toString();
        BlobKey parsedBlobKey = BlobKey.fromString((String)stringRepresentation);
        Assertions.assertThat((Comparable)blobKey).isEqualTo((Object)parsedBlobKey);
    }

    @Test
    void testFromStringFailsWithWrongInput() {
        Assertions.assertThatThrownBy(() -> BlobKey.fromString((String)"foobar")).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void testFromStringFailsWithInvalidBlobKeyType() {
        Assertions.assertThatThrownBy(() -> BlobKey.fromString((String)String.format("x-%s-%s", StringUtils.byteToHexString((byte[])KEY_ARRAY_1), StringUtils.byteToHexString((byte[])RANDOM_ARRAY_1)))).isInstanceOf(IllegalStateException.class);
    }

    private void testStreams(BlobKey.BlobType blobType) throws IOException {
        BlobKey k1 = BlobKey.createKey((BlobKey.BlobType)blobType, (byte[])KEY_ARRAY_1, (byte[])RANDOM_ARRAY_1);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(20);
        k1.writeToOutputStream((OutputStream)baos);
        baos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        BlobKey k2 = BlobKey.readFromInputStream((InputStream)bais);
        Assertions.assertThat((Comparable)k2).isEqualTo((Object)k1);
    }

    static void verifyKeyDifferentHashEquals(BlobKey key1, BlobKey key2) {
        Assertions.assertThat((Comparable)key1).isNotEqualTo((Object)key2);
        Assertions.assertThat((byte[])key1.getHash()).isEqualTo((Object)key2.getHash());
    }

    static void verifyKeyDifferentHashDifferent(BlobKey key1, BlobKey key2) {
        Assertions.assertThat((Comparable)key1).isNotEqualTo((Object)key2);
        Assertions.assertThat((byte[])key1.getHash()).isNotEqualTo((Object)key2.getHash());
    }

    static void verifyType(BlobKey.BlobType expected, BlobKey key) {
        if (expected == BlobKey.BlobType.PERMANENT_BLOB) {
            Assertions.assertThat((Comparable)key).isInstanceOf(PermanentBlobKey.class);
        } else {
            Assertions.assertThat((Comparable)key).isInstanceOf(TransientBlobKey.class);
        }
    }

    static {
        int i;
        KEY_ARRAY_1 = new byte[20];
        KEY_ARRAY_2 = new byte[20];
        RANDOM_ARRAY_1 = new byte[16];
        RANDOM_ARRAY_2 = new byte[16];
        for (i = 0; i < KEY_ARRAY_1.length; ++i) {
            BlobKeyTest.KEY_ARRAY_1[i] = (byte)i;
            BlobKeyTest.KEY_ARRAY_2[i] = (byte)(i + 1);
        }
        for (i = 0; i < RANDOM_ARRAY_1.length; ++i) {
            BlobKeyTest.RANDOM_ARRAY_1[i] = (byte)i;
            BlobKeyTest.RANDOM_ARRAY_2[i] = (byte)(i + 1);
        }
    }
}

