/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.entrypoint;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.runtime.entrypoint.FlinkParseException;
import org.apache.flink.runtime.entrypoint.ModifiableClusterConfiguration;
import org.apache.flink.runtime.entrypoint.ModifiableClusterConfigurationParserFactory;
import org.apache.flink.runtime.entrypoint.parser.CommandLineParser;
import org.apache.flink.runtime.entrypoint.parser.ParserResultFactory;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ModifiableClusterConfigurationParserFactoryTest {
    private static final CommandLineParser<ModifiableClusterConfiguration> commandLineParser = new CommandLineParser((ParserResultFactory)new ModifiableClusterConfigurationParserFactory());

    ModifiableClusterConfigurationParserFactoryTest() {
    }

    @Test
    void testModifiableClusterConfigurationParsing() throws FlinkParseException {
        String configDir = "/foo/bar";
        String key = "key";
        String value = "value";
        String newValue = "value2";
        String[] args = new String[]{"--configDir", "/foo/bar", "--removeKey", "key", String.format("-D%s=%s", "key", "value"), "--removeKeyValue", String.format("%s=%s", "key", "value"), "--replaceKeyValue", String.format("%s,%s,%s", "key", "value", "value2"), "--flattenConfig"};
        ModifiableClusterConfiguration modifiableClusterConfiguration = (ModifiableClusterConfiguration)commandLineParser.parse(args);
        Assertions.assertThat((String)modifiableClusterConfiguration.getConfigDir()).isEqualTo("/foo/bar");
        Properties dynamicProperties = modifiableClusterConfiguration.getDynamicProperties();
        Assertions.assertThat((Map)dynamicProperties).containsEntry((Object)"key", (Object)"value");
        List removeKeys = modifiableClusterConfiguration.getRemoveKeys();
        Assertions.assertThat((List)removeKeys).containsExactly((Object[])new String[]{"key"});
        Properties removeKeyValues = modifiableClusterConfiguration.getRemoveKeyValues();
        Assertions.assertThat((Map)removeKeyValues).containsEntry((Object)"key", (Object)"value");
        List replaceKeyValues = modifiableClusterConfiguration.getReplaceKeyValues();
        Assertions.assertThat((List)replaceKeyValues).containsExactly((Object[])new Tuple3[]{Tuple3.of((Object)"key", (Object)"value", (Object)"value2")});
        Assertions.assertThat((boolean)modifiableClusterConfiguration.flattenConfig()).isTrue();
    }

    @Test
    void testOnlyRequiredArguments() throws FlinkParseException {
        String configDir = "/foo/bar";
        String[] args = new String[]{"--configDir", "/foo/bar"};
        ModifiableClusterConfiguration modifiableClusterConfiguration = (ModifiableClusterConfiguration)commandLineParser.parse(args);
        Assertions.assertThat((String)modifiableClusterConfiguration.getConfigDir()).isEqualTo("/foo/bar");
    }

    @Test
    void testMissingRequiredArgument() {
        String[] args = new String[]{};
        Assertions.assertThatThrownBy(() -> {
            ModifiableClusterConfiguration cfr_ignored_0 = (ModifiableClusterConfiguration)commandLineParser.parse(args);
        }).isInstanceOf(FlinkParseException.class);
    }
}

