/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.runtime.executiongraph.failover.StronglyConnectedComponentsComputeUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class StronglyConnectedComponentsComputeUtilsTest {
    StronglyConnectedComponentsComputeUtilsTest() {
    }

    @Test
    void testWithCycles() {
        List<List> edges = Arrays.asList(Arrays.asList(2, 3), Arrays.asList(0), Arrays.asList(1), Arrays.asList(4), Collections.emptyList());
        Set result = StronglyConnectedComponentsComputeUtils.computeStronglyConnectedComponents((int)5, edges);
        HashSet<Set<Integer>> expected = new HashSet<Set<Integer>>();
        expected.add(new HashSet<Integer>(Arrays.asList(0, 1, 2)));
        expected.add(Collections.singleton(3));
        expected.add(Collections.singleton(4));
        Assertions.assertThat((Collection)result).isEqualTo(expected);
    }

    @Test
    void testWithMultipleCycles() {
        List<List> edges = Arrays.asList(Arrays.asList(1), Arrays.asList(2), Arrays.asList(0), Arrays.asList(1, 2, 4), Arrays.asList(3, 5), Arrays.asList(2, 6), Arrays.asList(5), Arrays.asList(4, 6, 7));
        Set result = StronglyConnectedComponentsComputeUtils.computeStronglyConnectedComponents((int)8, edges);
        HashSet<Set<Integer>> expected = new HashSet<Set<Integer>>();
        expected.add(new HashSet<Integer>(Arrays.asList(0, 1, 2)));
        expected.add(new HashSet<Integer>(Arrays.asList(3, 4)));
        expected.add(new HashSet<Integer>(Arrays.asList(5, 6)));
        expected.add(Collections.singleton(7));
        Assertions.assertThat((Collection)result).isEqualTo(expected);
    }

    @Test
    void testWithConnectedCycles() {
        List<List> edges = Arrays.asList(Arrays.asList(1), Arrays.asList(2, 4, 5), Arrays.asList(3, 6), Arrays.asList(2, 7), Arrays.asList(0, 5), Arrays.asList(6), Arrays.asList(5), Arrays.asList(3, 6));
        Set result = StronglyConnectedComponentsComputeUtils.computeStronglyConnectedComponents((int)8, edges);
        HashSet<HashSet<Integer>> expected = new HashSet<HashSet<Integer>>();
        expected.add(new HashSet<Integer>(Arrays.asList(0, 1, 4)));
        expected.add(new HashSet<Integer>(Arrays.asList(2, 3, 7)));
        expected.add(new HashSet<Integer>(Arrays.asList(5, 6)));
        Assertions.assertThat((Collection)result).isEqualTo(expected);
    }

    @Test
    void testWithNoEdge() {
        List<List> edges = Arrays.asList(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        Set result = StronglyConnectedComponentsComputeUtils.computeStronglyConnectedComponents((int)5, edges);
        HashSet<Set<Integer>> expected = new HashSet<Set<Integer>>();
        expected.add(Collections.singleton(0));
        expected.add(Collections.singleton(1));
        expected.add(Collections.singleton(2));
        expected.add(Collections.singleton(3));
        expected.add(Collections.singleton(4));
        Assertions.assertThat((Collection)result).isEqualTo(expected);
    }

    @Test
    void testWithNoCycle() {
        List<List> edges = Arrays.asList(Arrays.asList(1), Arrays.asList(2), Arrays.asList(3), Arrays.asList(4), Collections.emptyList());
        Set result = StronglyConnectedComponentsComputeUtils.computeStronglyConnectedComponents((int)5, edges);
        HashSet<Set<Integer>> expected = new HashSet<Set<Integer>>();
        expected.add(Collections.singleton(0));
        expected.add(Collections.singleton(1));
        expected.add(Collections.singleton(2));
        expected.add(Collections.singleton(3));
        expected.add(Collections.singleton(4));
        Assertions.assertThat((Collection)result).isEqualTo(expected);
    }

    @Test
    void testLargeGraph() {
        int n = 100000;
        ArrayList<List<Integer>> edges = new ArrayList<List<Integer>>();
        for (int i = 0; i < 100000; ++i) {
            edges.add(Collections.singletonList((i + 1) % 100000));
        }
        Set result = StronglyConnectedComponentsComputeUtils.computeStronglyConnectedComponents((int)100000, edges);
        Set singleComponent = IntStream.range(0, 100000).boxed().collect(Collectors.toSet());
        Assertions.assertThat((Collection)result).isEqualTo(Collections.singleton(singleComponent));
    }
}

