/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.io.network.netty.NettyBufferPool;
import org.apache.flink.runtime.io.network.netty.NettyConfig;
import org.apache.flink.runtime.io.network.netty.NettyProtocol;
import org.apache.flink.runtime.io.network.netty.NettyServer;
import org.apache.flink.runtime.io.network.netty.NettyTestUtil;
import org.apache.flink.runtime.util.PortRange;
import org.apache.flink.util.NetUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class NettyServerFromPortRangeTest {
    NettyServerFromPortRangeTest() {
    }

    @Test
    void testStartMultipleNettyServerSameConfig() throws Exception {
        NetUtils.Port port2;
        NetUtils.Port port1 = NetUtils.getAvailablePort();
        do {
            port2 = NetUtils.getAvailablePort();
        } while (port1.getPort() == port2.getPort());
        NettyConfig config = NettyServerFromPortRangeTest.getConfig(port1, port2);
        NettyServer nettyServer1 = new NettyServer(config);
        int listeningPort1 = nettyServer1.init((NettyProtocol)new NettyTestUtil.NoOpProtocol(), new NettyBufferPool(1));
        NettyServer nettyServer2 = new NettyServer(config);
        int listeningPort2 = nettyServer2.init((NettyProtocol)new NettyTestUtil.NoOpProtocol(), new NettyBufferPool(1));
        Assertions.assertThat((int)listeningPort1).isEqualTo(port1.getPort());
        Assertions.assertThat((int)listeningPort2).isEqualTo(port2.getPort());
    }

    private static NettyConfig getConfig(NetUtils.Port ... ports) {
        String portRangeStr = Arrays.stream(ports).map(NetUtils.Port::getPort).map(String::valueOf).collect(Collectors.joining(","));
        return new NettyConfig(InetAddress.getLoopbackAddress(), new PortRange(portRangeStr), 1024, 1, new Configuration());
    }
}

