/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.runtime.io.network.NetworkSequenceViewReader;
import org.apache.flink.runtime.io.network.netty.NettyPartitionRequestListener;
import org.apache.flink.runtime.io.network.partition.PartitionRequestListener;
import org.apache.flink.runtime.io.network.partition.PartitionRequestListenerManager;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionProvider;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionIndexSet;
import org.apache.flink.runtime.io.network.partition.TestingResultPartitionProvider;
import org.apache.flink.runtime.io.network.partition.TestingSubpartitionCreatedViewReader;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannelID;
import org.apache.flink.util.TestLogger;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class PartitionRequestListenerManagerTest
extends TestLogger {
    PartitionRequestListenerManagerTest() {
    }

    @Test
    void testAddListener() {
        PartitionRequestListenerManager partitionRequestListenerManager = new PartitionRequestListenerManager();
        Assertions.assertThat((boolean)partitionRequestListenerManager.isEmpty()).isTrue();
        ArrayList<NettyPartitionRequestListener> listenerList = new ArrayList<NettyPartitionRequestListener>();
        NettyPartitionRequestListener listener1 = new NettyPartitionRequestListener((ResultPartitionProvider)TestingResultPartitionProvider.newBuilder().build(), (NetworkSequenceViewReader)TestingSubpartitionCreatedViewReader.newBuilder().setReceiverId(new InputChannelID()).build(), new ResultSubpartitionIndexSet(0), new ResultPartitionID());
        partitionRequestListenerManager.registerListener((PartitionRequestListener)listener1);
        listenerList.add(listener1);
        NettyPartitionRequestListener listener2 = new NettyPartitionRequestListener((ResultPartitionProvider)TestingResultPartitionProvider.newBuilder().build(), (NetworkSequenceViewReader)TestingSubpartitionCreatedViewReader.newBuilder().setReceiverId(new InputChannelID()).build(), new ResultSubpartitionIndexSet(1), new ResultPartitionID());
        partitionRequestListenerManager.registerListener((PartitionRequestListener)listener2);
        listenerList.add(listener2);
        NettyPartitionRequestListener listener3 = new NettyPartitionRequestListener((ResultPartitionProvider)TestingResultPartitionProvider.newBuilder().build(), (NetworkSequenceViewReader)TestingSubpartitionCreatedViewReader.newBuilder().setReceiverId(new InputChannelID()).build(), new ResultSubpartitionIndexSet(2), new ResultPartitionID());
        partitionRequestListenerManager.registerListener((PartitionRequestListener)listener3);
        listenerList.add(listener3);
        Assertions.assertThat((Collection)partitionRequestListenerManager.getPartitionRequestListeners()).hasSize(listenerList.size());
        Assertions.assertThat(listenerList).containsAll((Iterable)partitionRequestListenerManager.getPartitionRequestListeners());
    }

    @Test
    void testRemoveListener() {
        PartitionRequestListenerManager partitionRequestListenerManager = new PartitionRequestListenerManager();
        Assertions.assertThat((boolean)partitionRequestListenerManager.isEmpty()).isTrue();
        ArrayList<NettyPartitionRequestListener> listenerList = new ArrayList<NettyPartitionRequestListener>();
        NettyPartitionRequestListener listener1 = new NettyPartitionRequestListener((ResultPartitionProvider)TestingResultPartitionProvider.newBuilder().build(), (NetworkSequenceViewReader)TestingSubpartitionCreatedViewReader.newBuilder().setReceiverId(new InputChannelID()).build(), new ResultSubpartitionIndexSet(0), new ResultPartitionID());
        partitionRequestListenerManager.registerListener((PartitionRequestListener)listener1);
        NettyPartitionRequestListener listener2 = new NettyPartitionRequestListener((ResultPartitionProvider)TestingResultPartitionProvider.newBuilder().build(), (NetworkSequenceViewReader)TestingSubpartitionCreatedViewReader.newBuilder().setReceiverId(new InputChannelID()).build(), new ResultSubpartitionIndexSet(1), new ResultPartitionID());
        partitionRequestListenerManager.registerListener((PartitionRequestListener)listener2);
        listenerList.add(listener2);
        NettyPartitionRequestListener listener3 = new NettyPartitionRequestListener((ResultPartitionProvider)TestingResultPartitionProvider.newBuilder().build(), (NetworkSequenceViewReader)TestingSubpartitionCreatedViewReader.newBuilder().setReceiverId(new InputChannelID()).build(), new ResultSubpartitionIndexSet(2), new ResultPartitionID());
        partitionRequestListenerManager.registerListener((PartitionRequestListener)listener3);
        listenerList.add(listener3);
        partitionRequestListenerManager.remove(listener1.getReceiverId());
        Assertions.assertThat((Collection)partitionRequestListenerManager.getPartitionRequestListeners()).hasSize(listenerList.size());
        Assertions.assertThat(listenerList).containsAll((Iterable)partitionRequestListenerManager.getPartitionRequestListeners());
    }

    @Test
    void testRemoveExpiration() {
        PartitionRequestListenerManager partitionRequestListenerManager = new PartitionRequestListenerManager();
        Assertions.assertThat((boolean)partitionRequestListenerManager.isEmpty()).isTrue();
        ArrayList<NettyPartitionRequestListener> listenerList = new ArrayList<NettyPartitionRequestListener>();
        ArrayList<NettyPartitionRequestListener> expireListenerList = new ArrayList<NettyPartitionRequestListener>();
        NettyPartitionRequestListener listener1 = new NettyPartitionRequestListener((ResultPartitionProvider)TestingResultPartitionProvider.newBuilder().build(), (NetworkSequenceViewReader)TestingSubpartitionCreatedViewReader.newBuilder().setReceiverId(new InputChannelID()).build(), new ResultSubpartitionIndexSet(0), new ResultPartitionID(), 0L);
        partitionRequestListenerManager.registerListener((PartitionRequestListener)listener1);
        expireListenerList.add(listener1);
        NettyPartitionRequestListener listener2 = new NettyPartitionRequestListener((ResultPartitionProvider)TestingResultPartitionProvider.newBuilder().build(), (NetworkSequenceViewReader)TestingSubpartitionCreatedViewReader.newBuilder().setReceiverId(new InputChannelID()).build(), new ResultSubpartitionIndexSet(1), new ResultPartitionID(), 0L);
        partitionRequestListenerManager.registerListener((PartitionRequestListener)listener2);
        expireListenerList.add(listener2);
        long currentTimestamp = System.currentTimeMillis();
        NettyPartitionRequestListener listener3 = new NettyPartitionRequestListener((ResultPartitionProvider)TestingResultPartitionProvider.newBuilder().build(), (NetworkSequenceViewReader)TestingSubpartitionCreatedViewReader.newBuilder().setReceiverId(new InputChannelID()).build(), new ResultSubpartitionIndexSet(2), new ResultPartitionID(), currentTimestamp);
        partitionRequestListenerManager.registerListener((PartitionRequestListener)listener3);
        listenerList.add(listener3);
        ArrayList removeExpireListenerList = new ArrayList();
        partitionRequestListenerManager.removeExpiration(currentTimestamp, 1L, removeExpireListenerList);
        Assertions.assertThat((Collection)partitionRequestListenerManager.getPartitionRequestListeners()).hasSize(listenerList.size());
        Assertions.assertThat(listenerList).containsAll((Iterable)partitionRequestListenerManager.getPartitionRequestListeners());
        Assertions.assertThat(removeExpireListenerList).hasSize(expireListenerList.size());
        Assertions.assertThat(expireListenerList).containsAll(removeExpireListenerList);
    }
}

