/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.flink.runtime.io.network.partition.hybrid.HsFileDataIndex;
import org.apache.flink.runtime.io.network.partition.hybrid.HsFileDataIndexImpl;
import org.apache.flink.util.TestLoggerExtension;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;

@ExtendWith(value={TestLoggerExtension.class})
class HsFileDataIndexImplTest {
    private static final int NUM_SUBPARTITIONS = 2;
    private HsFileDataIndex hsDataIndex;

    HsFileDataIndexImplTest() {
    }

    @BeforeEach
    void before(@TempDir Path tempDir) throws Exception {
        this.hsDataIndex = new HsFileDataIndexImpl(2, tempDir.resolve(".index"), 256, Long.MAX_VALUE);
    }

    @Test
    void testGetReadableRegionBufferNotExist() {
        this.hsDataIndex.addBuffers(HsFileDataIndexImplTest.createSpilledBuffers(0, Arrays.asList(0, 2)));
        this.hsDataIndex.markBufferReleased(0, 0);
        this.hsDataIndex.markBufferReleased(0, 2);
        Assertions.assertThat((Optional)this.hsDataIndex.getReadableRegion(0, 1, -1)).isNotPresent();
        Assertions.assertThat((Optional)this.hsDataIndex.getReadableRegion(1, 0, -1)).isNotPresent();
    }

    @Test
    void testGetReadableRegionNotReadable() {
        this.hsDataIndex.addBuffers(HsFileDataIndexImplTest.createSpilledBuffers(0, Collections.singletonList(0)));
        this.hsDataIndex.markBufferReleased(0, 0);
        Assertions.assertThat((Optional)this.hsDataIndex.getReadableRegion(0, 0, 1)).isNotPresent();
    }

    @Test
    void testGetReadableRegionNotReleased() {
        this.hsDataIndex.addBuffers(HsFileDataIndexImplTest.createSpilledBuffers(0, Collections.singletonList(0)));
        Assertions.assertThat((Optional)this.hsDataIndex.getReadableRegion(0, 0, -1)).isNotPresent();
    }

    @Test
    void testGetReadableRegion() {
        boolean subpartitionId = false;
        this.hsDataIndex.addBuffers(HsFileDataIndexImplTest.createSpilledBuffers(0, Arrays.asList(0, 1, 3, 4, 5)));
        this.hsDataIndex.markBufferReleased(0, 1);
        this.hsDataIndex.markBufferReleased(0, 3);
        this.hsDataIndex.markBufferReleased(0, 4);
        Assertions.assertThat((Optional)this.hsDataIndex.getReadableRegion(0, 1, 0)).hasValueSatisfying(readableRegion -> {
            HsFileDataIndexImplTest.assertRegionStartWithTargetBufferIndex(readableRegion, 1);
            Assertions.assertThat((int)readableRegion.numReadable).isEqualTo(1);
        });
        Assertions.assertThat((Optional)this.hsDataIndex.getReadableRegion(0, 3, 0)).hasValueSatisfying(readableRegion -> {
            HsFileDataIndexImplTest.assertRegionStartWithTargetBufferIndex(readableRegion, 3);
            Assertions.assertThat((int)readableRegion.numReadable).isGreaterThanOrEqualTo(1).isLessThanOrEqualTo(2);
        });
        Assertions.assertThat((Optional)this.hsDataIndex.getReadableRegion(0, 4, 0)).hasValueSatisfying(readableRegion -> {
            HsFileDataIndexImplTest.assertRegionStartWithTargetBufferIndex(readableRegion, 4);
            Assertions.assertThat((int)readableRegion.numReadable).isEqualTo(1);
        });
    }

    private static void assertRegionStartWithTargetBufferIndex(HsFileDataIndex.ReadableRegion readableRegion, int targetBufferIndex) {
        Assertions.assertThat((int)targetBufferIndex).isEqualTo(readableRegion.offset + (long)readableRegion.numSkip);
    }

    private static List<HsFileDataIndex.SpilledBuffer> createSpilledBuffers(int subpartitionId, List<Integer> bufferIndexes) {
        ArrayList<HsFileDataIndex.SpilledBuffer> spilledBuffers = new ArrayList<HsFileDataIndex.SpilledBuffer>();
        for (int bufferIndex : bufferIndexes) {
            spilledBuffers.add(new HsFileDataIndex.SpilledBuffer(subpartitionId, bufferIndex, (long)bufferIndex));
        }
        return spilledBuffers;
    }
}

