/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.index;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import org.apache.flink.runtime.io.network.partition.hybrid.HsFileDataIndexImpl;
import org.apache.flink.runtime.io.network.partition.hybrid.HybridShuffleTestUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.index.FileDataIndexRegionHelper;
import org.apache.flink.runtime.io.network.partition.hybrid.index.FileRegionWriteReadUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.ProducerMergedPartitionFileIndex;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class FileRegionWriteReadUtilsTest {
    FileRegionWriteReadUtilsTest() {
    }

    @Test
    void testAllocateAndConfigureBuffer() {
        int bufferSize = 16;
        ByteBuffer buffer = FileRegionWriteReadUtils.allocateAndConfigureBuffer((int)16);
        Assertions.assertThat((int)buffer.capacity()).isEqualTo(16);
        Assertions.assertThat((int)buffer.limit()).isEqualTo(16);
        Assertions.assertThat((int)buffer.position()).isZero();
        Assertions.assertThat((boolean)buffer.isDirect()).isTrue();
        Assertions.assertThat((Object)buffer.order()).isEqualTo((Object)ByteOrder.nativeOrder());
    }

    @Test
    void testReadPrematureEndOfFileForHsInternalRegion(@TempDir Path tmpPath) throws Exception {
        FileChannel channel = FileRegionWriteReadUtilsTest.tmpFileChannel(tmpPath);
        ByteBuffer buffer = FileRegionWriteReadUtils.allocateAndConfigureBuffer((int)16);
        FileRegionWriteReadUtils.writeHsInternalRegionToFile((FileChannel)channel, (ByteBuffer)buffer, (HsFileDataIndexImpl.InternalRegion)new HsFileDataIndexImpl.InternalRegion(0, 0L, 1, new boolean[1]));
        channel.truncate(channel.position() - 1L);
        buffer.flip();
        Assertions.assertThatThrownBy(() -> FileRegionWriteReadUtils.readHsInternalRegionFromFile((FileChannel)channel, (ByteBuffer)buffer, (long)0L)).isInstanceOf(IOException.class);
    }

    @Test
    void testWriteAndReadHsInternalRegion(@TempDir Path tmpPath) throws Exception {
        FileChannel channel = FileRegionWriteReadUtilsTest.tmpFileChannel(tmpPath);
        ByteBuffer buffer = FileRegionWriteReadUtils.allocateAndConfigureBuffer((int)16);
        HsFileDataIndexImpl.InternalRegion region = new HsFileDataIndexImpl.InternalRegion(0, 0L, 1, new boolean[1]);
        FileRegionWriteReadUtils.writeHsInternalRegionToFile((FileChannel)channel, (ByteBuffer)buffer, (HsFileDataIndexImpl.InternalRegion)region);
        buffer.flip();
        HsFileDataIndexImpl.InternalRegion readRegion = FileRegionWriteReadUtils.readHsInternalRegionFromFile((FileChannel)channel, (ByteBuffer)buffer, (long)0L);
        HybridShuffleTestUtils.assertRegionEquals((FileDataIndexRegionHelper.Region)readRegion, (FileDataIndexRegionHelper.Region)region);
    }

    @Test
    void testReadPrematureEndOfFileForFixedSizeRegion(@TempDir Path tmpPath) throws Exception {
        FileChannel channel = FileRegionWriteReadUtilsTest.tmpFileChannel(tmpPath);
        ByteBuffer buffer = FileRegionWriteReadUtils.allocateAndConfigureBuffer((int)24);
        FileRegionWriteReadUtils.writeFixedSizeRegionToFile((FileChannel)channel, (ByteBuffer)buffer, (FileDataIndexRegionHelper.Region)HybridShuffleTestUtils.createSingleFixedSizeRegion(0, 0L, 10L, 1));
        channel.truncate(channel.position() - 1L);
        buffer.flip();
        Assertions.assertThatThrownBy(() -> FileRegionWriteReadUtils.readFixedSizeRegionFromFile((FileChannel)channel, (ByteBuffer)buffer, (long)0L)).isInstanceOf(IOException.class);
    }

    @Test
    void testWriteAndReadFixedSizeRegion(@TempDir Path tmpPath) throws Exception {
        FileChannel channel = FileRegionWriteReadUtilsTest.tmpFileChannel(tmpPath);
        ByteBuffer buffer = FileRegionWriteReadUtils.allocateAndConfigureBuffer((int)24);
        FileDataIndexRegionHelper.Region region = HybridShuffleTestUtils.createSingleFixedSizeRegion(10, 100L, 110L, 1);
        FileRegionWriteReadUtils.writeFixedSizeRegionToFile((FileChannel)channel, (ByteBuffer)buffer, (FileDataIndexRegionHelper.Region)region);
        buffer.flip();
        ProducerMergedPartitionFileIndex.FixedSizeRegion readRegion = FileRegionWriteReadUtils.readFixedSizeRegionFromFile((FileChannel)channel, (ByteBuffer)buffer, (long)0L);
        HybridShuffleTestUtils.assertRegionEquals((FileDataIndexRegionHelper.Region)readRegion, region);
    }

    private static FileChannel tmpFileChannel(Path tempPath) throws IOException {
        return FileChannel.open(Files.createFile(tempPath.resolve(UUID.randomUUID().toString()), new FileAttribute[0]), StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
    }
}

