/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.runtime.messages.FlinkJobNotFoundException;
import org.apache.flink.runtime.rest.handler.legacy.DefaultExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.handler.legacy.utils.ArchivedExecutionGraphBuilder;
import org.apache.flink.runtime.scheduler.ExecutionGraphInfo;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.TestingRestfulGateway;
import org.apache.flink.util.ExecutorUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.FutureUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

class DefaultExecutionGraphCacheTest {
    private static ExecutionGraphInfo expectedExecutionGraphInfo;
    private static final JobID expectedJobId;

    DefaultExecutionGraphCacheTest() {
    }

    @BeforeAll
    public static void setup() {
        expectedExecutionGraphInfo = new ExecutionGraphInfo(new ArchivedExecutionGraphBuilder().build());
    }

    @Test
    void testExecutionGraphCaching() throws Exception {
        Time timeout = Time.milliseconds((long)100L);
        Time timeToLive = Time.hours((long)1L);
        CountingRestfulGateway restfulGateway = this.createCountingRestfulGateway(expectedJobId, CompletableFuture.completedFuture(expectedExecutionGraphInfo));
        try (DefaultExecutionGraphCache executionGraphCache = new DefaultExecutionGraphCache(timeout, timeToLive);){
            CompletableFuture executionGraphInfoFuture = executionGraphCache.getExecutionGraphInfo(expectedJobId, (RestfulGateway)restfulGateway);
            FlinkAssertions.assertThatFuture((CompletableFuture)executionGraphInfoFuture).eventuallySucceeds().isEqualTo((Object)expectedExecutionGraphInfo);
            executionGraphInfoFuture = executionGraphCache.getExecutionGraphInfo(expectedJobId, (RestfulGateway)restfulGateway);
            FlinkAssertions.assertThatFuture((CompletableFuture)executionGraphInfoFuture).eventuallySucceeds().isEqualTo((Object)expectedExecutionGraphInfo);
            Assertions.assertThat((int)restfulGateway.getNumRequestJobCalls()).isOne();
        }
    }

    @Test
    void testExecutionGraphEntryInvalidation() throws Exception {
        Time timeout = Time.milliseconds((long)100L);
        Time timeToLive = Time.milliseconds((long)1L);
        CountingRestfulGateway restfulGateway = this.createCountingRestfulGateway(expectedJobId, CompletableFuture.completedFuture(expectedExecutionGraphInfo), CompletableFuture.completedFuture(expectedExecutionGraphInfo));
        try (DefaultExecutionGraphCache executionGraphCache = new DefaultExecutionGraphCache(timeout, timeToLive);){
            CompletableFuture executionGraphInfoFuture = executionGraphCache.getExecutionGraphInfo(expectedJobId, (RestfulGateway)restfulGateway);
            FlinkAssertions.assertThatFuture((CompletableFuture)executionGraphInfoFuture).eventuallySucceeds().isEqualTo((Object)expectedExecutionGraphInfo);
            Thread.sleep(timeToLive.toMilliseconds() * 5L);
            CompletableFuture executionGraphInfoFuture2 = executionGraphCache.getExecutionGraphInfo(expectedJobId, (RestfulGateway)restfulGateway);
            FlinkAssertions.assertThatFuture((CompletableFuture)executionGraphInfoFuture2).eventuallySucceeds().isEqualTo((Object)expectedExecutionGraphInfo);
            Assertions.assertThat((int)restfulGateway.getNumRequestJobCalls()).isEqualTo(2);
        }
    }

    @Test
    void testImmediateCacheInvalidationAfterFailure() throws Exception {
        Time timeout = Time.milliseconds((long)100L);
        Time timeToLive = Time.hours((long)1L);
        CountingRestfulGateway restfulGateway = this.createCountingRestfulGateway(expectedJobId, FutureUtils.completedExceptionally((Throwable)new FlinkJobNotFoundException(expectedJobId)), CompletableFuture.completedFuture(expectedExecutionGraphInfo));
        try (DefaultExecutionGraphCache executionGraphCache = new DefaultExecutionGraphCache(timeout, timeToLive);){
            CompletableFuture executionGraphFuture = executionGraphCache.getExecutionGraphInfo(expectedJobId, (RestfulGateway)restfulGateway);
            Assertions.assertThatThrownBy(() -> {
                ExecutionGraphInfo cfr_ignored_0 = (ExecutionGraphInfo)executionGraphFuture.get();
            }).hasCauseInstanceOf(FlinkException.class);
            CompletableFuture executionGraphFuture2 = executionGraphCache.getExecutionGraphInfo(expectedJobId, (RestfulGateway)restfulGateway);
            FlinkAssertions.assertThatFuture((CompletableFuture)executionGraphFuture2).eventuallySucceeds().isEqualTo((Object)expectedExecutionGraphInfo);
        }
    }

    @Test
    void testCacheEntryCleanup() throws Exception {
        Time timeout = Time.milliseconds((long)100L);
        Time timeToLive = Time.milliseconds((long)1L);
        JobID expectedJobId2 = new JobID();
        ExecutionGraphInfo expectedExecutionGraphInfo2 = new ExecutionGraphInfo(new ArchivedExecutionGraphBuilder().build());
        AtomicInteger requestJobCalls = new AtomicInteger(0);
        TestingRestfulGateway restfulGateway = ((TestingRestfulGateway.Builder)new TestingRestfulGateway.Builder().setRequestExecutionGraphInfoFunction(jobId -> {
            requestJobCalls.incrementAndGet();
            if (jobId.equals((Object)expectedJobId)) {
                return CompletableFuture.completedFuture(expectedExecutionGraphInfo);
            }
            if (jobId.equals((Object)expectedJobId2)) {
                return CompletableFuture.completedFuture(expectedExecutionGraphInfo2);
            }
            throw new AssertionError((Object)"Invalid job id received.");
        })).build();
        try (DefaultExecutionGraphCache executionGraphCache = new DefaultExecutionGraphCache(timeout, timeToLive);){
            CompletableFuture executionGraph1Future = executionGraphCache.getExecutionGraphInfo(expectedJobId, (RestfulGateway)restfulGateway);
            CompletableFuture executionGraph2Future = executionGraphCache.getExecutionGraphInfo(expectedJobId2, (RestfulGateway)restfulGateway);
            FlinkAssertions.assertThatFuture((CompletableFuture)executionGraph1Future).eventuallySucceeds().isEqualTo((Object)expectedExecutionGraphInfo);
            FlinkAssertions.assertThatFuture((CompletableFuture)executionGraph2Future).eventuallySucceeds().isEqualTo((Object)expectedExecutionGraphInfo2);
            Assertions.assertThat((int)requestJobCalls.get()).isEqualTo(2);
            Thread.sleep(timeToLive.toMilliseconds());
            executionGraphCache.cleanup();
            Assertions.assertThat((int)executionGraphCache.size()).isZero();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testConcurrentAccess() throws Exception {
        Time timeout = Time.milliseconds((long)100L);
        Time timeToLive = Time.hours((long)1L);
        CountingRestfulGateway restfulGateway = this.createCountingRestfulGateway(expectedJobId, CompletableFuture.completedFuture(expectedExecutionGraphInfo));
        int numConcurrentAccesses = 10;
        ArrayList<CompletionStage> executionGraphFutures = new ArrayList<CompletionStage>(10);
        ExecutorService executor = Executors.newFixedThreadPool(10);
        try (DefaultExecutionGraphCache executionGraphCache = new DefaultExecutionGraphCache(timeout, timeToLive);){
            for (int i = 0; i < 10; ++i) {
                CompletionStage executionGraphFuture = CompletableFuture.supplyAsync(() -> DefaultExecutionGraphCacheTest.lambda$testConcurrentAccess$2((ExecutionGraphCache)executionGraphCache, restfulGateway), executor).thenCompose(Function.identity());
                executionGraphFutures.add(executionGraphFuture);
            }
            FutureUtils.ConjunctFuture allExecutionGraphFutures = FutureUtils.combineAll(executionGraphFutures);
            Collection allExecutionGraphs = (Collection)allExecutionGraphFutures.get();
            for (ExecutionGraphInfo executionGraph : allExecutionGraphs) {
                Assertions.assertThat((Object)executionGraph).isEqualTo((Object)expectedExecutionGraphInfo);
            }
            Assertions.assertThat((int)restfulGateway.getNumRequestJobCalls()).isOne();
        }
        catch (Throwable throwable) {
            ExecutorUtils.gracefulShutdown((long)5000L, (TimeUnit)TimeUnit.MILLISECONDS, (ExecutorService[])new ExecutorService[]{executor});
            throw throwable;
        }
        ExecutorUtils.gracefulShutdown((long)5000L, (TimeUnit)TimeUnit.MILLISECONDS, (ExecutorService[])new ExecutorService[]{executor});
    }

    private CountingRestfulGateway createCountingRestfulGateway(JobID jobId, CompletableFuture<ExecutionGraphInfo> ... accessExecutionGraphs) {
        ConcurrentLinkedQueue<CompletableFuture<ExecutionGraphInfo>> queue = new ConcurrentLinkedQueue<CompletableFuture<ExecutionGraphInfo>>(Arrays.asList(accessExecutionGraphs));
        return new CountingRestfulGateway(jobId, ignored -> (CompletableFuture)queue.poll());
    }

    private static /* synthetic */ CompletableFuture lambda$testConcurrentAccess$2(ExecutionGraphCache executionGraphCache, CountingRestfulGateway restfulGateway) {
        return executionGraphCache.getExecutionGraphInfo(expectedJobId, (RestfulGateway)restfulGateway);
    }

    static {
        expectedJobId = new JobID();
    }

    private static class CountingRestfulGateway
    extends TestingRestfulGateway {
        private final JobID expectedJobId;
        private AtomicInteger numRequestJobCalls = new AtomicInteger(0);

        private CountingRestfulGateway(JobID expectedJobId, Function<JobID, CompletableFuture<ExecutionGraphInfo>> requestJobFunction) {
            this.expectedJobId = (JobID)Preconditions.checkNotNull((Object)expectedJobId);
            this.requestExecutionGraphInfoFunction = (Function)Preconditions.checkNotNull(requestJobFunction);
        }

        @Override
        public CompletableFuture<ExecutionGraphInfo> requestExecutionGraphInfo(JobID jobId, Time timeout) {
            Assertions.assertThat((Comparable)jobId).isEqualTo((Object)this.expectedJobId);
            this.numRequestJobCalls.incrementAndGet();
            return super.requestExecutionGraphInfo(jobId, timeout);
        }

        public int getNumRequestJobCalls() {
            return this.numRequestJobCalls.get();
        }
    }
}

