/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.flink.runtime.rest.messages.JobExceptionsInfo;
import org.apache.flink.runtime.rest.messages.JobExceptionsInfoWithHistory;
import org.apache.flink.runtime.rest.messages.RestResponseMarshallingTestBase;
import org.apache.flink.runtime.rest.util.RestMapperUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.testutils.junit.extensions.parameterized.NoOpTestExtension;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={NoOpTestExtension.class})
class JobExceptionsInfoWithHistoryTest
extends RestResponseMarshallingTestBase<JobExceptionsInfoWithHistory> {
    JobExceptionsInfoWithHistoryTest() {
    }

    @Override
    protected Class<JobExceptionsInfoWithHistory> getTestResponseClass() {
        return JobExceptionsInfoWithHistory.class;
    }

    @Override
    protected JobExceptionsInfoWithHistory getTestResponseInstance() throws Exception {
        ArrayList<JobExceptionsInfo.ExecutionExceptionInfo> executionTaskExceptionInfoList = new ArrayList<JobExceptionsInfo.ExecutionExceptionInfo>();
        executionTaskExceptionInfoList.add(new JobExceptionsInfo.ExecutionExceptionInfo("exception1", "task1", "location1", System.currentTimeMillis(), "taskManagerId1"));
        executionTaskExceptionInfoList.add(new JobExceptionsInfo.ExecutionExceptionInfo("exception2", "task2", "location2", System.currentTimeMillis(), "taskManagerId2"));
        return new JobExceptionsInfoWithHistory("root exception", Long.valueOf(System.currentTimeMillis()), executionTaskExceptionInfoList, false, new JobExceptionsInfoWithHistory.JobExceptionHistory(Collections.emptyList(), false));
    }

    @Test
    void testNullFieldsNotSet() throws JsonProcessingException {
        ObjectMapper objMapper = RestMapperUtils.getStrictObjectMapper();
        String json = objMapper.writeValueAsString((Object)new JobExceptionsInfoWithHistory.ExceptionInfo("exception name", "stacktrace", 0L));
        Assertions.assertThat((String)json).doesNotContain(new CharSequence[]{"taskName"});
        Assertions.assertThat((String)json).doesNotContain(new CharSequence[]{"location"});
    }
}

