/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.benchmark;

import org.apache.flink.api.common.ExecutionMode;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.JobType;

public enum JobConfiguration {
    STREAMING(DistributionPattern.ALL_TO_ALL, ResultPartitionType.PIPELINED, JobType.STREAMING, ExecutionMode.PIPELINED, 4000, false),
    BATCH(DistributionPattern.ALL_TO_ALL, ResultPartitionType.BLOCKING, JobType.BATCH, ExecutionMode.BATCH, 4000, false),
    BATCH_HYBRID_DEFAULT(DistributionPattern.ALL_TO_ALL, ResultPartitionType.HYBRID_FULL, JobType.BATCH, ExecutionMode.BATCH, JobManagerOptions.HybridPartitionDataConsumeConstraint.UNFINISHED_PRODUCERS, 4000, false),
    BATCH_HYBRID_PARTIAL_FINISHED(DistributionPattern.ALL_TO_ALL, ResultPartitionType.HYBRID_FULL, JobType.BATCH, ExecutionMode.BATCH, JobManagerOptions.HybridPartitionDataConsumeConstraint.ONLY_FINISHED_PRODUCERS, 4000, false),
    BATCH_HYBRID_ALL_FINISHED(DistributionPattern.ALL_TO_ALL, ResultPartitionType.HYBRID_FULL, JobType.BATCH, ExecutionMode.BATCH, JobManagerOptions.HybridPartitionDataConsumeConstraint.ALL_PRODUCERS_FINISHED, 4000, false),
    STREAMING_TEST(DistributionPattern.ALL_TO_ALL, ResultPartitionType.PIPELINED, JobType.STREAMING, ExecutionMode.PIPELINED, 10, false),
    BATCH_TEST(DistributionPattern.ALL_TO_ALL, ResultPartitionType.BLOCKING, JobType.BATCH, ExecutionMode.BATCH, 10, false),
    BATCH_HYBRID_DEFAULT_TEST(DistributionPattern.ALL_TO_ALL, ResultPartitionType.HYBRID_FULL, JobType.BATCH, ExecutionMode.BATCH, JobManagerOptions.HybridPartitionDataConsumeConstraint.UNFINISHED_PRODUCERS, 10, false),
    BATCH_HYBRID_PARTIAL_FINISHED_TEST(DistributionPattern.ALL_TO_ALL, ResultPartitionType.HYBRID_FULL, JobType.BATCH, ExecutionMode.BATCH, JobManagerOptions.HybridPartitionDataConsumeConstraint.ONLY_FINISHED_PRODUCERS, 10, false),
    BATCH_HYBRID_ALL_FINISHED_TEST(DistributionPattern.ALL_TO_ALL, ResultPartitionType.HYBRID_FULL, JobType.BATCH, ExecutionMode.BATCH, JobManagerOptions.HybridPartitionDataConsumeConstraint.ALL_PRODUCERS_FINISHED, 10, false),
    STREAMING_EVENLY(DistributionPattern.ALL_TO_ALL, ResultPartitionType.PIPELINED, JobType.STREAMING, ExecutionMode.PIPELINED, 4000, true),
    BATCH_EVENLY(DistributionPattern.ALL_TO_ALL, ResultPartitionType.BLOCKING, JobType.BATCH, ExecutionMode.BATCH, 4000, true),
    STREAMING_EVENLY_TEST(DistributionPattern.ALL_TO_ALL, ResultPartitionType.PIPELINED, JobType.STREAMING, ExecutionMode.PIPELINED, 10, true),
    BATCH_EVENLY_TEST(DistributionPattern.ALL_TO_ALL, ResultPartitionType.BLOCKING, JobType.BATCH, ExecutionMode.BATCH, 10, true);

    private final int parallelism;
    private final DistributionPattern distributionPattern;
    private final ResultPartitionType resultPartitionType;
    private final JobType jobType;
    private final ExecutionMode executionMode;
    private final boolean evenlySpreadOutSlots;
    private final JobManagerOptions.HybridPartitionDataConsumeConstraint hybridPartitionDataConsumeConstraint;

    private JobConfiguration(DistributionPattern distributionPattern, ResultPartitionType resultPartitionType, JobType jobType, ExecutionMode executionMode, int parallelism, boolean evenlySpreadOutSlots) {
        this(distributionPattern, resultPartitionType, jobType, executionMode, JobManagerOptions.HybridPartitionDataConsumeConstraint.UNFINISHED_PRODUCERS, parallelism, evenlySpreadOutSlots);
    }

    private JobConfiguration(DistributionPattern distributionPattern, ResultPartitionType resultPartitionType, JobType jobType, ExecutionMode executionMode, JobManagerOptions.HybridPartitionDataConsumeConstraint hybridPartitionDataConsumeConstraint, int parallelism, boolean evenlySpreadOutSlots) {
        this.distributionPattern = distributionPattern;
        this.resultPartitionType = resultPartitionType;
        this.jobType = jobType;
        this.executionMode = executionMode;
        this.hybridPartitionDataConsumeConstraint = hybridPartitionDataConsumeConstraint;
        this.parallelism = parallelism;
        this.evenlySpreadOutSlots = evenlySpreadOutSlots;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public DistributionPattern getDistributionPattern() {
        return this.distributionPattern;
    }

    public ResultPartitionType getResultPartitionType() {
        return this.resultPartitionType;
    }

    public JobType getJobType() {
        return this.jobType;
    }

    public ExecutionMode getExecutionMode() {
        return this.executionMode;
    }

    public JobManagerOptions.HybridPartitionDataConsumeConstraint getHybridPartitionDataConsumeConstraint() {
        return this.hybridPartitionDataConsumeConstraint;
    }

    public boolean isEvenlySpreadOutSlots() {
        return this.evenlySpreadOutSlots;
    }
}

