/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.security;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.runtime.security.SecurityConfiguration;
import org.apache.flink.runtime.security.SecurityUtils;
import org.apache.flink.runtime.security.contexts.AnotherCompatibleTestSecurityContextFactory;
import org.apache.flink.runtime.security.contexts.HadoopSecurityContextFactory;
import org.apache.flink.runtime.security.contexts.IncompatibleTestSecurityContextFactory;
import org.apache.flink.runtime.security.contexts.LinkageErrorSecurityContextFactory;
import org.apache.flink.runtime.security.contexts.NoOpSecurityContext;
import org.apache.flink.runtime.security.contexts.NoOpSecurityContextFactory;
import org.apache.flink.runtime.security.contexts.TestSecurityContextFactory;
import org.apache.flink.runtime.security.modules.TestSecurityModuleFactory;
import org.apache.flink.shaded.guava31.com.google.common.collect.Lists;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;

public class SecurityUtilsTest {
    @AfterClass
    public static void afterClass() {
        SecurityUtils.uninstall();
    }

    @Test
    public void testModuleInstall() throws Exception {
        SecurityConfiguration sc = new SecurityConfiguration(new Configuration(), Collections.singletonList(TestSecurityContextFactory.class.getCanonicalName()), Collections.singletonList(TestSecurityModuleFactory.class.getCanonicalName()));
        SecurityUtils.install((SecurityConfiguration)sc);
        Assert.assertEquals((long)1L, (long)SecurityUtils.getInstalledModules().size());
        TestSecurityModuleFactory.TestSecurityModule testModule = (TestSecurityModuleFactory.TestSecurityModule)SecurityUtils.getInstalledModules().get(0);
        Assert.assertTrue((boolean)testModule.installed);
        SecurityUtils.uninstall();
        Assert.assertNull((Object)SecurityUtils.getInstalledModules());
        Assert.assertFalse((boolean)testModule.installed);
    }

    @Test
    public void testSecurityContext() throws Exception {
        SecurityConfiguration sc = new SecurityConfiguration(new Configuration(), Collections.singletonList(TestSecurityContextFactory.class.getCanonicalName()), Collections.singletonList(TestSecurityModuleFactory.class.getCanonicalName()));
        SecurityUtils.install((SecurityConfiguration)sc);
        Assert.assertEquals(TestSecurityContextFactory.TestSecurityContext.class, SecurityUtils.getInstalledContext().getClass());
        SecurityUtils.uninstall();
        Assert.assertEquals(NoOpSecurityContext.class, SecurityUtils.getInstalledContext().getClass());
    }

    @Test
    public void testLinkageErrorShouldFallbackToSecond() throws Exception {
        Configuration testFlinkConf = new Configuration();
        testFlinkConf.set(SecurityOptions.SECURITY_CONTEXT_FACTORY_CLASSES, (Object)Lists.newArrayList((Object[])new String[]{LinkageErrorSecurityContextFactory.class.getCanonicalName(), TestSecurityContextFactory.class.getCanonicalName()}));
        SecurityConfiguration testSecurityConf = new SecurityConfiguration(testFlinkConf);
        SecurityUtils.install((SecurityConfiguration)testSecurityConf);
        Assert.assertEquals(TestSecurityContextFactory.TestSecurityContext.class, SecurityUtils.getInstalledContext().getClass());
        SecurityUtils.uninstall();
        Assert.assertEquals(NoOpSecurityContext.class, SecurityUtils.getInstalledContext().getClass());
    }

    @Test
    public void testSecurityContextShouldFallbackToSecond() throws Exception {
        Configuration testFlinkConf = new Configuration();
        testFlinkConf.set(SecurityOptions.SECURITY_CONTEXT_FACTORY_CLASSES, (Object)Lists.newArrayList((Object[])new String[]{IncompatibleTestSecurityContextFactory.class.getCanonicalName(), TestSecurityContextFactory.class.getCanonicalName()}));
        SecurityConfiguration testSecurityConf = new SecurityConfiguration(testFlinkConf);
        SecurityUtils.install((SecurityConfiguration)testSecurityConf);
        Assert.assertEquals(TestSecurityContextFactory.TestSecurityContext.class, SecurityUtils.getInstalledContext().getClass());
        SecurityUtils.uninstall();
        Assert.assertEquals(NoOpSecurityContext.class, SecurityUtils.getInstalledContext().getClass());
    }

    @Test
    public void testSecurityContextShouldPickFirstIfBothCompatible() throws Exception {
        Configuration testFlinkConf = new Configuration();
        testFlinkConf.set(SecurityOptions.SECURITY_CONTEXT_FACTORY_CLASSES, (Object)Lists.newArrayList((Object[])new String[]{AnotherCompatibleTestSecurityContextFactory.class.getCanonicalName(), TestSecurityContextFactory.class.getCanonicalName()}));
        SecurityConfiguration testSecurityConf = new SecurityConfiguration(testFlinkConf);
        SecurityUtils.install((SecurityConfiguration)testSecurityConf);
        Assert.assertEquals(AnotherCompatibleTestSecurityContextFactory.TestSecurityContext.class, SecurityUtils.getInstalledContext().getClass());
        SecurityUtils.uninstall();
        Assert.assertEquals(NoOpSecurityContext.class, SecurityUtils.getInstalledContext().getClass());
        testFlinkConf.set(SecurityOptions.SECURITY_CONTEXT_FACTORY_CLASSES, (Object)Lists.newArrayList((Object[])new String[]{TestSecurityContextFactory.class.getCanonicalName(), AnotherCompatibleTestSecurityContextFactory.class.getCanonicalName()}));
        testSecurityConf = new SecurityConfiguration(testFlinkConf);
        SecurityUtils.install((SecurityConfiguration)testSecurityConf);
        Assert.assertEquals(TestSecurityContextFactory.TestSecurityContext.class, SecurityUtils.getInstalledContext().getClass());
        SecurityUtils.uninstall();
        Assert.assertEquals(NoOpSecurityContext.class, SecurityUtils.getInstalledContext().getClass());
    }

    @Test
    public void testSecurityFactoriesDefaultConfig() {
        Configuration testFlinkConf = new Configuration();
        SecurityConfiguration testSecurityConf = new SecurityConfiguration(testFlinkConf);
        Assert.assertEquals((long)2L, (long)testSecurityConf.getSecurityContextFactories().size());
        Assert.assertEquals((Object)HadoopSecurityContextFactory.class.getCanonicalName(), testSecurityConf.getSecurityContextFactories().get(0));
        Assert.assertEquals((Object)NoOpSecurityContextFactory.class.getCanonicalName(), testSecurityConf.getSecurityContextFactories().get(1));
        Assert.assertEquals((long)3L, (long)testSecurityConf.getSecurityModuleFactories().size());
    }

    @Test
    public void testSecurityFactoriesUserConfig() {
        Configuration testFlinkConf = new Configuration();
        testFlinkConf.set(SecurityOptions.SECURITY_CONTEXT_FACTORY_CLASSES, Collections.singletonList(TestSecurityContextFactory.class.getCanonicalName()));
        testFlinkConf.set(SecurityOptions.SECURITY_MODULE_FACTORY_CLASSES, Collections.singletonList(TestSecurityModuleFactory.class.getCanonicalName()));
        SecurityConfiguration testSecurityConf = new SecurityConfiguration(testFlinkConf);
        Assert.assertEquals((long)1L, (long)testSecurityConf.getSecurityContextFactories().size());
        Assert.assertEquals((Object)TestSecurityContextFactory.class.getCanonicalName(), testSecurityConf.getSecurityContextFactories().get(0));
        Assert.assertEquals((long)1L, (long)testSecurityConf.getSecurityModuleFactories().size());
        Assert.assertEquals((Object)TestSecurityModuleFactory.class.getCanonicalName(), testSecurityConf.getSecurityModuleFactories().get(0));
    }

    @Test
    public void testKerberosLoginContextParsing() {
        List<String> expectedLoginContexts = Arrays.asList("Foo bar", "Client");
        Configuration testFlinkConf = new Configuration();
        testFlinkConf.set(SecurityOptions.KERBEROS_LOGIN_CONTEXTS, (Object)"Foo bar,Client");
        SecurityConfiguration testSecurityConf = new SecurityConfiguration(testFlinkConf, Collections.singletonList(TestSecurityContextFactory.class.getCanonicalName()), Collections.singletonList(TestSecurityModuleFactory.class.getCanonicalName()));
        Assert.assertEquals(expectedLoginContexts, (Object)testSecurityConf.getLoginContextNames());
        testFlinkConf = new Configuration();
        testFlinkConf.set(SecurityOptions.KERBEROS_LOGIN_CONTEXTS, (Object)"Foo bar , Client");
        testSecurityConf = new SecurityConfiguration(testFlinkConf, Collections.singletonList(TestSecurityContextFactory.class.getCanonicalName()), Collections.singletonList(TestSecurityModuleFactory.class.getCanonicalName()));
        Assert.assertEquals(expectedLoginContexts, (Object)testSecurityConf.getLoginContextNames());
        testFlinkConf = new Configuration();
        testFlinkConf.set(SecurityOptions.KERBEROS_LOGIN_CONTEXTS, (Object)" Foo bar , Client ");
        testSecurityConf = new SecurityConfiguration(testFlinkConf, Collections.singletonList(TestSecurityContextFactory.class.getCanonicalName()), Collections.singletonList(TestSecurityModuleFactory.class.getCanonicalName()));
        Assert.assertEquals(expectedLoginContexts, (Object)testSecurityConf.getLoginContextNames());
        testFlinkConf = new Configuration();
        testFlinkConf.set(SecurityOptions.KERBEROS_LOGIN_CONTEXTS, (Object)"Foo bar,,Client");
        testSecurityConf = new SecurityConfiguration(testFlinkConf, Collections.singletonList(TestSecurityContextFactory.class.getCanonicalName()), Collections.singletonList(TestSecurityModuleFactory.class.getCanonicalName()));
        Assert.assertEquals(expectedLoginContexts, (Object)testSecurityConf.getLoginContextNames());
        testFlinkConf = new Configuration();
        testFlinkConf.set(SecurityOptions.KERBEROS_LOGIN_CONTEXTS, (Object)"Foo bar, ,, Client,");
        testSecurityConf = new SecurityConfiguration(testFlinkConf, Collections.singletonList(TestSecurityContextFactory.class.getCanonicalName()), Collections.singletonList(TestSecurityModuleFactory.class.getCanonicalName()));
        Assert.assertEquals(expectedLoginContexts, (Object)testSecurityConf.getLoginContextNames());
    }
}

