/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.fs.DuplicatingFileSystem;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.local.LocalFileSystem;
import org.apache.flink.runtime.state.CheckpointStateOutputStream;
import org.apache.flink.runtime.state.CheckpointStorageAccess;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.apache.flink.runtime.state.CheckpointedStateScope;
import org.apache.flink.runtime.state.NotDuplicatingCheckpointStateToolset;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.filesystem.AbstractFileCheckpointStorageAccessTestBase;
import org.apache.flink.runtime.state.filesystem.AbstractFsCheckpointStorageAccess;
import org.apache.flink.runtime.state.filesystem.FileStateHandle;
import org.apache.flink.runtime.state.filesystem.FsCheckpointStateToolset;
import org.apache.flink.runtime.state.filesystem.FsCheckpointStorageAccess;
import org.apache.flink.runtime.state.filesystem.FsCheckpointStorageLocation;
import org.apache.flink.runtime.state.filesystem.FsCheckpointStreamFactory;
import org.apache.flink.testutils.TestFileSystem;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class FsCheckpointStorageAccessTest
extends AbstractFileCheckpointStorageAccessTestBase {
    private static final int FILE_SIZE_THRESHOLD = 1024;
    private static final int WRITE_BUFFER_SIZE = 4096;

    FsCheckpointStorageAccessTest() {
    }

    @Override
    protected CheckpointStorageAccess createCheckpointStorage(Path checkpointDir, boolean createCheckpointSubDir) throws Exception {
        return new FsCheckpointStorageAccess(checkpointDir, null, createCheckpointSubDir, new JobID(), 1024, 4096);
    }

    @Override
    protected CheckpointStorageAccess createCheckpointStorageWithSavepointDir(Path checkpointDir, Path savepointDir, boolean createCheckpointSubDir) throws Exception {
        return new FsCheckpointStorageAccess(checkpointDir, savepointDir, createCheckpointSubDir, new JobID(), 1024, 4096);
    }

    @Test
    void testSavepointsInOneDirectoryDefaultLocation() throws Exception {
        Path defaultSavepointDir = Path.fromLocalFile((File)TempDirUtils.newFolder((java.nio.file.Path)this.tmp));
        FsCheckpointStorageAccess storage = new FsCheckpointStorageAccess(Path.fromLocalFile((File)TempDirUtils.newFolder((java.nio.file.Path)this.tmp)), defaultSavepointDir, true, new JobID(), 1024, 4096);
        FsCheckpointStorageLocation savepointLocation = (FsCheckpointStorageLocation)storage.initializeLocationForSavepoint(52452L, null);
        this.assertParent(defaultSavepointDir, savepointLocation.getCheckpointDirectory());
        this.assertParent(defaultSavepointDir, savepointLocation.getSharedStateDirectory());
        this.assertParent(defaultSavepointDir, savepointLocation.getTaskOwnedStateDirectory());
        savepointLocation.disposeOnFailure();
    }

    @Test
    void testSavepointsInOneDirectoryCustomLocation() throws Exception {
        Path savepointDir = Path.fromLocalFile((File)TempDirUtils.newFolder((java.nio.file.Path)this.tmp));
        FsCheckpointStorageAccess storage = new FsCheckpointStorageAccess(Path.fromLocalFile((File)TempDirUtils.newFolder((java.nio.file.Path)this.tmp)), null, true, new JobID(), 1024, 4096);
        FsCheckpointStorageLocation savepointLocation = (FsCheckpointStorageLocation)storage.initializeLocationForSavepoint(52452L, savepointDir.toString());
        this.assertParent(savepointDir, savepointLocation.getCheckpointDirectory());
        this.assertParent(savepointDir, savepointLocation.getSharedStateDirectory());
        this.assertParent(savepointDir, savepointLocation.getTaskOwnedStateDirectory());
        savepointLocation.disposeOnFailure();
    }

    @Test
    void testTaskOwnedStateStream() throws Exception {
        StreamStateHandle stateHandle;
        List<String> state = Arrays.asList("Flopsy", "Mopsy", "Cotton Tail", "Peter");
        FsCheckpointStorageAccess storage = new FsCheckpointStorageAccess(Path.fromLocalFile((File)TempDirUtils.newFolder((java.nio.file.Path)this.tmp)), null, true, new JobID(), 10, 4096);
        try (CheckpointStateOutputStream stream = storage.createTaskOwnedStateStream();){
            Assertions.assertThat((Object)stream).isInstanceOf(FsCheckpointStreamFactory.FsCheckpointStateOutputStream.class);
            new ObjectOutputStream((OutputStream)stream).writeObject(state);
            stateHandle = stream.closeAndGetHandle();
        }
        FileStateHandle fileStateHandle = (FileStateHandle)stateHandle;
        String parentDirName = fileStateHandle.getFilePath().getParent().getName();
        Assertions.assertThat((String)parentDirName).isEqualTo("taskowned");
        try (ObjectInputStream in = new ObjectInputStream((InputStream)stateHandle.openInputStream());){
            Assertions.assertThat((Object)in.readObject()).isEqualTo(state);
        }
    }

    @Test
    void testDirectoriesForExclusiveAndSharedState() throws Exception {
        LocalFileSystem fs = LocalFileSystem.getSharedInstance();
        Path checkpointDir = this.randomTempPath();
        Path sharedStateDir = this.randomTempPath();
        FsCheckpointStorageLocation storageLocation = new FsCheckpointStorageLocation((FileSystem)fs, checkpointDir, sharedStateDir, this.randomTempPath(), CheckpointStorageLocationReference.getDefault(), 1024, 4096);
        Assertions.assertThat((Object)storageLocation.getSharedStateDirectory()).isNotEqualTo((Object)storageLocation.getCheckpointDirectory());
        Assertions.assertThat((Object[])fs.listStatus(storageLocation.getCheckpointDirectory())).isEmpty();
        Assertions.assertThat((Object[])fs.listStatus(storageLocation.getSharedStateDirectory())).isEmpty();
        FsCheckpointStreamFactory.FsCheckpointStateOutputStream exclusiveStream = storageLocation.createCheckpointStateOutputStream(CheckpointedStateScope.EXCLUSIVE);
        exclusiveStream.write(42);
        exclusiveStream.flushToFile();
        StreamStateHandle exclusiveHandle = exclusiveStream.closeAndGetHandle();
        Assertions.assertThat((Object[])fs.listStatus(storageLocation.getCheckpointDirectory())).hasSize(1);
        Assertions.assertThat((Object[])fs.listStatus(storageLocation.getSharedStateDirectory())).isEmpty();
        FsCheckpointStreamFactory.FsCheckpointStateOutputStream sharedStream = storageLocation.createCheckpointStateOutputStream(CheckpointedStateScope.SHARED);
        sharedStream.write(42);
        sharedStream.flushToFile();
        StreamStateHandle sharedHandle = sharedStream.closeAndGetHandle();
        Assertions.assertThat((Object[])fs.listStatus(storageLocation.getCheckpointDirectory())).hasSize(1);
        Assertions.assertThat((Object[])fs.listStatus(storageLocation.getSharedStateDirectory())).hasSize(1);
        exclusiveHandle.discardState();
        sharedHandle.discardState();
    }

    @Test
    void testStorageLocationMkdirs() throws Exception {
        FsCheckpointStorageAccess storage = new FsCheckpointStorageAccess(this.randomTempPath(), null, true, new JobID(), 1024, 4096);
        File baseDir = new File(storage.getCheckpointsDirectory().getPath());
        Assertions.assertThat((File)baseDir).doesNotExist();
        storage.initializeBaseLocationsForCheckpoint();
        Assertions.assertThat((File)baseDir).exists();
        storage = new FsCheckpointStorageAccess(this.randomTempPath(), null, true, new JobID(), 1024, 4096);
        FsCheckpointStorageLocation location = (FsCheckpointStorageLocation)storage.resolveCheckpointStorageLocation(177L, CheckpointStorageLocationReference.getDefault());
        Path checkpointPath = location.getCheckpointDirectory();
        File checkpointDir = new File(checkpointPath.getPath());
        Assertions.assertThat((File)checkpointDir).doesNotExist();
    }

    @Test
    void testResolveCheckpointStorageLocation() throws Exception {
        FileSystem checkpointFileSystem = (FileSystem)Mockito.mock(FileSystem.class);
        FsCheckpointStorageAccess storage = new FsCheckpointStorageAccess((Path)new TestingPath("hdfs:///checkpoint/", checkpointFileSystem), null, true, new JobID(), 1024, 4096);
        FsCheckpointStorageLocation checkpointStreamFactory = (FsCheckpointStorageLocation)storage.resolveCheckpointStorageLocation(1L, CheckpointStorageLocationReference.getDefault());
        Assertions.assertThat((Object)checkpointStreamFactory.getFileSystem()).isEqualTo((Object)checkpointFileSystem);
        CheckpointStorageLocationReference savepointLocationReference = AbstractFsCheckpointStorageAccess.encodePathAsReference((Path)new Path("file:///savepoint/"));
        FsCheckpointStorageLocation savepointStreamFactory = (FsCheckpointStorageLocation)storage.resolveCheckpointStorageLocation(2L, savepointLocationReference);
        FileSystem fileSystem = savepointStreamFactory.getFileSystem();
        Assertions.assertThat((Object)fileSystem).isInstanceOf(LocalFileSystem.class);
    }

    @Test
    void testNotDuplicationCheckpointStateToolset() throws Exception {
        CheckpointStorageAccess checkpointStorage = this.createCheckpointStorage(this.randomTempPath(), true);
        Assertions.assertThat((Object)checkpointStorage.createTaskOwnedCheckpointStateToolset()).isInstanceOf(NotDuplicatingCheckpointStateToolset.class);
    }

    @Test
    void testDuplicationCheckpointStateToolset() throws Exception {
        FsCheckpointStorageAccess checkpointStorage = new FsCheckpointStorageAccess((FileSystem)new TestDuplicatingFileSystem(), this.randomTempPath(), null, true, new JobID(), 1024, 4096);
        Assertions.assertThat((Object)checkpointStorage.createTaskOwnedCheckpointStateToolset()).isInstanceOf(FsCheckpointStateToolset.class);
    }

    private void assertParent(Path parent, Path child) {
        Path path = new Path(parent, child.getName());
        Assertions.assertThat((Object)child).isEqualTo((Object)path);
    }

    private static final class TestingPath
    extends Path {
        private static final long serialVersionUID = 2560119808844230488L;
        @Nonnull
        private final transient FileSystem fileSystem;

        TestingPath(String pathString, @Nonnull FileSystem fileSystem) {
            super(pathString);
            this.fileSystem = fileSystem;
        }

        public FileSystem getFileSystem() {
            return this.fileSystem;
        }
    }

    private static final class TestDuplicatingFileSystem
    extends TestFileSystem
    implements DuplicatingFileSystem {
        private TestDuplicatingFileSystem() {
        }

        public boolean canFastDuplicate(Path source, Path destination) throws IOException {
            return !source.equals((Object)destination);
        }

        public void duplicate(List<DuplicatingFileSystem.CopyRequest> requests) throws IOException {
        }
    }
}

