/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.runtime.executiongraph.DefaultSubtaskAttemptNumberStore;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class DefaultSubtaskAttemptNumberStoreTest {
    DefaultSubtaskAttemptNumberStoreTest() {
    }

    @Test
    void testGetAttemptCount() {
        List<Integer> initialAttemptCounts = Arrays.asList(1, 2, 3);
        DefaultSubtaskAttemptNumberStore subtaskAttemptNumberStore = new DefaultSubtaskAttemptNumberStore(initialAttemptCounts);
        Assertions.assertThat((int)subtaskAttemptNumberStore.getAttemptCount(1)).isEqualTo((Object)initialAttemptCounts.get(1));
    }

    @Test
    void testOutOfBoundsSubtaskIndexReturnsZero() {
        List<Integer> initialAttemptCounts = Arrays.asList(1, 2, 3);
        DefaultSubtaskAttemptNumberStore subtaskAttemptNumberStore = new DefaultSubtaskAttemptNumberStore(initialAttemptCounts);
        Assertions.assertThat((int)subtaskAttemptNumberStore.getAttemptCount(initialAttemptCounts.size() * 2)).isZero();
    }

    @Test
    void testNegativeSubtaskIndexRejected() {
        DefaultSubtaskAttemptNumberStore subtaskAttemptNumberStore = new DefaultSubtaskAttemptNumberStore(Collections.emptyList());
        Assertions.assertThatThrownBy(() -> subtaskAttemptNumberStore.getAttemptCount(-1)).isInstanceOf(IllegalArgumentException.class);
    }
}

