/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.buffer;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.runtime.execution.CancelTaskException;
import org.apache.flink.runtime.io.network.buffer.BufferBuilderTestUtils;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.buffer.LocalBufferPool;
import org.apache.flink.runtime.io.network.buffer.NetworkBufferPool;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

class LocalBufferPoolDestroyTest {
    LocalBufferPoolDestroyTest() {
    }

    @Test
    void testRequestAfterDestroy() {
        NetworkBufferPool networkBufferPool = new NetworkBufferPool(1, 4096);
        LocalBufferPool localBufferPool = new LocalBufferPool(networkBufferPool, 1);
        localBufferPool.lazyDestroy();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((LocalBufferPool)localBufferPool).requestBuffer()).withFailMessage("Call should have failed with an CancelTaskException", new Object[0])).isInstanceOf(CancelTaskException.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testDestroyWhileBlockingRequest() throws Exception {
        AtomicReference<Exception> asyncException = new AtomicReference<Exception>();
        NetworkBufferPool networkBufferPool = null;
        LocalBufferPool localBufferPool = null;
        try {
            StackTraceElement[] stackTrace;
            networkBufferPool = new NetworkBufferPool(1, 4096);
            localBufferPool = new LocalBufferPool(networkBufferPool, 1);
            Assertions.assertThat((Object)localBufferPool.requestBuffer()).isNotNull();
            Assertions.assertThat((Object)localBufferPool.requestBuffer()).isNull();
            Thread thread = new Thread(new BufferRequestTask((BufferPool)localBufferPool, asyncException));
            thread.start();
            boolean success = false;
            for (int i = 0; i < 50 && !(success = BufferBuilderTestUtils.isInBlockingBufferRequest(stackTrace = thread.getStackTrace())); ++i) {
                Thread.sleep(500L);
            }
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)success).withFailMessage("Did not trigger blocking buffer request.", new Object[0])).isTrue();
            localBufferPool.lazyDestroy();
            thread.join();
            ((AbstractThrowableAssert)Assertions.assertThat((Throwable)asyncException.get()).withFailMessage("Did not throw expected Exception", new Object[0])).isInstanceOf(CancelTaskException.class);
        }
        finally {
            if (localBufferPool != null) {
                localBufferPool.lazyDestroy();
            }
            if (networkBufferPool != null) {
                networkBufferPool.destroyAllBufferPools();
                networkBufferPool.destroy();
            }
        }
    }

    private static class BufferRequestTask
    implements Runnable {
        private final BufferPool bufferPool;
        private final AtomicReference<Exception> asyncException;

        BufferRequestTask(BufferPool bufferPool, AtomicReference<Exception> asyncException) {
            this.bufferPool = bufferPool;
            this.asyncException = asyncException;
        }

        @Override
        public void run() {
            try {
                String msg = "Test assumption violated: expected no available buffer";
                ((ObjectAssert)Assertions.assertThat((Object)this.bufferPool.requestBuffer()).withFailMessage(msg, new Object[0])).isNull();
                this.bufferPool.requestBufferBuilderBlocking();
            }
            catch (Exception t) {
                this.asyncException.set(t);
            }
        }
    }
}

