/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import javax.annotation.Nullable;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.CheckpointMetadataOutputStream;
import org.apache.flink.runtime.state.CheckpointStorageAccess;
import org.apache.flink.runtime.state.CheckpointStorageLocation;
import org.apache.flink.runtime.state.CompletedCheckpointStorageLocation;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.filesystem.FileStateHandle;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public abstract class AbstractFileCheckpointStorageAccessTestBase {
    @TempDir
    protected java.nio.file.Path tmp;

    protected abstract CheckpointStorageAccess createCheckpointStorage(Path var1, boolean var2) throws Exception;

    protected abstract CheckpointStorageAccess createCheckpointStorageWithSavepointDir(Path var1, Path var2, boolean var3) throws Exception;

    @Test
    void testPointerPathResolution() throws Exception {
        FileSystem fs = FileSystem.getLocalFileSystem();
        Path metadataFile = new Path(Path.fromLocalFile((File)TempDirUtils.newFolder((java.nio.file.Path)this.tmp)), "_metadata");
        String basePointer = metadataFile.getParent().toString();
        String pointer1 = metadataFile.toString();
        String pointer2 = metadataFile.getParent().toString();
        String pointer3 = metadataFile.getParent().toString() + '/';
        CheckpointStorageAccess storage = this.createCheckpointStorage(this.randomTempPath(), true);
        byte[] data = new byte[23686];
        new Random().nextBytes(data);
        try (FSDataOutputStream out = fs.create(metadataFile, FileSystem.WriteMode.NO_OVERWRITE);){
            out.write(data);
        }
        CompletedCheckpointStorageLocation completed1 = storage.resolveCheckpoint(pointer1);
        CompletedCheckpointStorageLocation completed2 = storage.resolveCheckpoint(pointer2);
        CompletedCheckpointStorageLocation completed3 = storage.resolveCheckpoint(pointer3);
        Assertions.assertThat((String)completed1.getExternalPointer()).isEqualTo(basePointer);
        Assertions.assertThat((String)completed2.getExternalPointer()).isEqualTo(basePointer);
        Assertions.assertThat((String)completed3.getExternalPointer()).isEqualTo(basePointer);
        StreamStateHandle handle1 = completed1.getMetadataHandle();
        StreamStateHandle handle2 = completed2.getMetadataHandle();
        StreamStateHandle handle3 = completed3.getMetadataHandle();
        Assertions.assertThat((Object)handle1).isNotNull();
        Assertions.assertThat((Object)handle2).isNotNull();
        Assertions.assertThat((Object)handle3).isNotNull();
        AbstractFileCheckpointStorageAccessTestBase.validateContents(handle1, data);
        AbstractFileCheckpointStorageAccessTestBase.validateContents(handle2, data);
        AbstractFileCheckpointStorageAccessTestBase.validateContents(handle3, data);
    }

    @Test
    void testFailingPointerPathResolution() throws Exception {
        CheckpointStorageAccess storage = this.createCheckpointStorage(this.randomTempPath(), true);
        Assertions.assertThatThrownBy(() -> storage.resolveCheckpoint(null)).isInstanceOf(NullPointerException.class);
        Assertions.assertThatThrownBy(() -> storage.resolveCheckpoint("")).isInstanceOf(IllegalArgumentException.class);
        Assertions.assertThatThrownBy(() -> storage.resolveCheckpoint("this-is_not/a#filepath.at.all")).isInstanceOf(IOException.class);
        Assertions.assertThatThrownBy(() -> storage.resolveCheckpoint(TempDirUtils.newFile((java.nio.file.Path)this.tmp).toURI().toString() + "_not_existing")).isInstanceOf(IOException.class);
    }

    @ParameterizedTest(name="create checkpoint job-id sub-directory: {0}")
    @ValueSource(booleans={true, false})
    public void testCreateCheckpointSubDirs(boolean createCheckpointSubDir) throws Exception {
        FileSystem fs = FileSystem.getLocalFileSystem();
        Path checkpointDir = Path.fromLocalFile((File)TempDirUtils.newFolder((java.nio.file.Path)this.tmp));
        CheckpointStorageAccess checkpointStorage = this.createCheckpointStorage(checkpointDir, createCheckpointSubDir);
        checkpointStorage.initializeBaseLocationsForCheckpoint();
        checkpointStorage.initializeLocationForCheckpoint(42L);
        FileStatus[] fileStatuses = fs.listStatus(checkpointDir);
        if (createCheckpointSubDir) {
            for (FileStatus fileStatus : fileStatuses) {
                Assertions.assertThat((fs.listStatus(fileStatus.getPath()).length > 0 ? 1 : 0) != 0).isTrue();
            }
        } else {
            for (FileStatus fileStatus : fileStatuses) {
                Assertions.assertThat((int)fs.listStatus(fileStatus.getPath()).length).isEqualTo(0);
            }
        }
    }

    @Test
    void testPersistMultipleMetadataOnlyCheckpoints() throws Exception {
        CompletedCheckpointStorageLocation completedLocation2;
        CompletedCheckpointStorageLocation completedLocation1;
        FileSystem fs = FileSystem.getLocalFileSystem();
        Path checkpointDir = new Path(TempDirUtils.newFolder((java.nio.file.Path)this.tmp).toURI());
        long checkpointId = 177L;
        CheckpointStorageAccess storage1 = this.createCheckpointStorage(checkpointDir, true);
        storage1.initializeBaseLocationsForCheckpoint();
        CheckpointStorageAccess storage2 = this.createCheckpointStorage(checkpointDir, true);
        storage2.initializeBaseLocationsForCheckpoint();
        CheckpointStorageLocation loc1 = storage1.initializeLocationForCheckpoint(177L);
        CheckpointStorageLocation loc2 = storage2.initializeLocationForCheckpoint(177L);
        byte[] data1 = new byte[]{77, 66, 55, 99, 88};
        byte[] data2 = new byte[]{1, 3, 2, 5, 4};
        try (CheckpointMetadataOutputStream out = loc1.createMetadataOutputStream();){
            out.write(data1);
            completedLocation1 = out.closeAndFinalizeCheckpoint();
        }
        String result1 = completedLocation1.getExternalPointer();
        try (CheckpointMetadataOutputStream out = loc2.createMetadataOutputStream();){
            out.write(data2);
            completedLocation2 = out.closeAndFinalizeCheckpoint();
        }
        String result2 = completedLocation2.getExternalPointer();
        Object[] files = fs.listStatus(checkpointDir);
        Assertions.assertThat((Object[])files).hasSize(2);
        Object[] job1Files = fs.listStatus(files[0].getPath());
        Object[] job2Files = fs.listStatus(files[1].getPath());
        Assertions.assertThat((Object[])job1Files).hasSizeGreaterThanOrEqualTo(1);
        Assertions.assertThat((Object[])job2Files).hasSizeGreaterThanOrEqualTo(1);
        Assertions.assertThat((boolean)fs.exists(new Path(result1, "_metadata"))).isTrue();
        Assertions.assertThat((boolean)fs.exists(new Path(result2, "_metadata"))).isTrue();
        AbstractFileCheckpointStorageAccessTestBase.validateContents(storage1.resolveCheckpoint(result1).getMetadataHandle(), data1);
        AbstractFileCheckpointStorageAccessTestBase.validateContents(storage1.resolveCheckpoint(result2).getMetadataHandle(), data2);
        AbstractFileCheckpointStorageAccessTestBase.validateContents(storage2.resolveCheckpoint(result1).getMetadataHandle(), data1);
        AbstractFileCheckpointStorageAccessTestBase.validateContents(storage2.resolveCheckpoint(result2).getMetadataHandle(), data2);
    }

    @Test
    void writeToAlreadyExistingCheckpointFails() throws Exception {
        byte[] data = new byte[]{8, 8, 4, 5, 2, 6, 3};
        long checkpointId = 177L;
        CheckpointStorageAccess storage = this.createCheckpointStorage(this.randomTempPath(), true);
        storage.initializeBaseLocationsForCheckpoint();
        CheckpointStorageLocation loc = storage.initializeLocationForCheckpoint(177L);
        try (CheckpointMetadataOutputStream out = loc.createMetadataOutputStream();){
            out.write(data);
            out.closeAndFinalizeCheckpoint();
        }
        Assertions.assertThatThrownBy(() -> ((CheckpointStorageLocation)loc).createMetadataOutputStream()).isInstanceOf(IOException.class);
    }

    @Test
    void testSavepointPathConfiguredAndTarget() throws Exception {
        Path savepointDir = this.randomTempPath();
        Path customDir = this.randomTempPath();
        this.testSavepoint(savepointDir, customDir, customDir);
    }

    @Test
    void testSavepointPathConfiguredNoTarget() throws Exception {
        Path savepointDir = this.randomTempPath();
        this.testSavepoint(savepointDir, null, savepointDir);
    }

    @Test
    void testNoSavepointPathConfiguredAndTarget() throws Exception {
        Path customDir = Path.fromLocalFile((File)TempDirUtils.newFolder((java.nio.file.Path)this.tmp));
        this.testSavepoint(null, customDir, customDir);
    }

    @Test
    void testNoSavepointPathConfiguredNoTarget() throws Exception {
        CheckpointStorageAccess storage = this.createCheckpointStorage(this.randomTempPath(), true);
        Assertions.assertThatThrownBy(() -> storage.initializeLocationForSavepoint(1337L, null)).isInstanceOf(IllegalArgumentException.class);
    }

    private void testSavepoint(@Nullable Path savepointDir, @Nullable Path customDir, Path expectedParent) throws Exception {
        CompletedCheckpointStorageLocation completed;
        CheckpointStorageAccess storage = savepointDir == null ? this.createCheckpointStorage(this.randomTempPath(), true) : this.createCheckpointStorageWithSavepointDir(this.randomTempPath(), savepointDir, true);
        String customLocation = customDir == null ? null : customDir.toString();
        CheckpointStorageLocation savepointLocation = storage.initializeLocationForSavepoint(52452L, customLocation);
        byte[] data = new byte[]{77, 66, 55, 99, 88};
        try (CheckpointMetadataOutputStream out = savepointLocation.createMetadataOutputStream();){
            out.write(data);
            completed = out.closeAndFinalizeCheckpoint();
        }
        Path normalizedWithSlash = Path.fromLocalFile((File)new File(new Path(completed.getExternalPointer()).getParent().getPath()));
        Assertions.assertThat((Object)normalizedWithSlash).isEqualTo((Object)expectedParent);
        AbstractFileCheckpointStorageAccessTestBase.validateContents(completed.getMetadataHandle(), data);
        FileStateHandle fileStateHandle = (FileStateHandle)completed.getMetadataHandle();
        Path usedSavepointDir = new Path(new File(fileStateHandle.getFilePath().getParent().getParent().getPath()).toURI());
        Assertions.assertThat((Object)usedSavepointDir).isEqualTo((Object)expectedParent);
    }

    public Path randomTempPath() throws IOException {
        return Path.fromLocalFile((File)TempDirUtils.newFolder((java.nio.file.Path)this.tmp));
    }

    private static void validateContents(StreamStateHandle handle, byte[] expected) throws IOException {
        try (FSDataInputStream in = handle.openInputStream();){
            AbstractFileCheckpointStorageAccessTestBase.validateContents((InputStream)in, expected);
        }
    }

    private static void validateContents(InputStream in, byte[] expected) throws IOException {
        int read;
        byte[] buffer = new byte[expected.length];
        int pos = 0;
        for (int remaining = expected.length; remaining > 0; remaining -= read) {
            read = in.read(buffer, pos, remaining);
            if (read == -1) {
                throw new EOFException();
            }
            pos += read;
        }
        Assertions.assertThat((byte[])buffer).isEqualTo((Object)expected);
    }
}

