/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.utils;

import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.api.java.tuple.Tuple5;
import org.apache.flink.api.java.tuple.Tuple6;
import org.apache.flink.core.execution.CheckpointType;
import org.apache.flink.core.execution.SavepointFormatType;
import org.apache.flink.queryablestate.KvStateID;
import org.apache.flink.runtime.blocklist.BlockedNode;
import org.apache.flink.runtime.checkpoint.CheckpointMetrics;
import org.apache.flink.runtime.checkpoint.CheckpointStatsSnapshot;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.SubTaskInitializationMetrics;
import org.apache.flink.runtime.checkpoint.TaskStateSnapshot;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.JobResourceRequirements;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobmaster.JobMasterGateway;
import org.apache.flink.runtime.jobmaster.JobMasterId;
import org.apache.flink.runtime.jobmaster.SerializedInputSplit;
import org.apache.flink.runtime.jobmaster.TaskManagerRegistrationInformation;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.messages.checkpoint.DeclineCheckpoint;
import org.apache.flink.runtime.operators.coordination.CoordinationRequest;
import org.apache.flink.runtime.operators.coordination.CoordinationResponse;
import org.apache.flink.runtime.operators.coordination.OperatorEvent;
import org.apache.flink.runtime.query.KvStateLocation;
import org.apache.flink.runtime.registration.RegistrationResponse;
import org.apache.flink.runtime.resourcemanager.ResourceManagerId;
import org.apache.flink.runtime.scheduler.ExecutionGraphInfo;
import org.apache.flink.runtime.shuffle.PartitionWithMetrics;
import org.apache.flink.runtime.slots.ResourceRequirement;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.taskexecutor.TaskExecutorToJobManagerHeartbeatPayload;
import org.apache.flink.runtime.taskexecutor.slot.SlotOffer;
import org.apache.flink.runtime.taskmanager.TaskExecutionState;
import org.apache.flink.util.SerializedValue;
import org.apache.flink.util.function.TriConsumer;
import org.apache.flink.util.function.TriFunction;

public class TestingJobMasterGateway
implements JobMasterGateway {
    @Nonnull
    private final String address;
    @Nonnull
    private final String hostname;
    @Nonnull
    private final Supplier<CompletableFuture<Acknowledge>> cancelFunction;
    @Nonnull
    private final Function<TaskExecutionState, CompletableFuture<Acknowledge>> updateTaskExecutionStateFunction;
    @Nonnull
    private final BiFunction<JobVertexID, ExecutionAttemptID, CompletableFuture<SerializedInputSplit>> requestNextInputSplitFunction;
    @Nonnull
    private final BiFunction<IntermediateDataSetID, ResultPartitionID, CompletableFuture<ExecutionState>> requestPartitionStateFunction;
    @Nonnull
    private final Function<ResourceID, CompletableFuture<Acknowledge>> disconnectTaskManagerFunction;
    @Nonnull
    private final Consumer<ResourceManagerId> disconnectResourceManagerConsumer;
    @Nonnull
    private final BiFunction<ResourceID, Collection<SlotOffer>, CompletableFuture<Collection<SlotOffer>>> offerSlotsFunction;
    @Nonnull
    private final TriConsumer<ResourceID, AllocationID, Throwable> failSlotConsumer;
    @Nonnull
    private final BiFunction<JobID, TaskManagerRegistrationInformation, CompletableFuture<RegistrationResponse>> registerTaskManagerFunction;
    @Nonnull
    private final BiFunction<ResourceID, TaskExecutorToJobManagerHeartbeatPayload, CompletableFuture<Void>> taskManagerHeartbeatFunction;
    @Nonnull
    private final Function<ResourceID, CompletableFuture<Void>> resourceManagerHeartbeatFunction;
    @Nonnull
    private final Supplier<CompletableFuture<JobStatus>> requestJobStatusSupplier;
    @Nonnull
    private final Supplier<CompletableFuture<ExecutionGraphInfo>> requestJobSupplier;
    @Nonnull
    private final Supplier<CompletableFuture<CheckpointStatsSnapshot>> checkpointStatsSnapshotSupplier;
    @Nonnull
    private final TriFunction<String, Boolean, SavepointFormatType, CompletableFuture<String>> triggerSavepointFunction;
    @Nonnull
    private final Function<CheckpointType, CompletableFuture<CompletedCheckpoint>> triggerCheckpointFunction;
    @Nonnull
    private final TriFunction<String, Boolean, SavepointFormatType, CompletableFuture<String>> stopWithSavepointFunction;
    @Nonnull
    private final Consumer<Tuple5<JobID, ExecutionAttemptID, Long, CheckpointMetrics, TaskStateSnapshot>> acknowledgeCheckpointConsumer;
    @Nonnull
    private final Consumer<DeclineCheckpoint> declineCheckpointConsumer;
    @Nonnull
    private final Supplier<JobMasterId> fencingTokenSupplier;
    @Nonnull
    private final BiFunction<JobID, String, CompletableFuture<KvStateLocation>> requestKvStateLocationFunction;
    @Nonnull
    private final Function<Tuple6<JobID, JobVertexID, KeyGroupRange, String, KvStateID, InetSocketAddress>, CompletableFuture<Acknowledge>> notifyKvStateRegisteredFunction;
    @Nonnull
    private final Function<Tuple4<JobID, JobVertexID, KeyGroupRange, String>, CompletableFuture<Acknowledge>> notifyKvStateUnregisteredFunction;
    @Nonnull
    private final BiFunction<Duration, Set<ResultPartitionID>, CompletableFuture<Collection<PartitionWithMetrics>>> getPartitionWithMetricsFunction;
    @Nonnull
    TriFunction<String, Object, byte[], CompletableFuture<Object>> updateAggregateFunction;
    @Nonnull
    private final TriFunction<ExecutionAttemptID, OperatorID, SerializedValue<OperatorEvent>, CompletableFuture<Acknowledge>> operatorEventSender;
    @Nonnull
    private final BiFunction<OperatorID, SerializedValue<CoordinationRequest>, CompletableFuture<CoordinationResponse>> deliverCoordinationRequestFunction;
    private final Consumer<Collection<ResourceRequirement>> notifyNotEnoughResourcesConsumer;
    private final Function<Collection<BlockedNode>, CompletableFuture<Acknowledge>> notifyNewBlockedNodesFunction;
    private final Supplier<CompletableFuture<JobResourceRequirements>> requestJobResourceRequirementsSupplier;
    private final Function<JobResourceRequirements, CompletableFuture<Acknowledge>> updateJobResourceRequirementsFunction;

    public TestingJobMasterGateway(@Nonnull String address, @Nonnull String hostname, @Nonnull Supplier<CompletableFuture<Acknowledge>> cancelFunction, @Nonnull Function<TaskExecutionState, CompletableFuture<Acknowledge>> updateTaskExecutionStateFunction, @Nonnull BiFunction<JobVertexID, ExecutionAttemptID, CompletableFuture<SerializedInputSplit>> requestNextInputSplitFunction, @Nonnull BiFunction<IntermediateDataSetID, ResultPartitionID, CompletableFuture<ExecutionState>> requestPartitionStateFunction, @Nonnull Function<ResourceID, CompletableFuture<Acknowledge>> disconnectTaskManagerFunction, @Nonnull Consumer<ResourceManagerId> disconnectResourceManagerConsumer, @Nonnull BiFunction<ResourceID, Collection<SlotOffer>, CompletableFuture<Collection<SlotOffer>>> offerSlotsFunction, @Nonnull TriConsumer<ResourceID, AllocationID, Throwable> failSlotConsumer, @Nonnull BiFunction<JobID, TaskManagerRegistrationInformation, CompletableFuture<RegistrationResponse>> registerTaskManagerFunction, @Nonnull BiFunction<ResourceID, TaskExecutorToJobManagerHeartbeatPayload, CompletableFuture<Void>> taskManagerHeartbeatFunction, @Nonnull Function<ResourceID, CompletableFuture<Void>> resourceManagerHeartbeatFunction, @Nonnull Supplier<CompletableFuture<JobStatus>> requestJobStatusSupplier, @Nonnull Supplier<CompletableFuture<ExecutionGraphInfo>> requestJobSupplier, @Nonnull Supplier<CompletableFuture<CheckpointStatsSnapshot>> checkpointStatsSnapshotSupplier, @Nonnull TriFunction<String, Boolean, SavepointFormatType, CompletableFuture<String>> triggerSavepointFunction, @Nonnull Function<CheckpointType, CompletableFuture<CompletedCheckpoint>> triggerCheckpointFunction, @Nonnull TriFunction<String, Boolean, SavepointFormatType, CompletableFuture<String>> stopWithSavepointFunction, @Nonnull Consumer<Tuple5<JobID, ExecutionAttemptID, Long, CheckpointMetrics, TaskStateSnapshot>> acknowledgeCheckpointConsumer, @Nonnull Consumer<DeclineCheckpoint> declineCheckpointConsumer, @Nonnull Supplier<JobMasterId> fencingTokenSupplier, @Nonnull BiFunction<JobID, String, CompletableFuture<KvStateLocation>> requestKvStateLocationFunction, @Nonnull Function<Tuple6<JobID, JobVertexID, KeyGroupRange, String, KvStateID, InetSocketAddress>, CompletableFuture<Acknowledge>> notifyKvStateRegisteredFunction, @Nonnull Function<Tuple4<JobID, JobVertexID, KeyGroupRange, String>, CompletableFuture<Acknowledge>> notifyKvStateUnregisteredFunction, @Nonnull TriFunction<String, Object, byte[], CompletableFuture<Object>> updateAggregateFunction, @Nonnull TriFunction<ExecutionAttemptID, OperatorID, SerializedValue<OperatorEvent>, CompletableFuture<Acknowledge>> operatorEventSender, @Nonnull BiFunction<OperatorID, SerializedValue<CoordinationRequest>, CompletableFuture<CoordinationResponse>> deliverCoordinationRequestFunction, @Nonnull Consumer<Collection<ResourceRequirement>> notifyNotEnoughResourcesConsumer, @Nonnull Function<Collection<BlockedNode>, CompletableFuture<Acknowledge>> notifyNewBlockedNodesFunction, @Nonnull Supplier<CompletableFuture<JobResourceRequirements>> requestJobResourceRequirementsSupplier, @Nonnull Function<JobResourceRequirements, CompletableFuture<Acknowledge>> updateJobResourceRequirementsFunction, @Nonnull BiFunction<Duration, Set<ResultPartitionID>, CompletableFuture<Collection<PartitionWithMetrics>>> getPartitionWithMetricsFunction) {
        this.address = address;
        this.hostname = hostname;
        this.cancelFunction = cancelFunction;
        this.updateTaskExecutionStateFunction = updateTaskExecutionStateFunction;
        this.requestNextInputSplitFunction = requestNextInputSplitFunction;
        this.requestPartitionStateFunction = requestPartitionStateFunction;
        this.disconnectTaskManagerFunction = disconnectTaskManagerFunction;
        this.disconnectResourceManagerConsumer = disconnectResourceManagerConsumer;
        this.offerSlotsFunction = offerSlotsFunction;
        this.failSlotConsumer = failSlotConsumer;
        this.registerTaskManagerFunction = registerTaskManagerFunction;
        this.taskManagerHeartbeatFunction = taskManagerHeartbeatFunction;
        this.resourceManagerHeartbeatFunction = resourceManagerHeartbeatFunction;
        this.requestJobStatusSupplier = requestJobStatusSupplier;
        this.requestJobSupplier = requestJobSupplier;
        this.checkpointStatsSnapshotSupplier = checkpointStatsSnapshotSupplier;
        this.triggerSavepointFunction = triggerSavepointFunction;
        this.triggerCheckpointFunction = triggerCheckpointFunction;
        this.stopWithSavepointFunction = stopWithSavepointFunction;
        this.acknowledgeCheckpointConsumer = acknowledgeCheckpointConsumer;
        this.declineCheckpointConsumer = declineCheckpointConsumer;
        this.fencingTokenSupplier = fencingTokenSupplier;
        this.requestKvStateLocationFunction = requestKvStateLocationFunction;
        this.notifyKvStateRegisteredFunction = notifyKvStateRegisteredFunction;
        this.notifyKvStateUnregisteredFunction = notifyKvStateUnregisteredFunction;
        this.updateAggregateFunction = updateAggregateFunction;
        this.operatorEventSender = operatorEventSender;
        this.deliverCoordinationRequestFunction = deliverCoordinationRequestFunction;
        this.notifyNotEnoughResourcesConsumer = notifyNotEnoughResourcesConsumer;
        this.notifyNewBlockedNodesFunction = notifyNewBlockedNodesFunction;
        this.requestJobResourceRequirementsSupplier = requestJobResourceRequirementsSupplier;
        this.updateJobResourceRequirementsFunction = updateJobResourceRequirementsFunction;
        this.getPartitionWithMetricsFunction = getPartitionWithMetricsFunction;
    }

    public CompletableFuture<Collection<PartitionWithMetrics>> getPartitionWithMetrics(Duration timeout, Set<ResultPartitionID> expectedPartitions) {
        return this.getPartitionWithMetricsFunction.apply(timeout, expectedPartitions);
    }

    public CompletableFuture<Acknowledge> cancel(Time timeout) {
        return this.cancelFunction.get();
    }

    public CompletableFuture<Acknowledge> updateTaskExecutionState(TaskExecutionState taskExecutionState) {
        return this.updateTaskExecutionStateFunction.apply(taskExecutionState);
    }

    public CompletableFuture<SerializedInputSplit> requestNextInputSplit(JobVertexID vertexID, ExecutionAttemptID executionAttempt) {
        return this.requestNextInputSplitFunction.apply(vertexID, executionAttempt);
    }

    public CompletableFuture<ExecutionState> requestPartitionState(IntermediateDataSetID intermediateResultId, ResultPartitionID partitionId) {
        return this.requestPartitionStateFunction.apply(intermediateResultId, partitionId);
    }

    public CompletableFuture<Acknowledge> disconnectTaskManager(ResourceID resourceID, Exception cause) {
        return this.disconnectTaskManagerFunction.apply(resourceID);
    }

    public void disconnectResourceManager(ResourceManagerId resourceManagerId, Exception cause) {
        this.disconnectResourceManagerConsumer.accept(resourceManagerId);
    }

    public CompletableFuture<Collection<SlotOffer>> offerSlots(ResourceID taskManagerId, Collection<SlotOffer> slots, Time timeout) {
        return this.offerSlotsFunction.apply(taskManagerId, slots);
    }

    public void failSlot(ResourceID taskManagerId, AllocationID allocationId, Exception cause) {
        this.failSlotConsumer.accept((Object)taskManagerId, (Object)allocationId, (Object)cause);
    }

    public CompletableFuture<RegistrationResponse> registerTaskManager(JobID jobId, TaskManagerRegistrationInformation taskManagerRegistrationInformation, Time timeout) {
        return this.registerTaskManagerFunction.apply(jobId, taskManagerRegistrationInformation);
    }

    public CompletableFuture<Void> heartbeatFromTaskManager(ResourceID resourceID, TaskExecutorToJobManagerHeartbeatPayload payload) {
        return this.taskManagerHeartbeatFunction.apply(resourceID, payload);
    }

    public CompletableFuture<Void> heartbeatFromResourceManager(ResourceID resourceID) {
        return this.resourceManagerHeartbeatFunction.apply(resourceID);
    }

    public CompletableFuture<JobStatus> requestJobStatus(Time timeout) {
        return this.requestJobStatusSupplier.get();
    }

    public CompletableFuture<ExecutionGraphInfo> requestJob(Time timeout) {
        return this.requestJobSupplier.get();
    }

    public CompletableFuture<CheckpointStatsSnapshot> requestCheckpointStats(Time timeout) {
        return this.checkpointStatsSnapshotSupplier.get();
    }

    public CompletableFuture<String> triggerSavepoint(@Nullable String targetDirectory, boolean cancelJob, SavepointFormatType formatType, Time timeout) {
        return (CompletableFuture)this.triggerSavepointFunction.apply((Object)targetDirectory, (Object)cancelJob, (Object)formatType);
    }

    public CompletableFuture<CompletedCheckpoint> triggerCheckpoint(CheckpointType checkpointType, Time timeout) {
        return this.triggerCheckpointFunction.apply(checkpointType);
    }

    public CompletableFuture<String> stopWithSavepoint(@Nullable String targetDirectory, SavepointFormatType formatType, boolean terminate, Time timeout) {
        return (CompletableFuture)this.stopWithSavepointFunction.apply((Object)targetDirectory, (Object)terminate, (Object)formatType);
    }

    public void notifyNotEnoughResourcesAvailable(Collection<ResourceRequirement> acquiredResources) {
        this.notifyNotEnoughResourcesConsumer.accept(acquiredResources);
    }

    public void acknowledgeCheckpoint(JobID jobID, ExecutionAttemptID executionAttemptID, long checkpointId, CheckpointMetrics checkpointMetrics, SerializedValue<TaskStateSnapshot> subtaskState) {
        this.acknowledgeCheckpointConsumer.accept((Tuple5<JobID, ExecutionAttemptID, Long, CheckpointMetrics, TaskStateSnapshot>)Tuple5.of((Object)jobID, (Object)executionAttemptID, (Object)checkpointId, (Object)checkpointMetrics, (Object)TaskStateSnapshot.deserializeTaskStateSnapshot(subtaskState, (ClassLoader)this.getClass().getClassLoader())));
    }

    public void declineCheckpoint(DeclineCheckpoint declineCheckpoint) {
        this.declineCheckpointConsumer.accept(declineCheckpoint);
    }

    public void reportCheckpointMetrics(JobID jobID, ExecutionAttemptID executionAttemptID, long checkpointId, CheckpointMetrics checkpointMetrics) {
    }

    public void reportInitializationMetrics(JobID jobId, SubTaskInitializationMetrics initializationMetrics) {
    }

    public JobMasterId getFencingToken() {
        return this.fencingTokenSupplier.get();
    }

    public CompletableFuture<KvStateLocation> requestKvStateLocation(JobID jobId, String registrationName) {
        return this.requestKvStateLocationFunction.apply(jobId, registrationName);
    }

    public CompletableFuture<Acknowledge> notifyKvStateRegistered(JobID jobId, JobVertexID jobVertexId, KeyGroupRange keyGroupRange, String registrationName, KvStateID kvStateId, InetSocketAddress kvStateServerAddress) {
        return this.notifyKvStateRegisteredFunction.apply((Tuple6<JobID, JobVertexID, KeyGroupRange, String, KvStateID, InetSocketAddress>)Tuple6.of((Object)jobId, (Object)jobVertexId, (Object)keyGroupRange, (Object)registrationName, (Object)kvStateId, (Object)kvStateServerAddress));
    }

    public CompletableFuture<Acknowledge> notifyKvStateUnregistered(JobID jobId, JobVertexID jobVertexId, KeyGroupRange keyGroupRange, String registrationName) {
        return this.notifyKvStateUnregisteredFunction.apply((Tuple4<JobID, JobVertexID, KeyGroupRange, String>)Tuple4.of((Object)jobId, (Object)jobVertexId, (Object)keyGroupRange, (Object)registrationName));
    }

    public String getAddress() {
        return this.address;
    }

    public String getHostname() {
        return this.hostname;
    }

    public CompletableFuture<Object> updateGlobalAggregate(String aggregateName, Object aggregand, byte[] serializedAggregateFunction) {
        return (CompletableFuture)this.updateAggregateFunction.apply((Object)aggregateName, aggregand, (Object)serializedAggregateFunction);
    }

    public CompletableFuture<Acknowledge> sendOperatorEventToCoordinator(ExecutionAttemptID task, OperatorID operatorID, SerializedValue<OperatorEvent> event) {
        return (CompletableFuture)this.operatorEventSender.apply((Object)task, (Object)operatorID, event);
    }

    public CompletableFuture<CoordinationResponse> sendRequestToCoordinator(OperatorID operatorID, SerializedValue<CoordinationRequest> request) {
        return this.deliverCoordinationRequestFunction.apply(operatorID, request);
    }

    public CompletableFuture<CoordinationResponse> deliverCoordinationRequestToCoordinator(OperatorID operatorId, SerializedValue<CoordinationRequest> serializedRequest, Time timeout) {
        return this.deliverCoordinationRequestFunction.apply(operatorId, serializedRequest);
    }

    public CompletableFuture<?> stopTrackingAndReleasePartitions(Collection<ResultPartitionID> partitionIds) {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Acknowledge> notifyNewBlockedNodes(Collection<BlockedNode> newNodes) {
        return this.notifyNewBlockedNodesFunction.apply(newNodes);
    }

    public CompletableFuture<JobResourceRequirements> requestJobResourceRequirements() {
        return this.requestJobResourceRequirementsSupplier.get();
    }

    public CompletableFuture<Acknowledge> updateJobResourceRequirements(JobResourceRequirements jobResourceRequirements) {
        return this.updateJobResourceRequirementsFunction.apply(jobResourceRequirements);
    }

    public void notifyEndOfData(ExecutionAttemptID executionAttempt) {
    }
}

