/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.runtime.messages.FlinkJobNotFoundException;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.job.JobExecutionResultHandler;
import org.apache.flink.runtime.rest.handler.legacy.utils.ArchivedExecutionGraphBuilder;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobMessageParameters;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.job.JobExecutionResultResponseBody;
import org.apache.flink.runtime.rest.messages.queue.QueueStatus;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.TestingRestfulGateway;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.util.concurrent.FutureUtils;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class JobExecutionResultHandlerTest {
    private static final JobID TEST_JOB_ID = new JobID();
    private JobExecutionResultHandler jobExecutionResultHandler;
    private HandlerRequest<EmptyRequestBody> testRequest;

    JobExecutionResultHandlerTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        TestingRestfulGateway testingRestfulGateway = new TestingRestfulGateway.Builder().build();
        this.jobExecutionResultHandler = new JobExecutionResultHandler(() -> CompletableFuture.completedFuture(testingRestfulGateway), Time.seconds((long)10L), Collections.emptyMap());
        this.testRequest = HandlerRequest.resolveParametersAndCreate((RequestBody)EmptyRequestBody.getInstance(), (MessageParameters)new JobMessageParameters(), Collections.singletonMap("jobid", TEST_JOB_ID.toString()), Collections.emptyMap(), Collections.emptyList());
    }

    @Test
    void testResultInProgress() throws Exception {
        TestingRestfulGateway testingRestfulGateway = ((TestingRestfulGateway.Builder)new TestingRestfulGateway.Builder().setRequestJobStatusFunction(jobId -> CompletableFuture.completedFuture(JobStatus.RUNNING))).build();
        JobExecutionResultResponseBody responseBody = (JobExecutionResultResponseBody)this.jobExecutionResultHandler.handleRequest(this.testRequest, (RestfulGateway)testingRestfulGateway).get();
        Assertions.assertThat((Comparable)responseBody.getStatus().getId()).isEqualTo((Object)QueueStatus.Id.IN_PROGRESS);
    }

    @Test
    void testCompletedResult() throws Exception {
        JobStatus jobStatus = JobStatus.FINISHED;
        ArchivedExecutionGraph executionGraph = new ArchivedExecutionGraphBuilder().setJobID(TEST_JOB_ID).setState(jobStatus).build();
        TestingRestfulGateway testingRestfulGateway = ((TestingRestfulGateway.Builder)((TestingRestfulGateway.Builder)new TestingRestfulGateway.Builder().setRequestJobStatusFunction(jobId -> {
            Assertions.assertThat((Comparable)jobId).isEqualTo((Object)TEST_JOB_ID);
            return CompletableFuture.completedFuture(jobStatus);
        })).setRequestJobResultFunction(jobId -> {
            Assertions.assertThat((Comparable)jobId).isEqualTo((Object)TEST_JOB_ID);
            return CompletableFuture.completedFuture(JobResult.createFrom((AccessExecutionGraph)executionGraph));
        })).build();
        JobExecutionResultResponseBody responseBody = (JobExecutionResultResponseBody)this.jobExecutionResultHandler.handleRequest(this.testRequest, (RestfulGateway)testingRestfulGateway).get();
        Assertions.assertThat((Comparable)responseBody.getStatus().getId()).isEqualTo((Object)QueueStatus.Id.COMPLETED);
        Assertions.assertThat((Object)responseBody.getJobExecutionResult()).isNotNull();
    }

    @Test
    void testPropagateFlinkJobNotFoundExceptionAsRestHandlerException() throws Exception {
        TestingRestfulGateway testingRestfulGateway = ((TestingRestfulGateway.Builder)new TestingRestfulGateway.Builder().setRequestJobStatusFunction(jobId -> FutureUtils.completedExceptionally((Throwable)new FlinkJobNotFoundException(jobId)))).build();
        FlinkAssertions.assertThatFuture((CompletableFuture)this.jobExecutionResultHandler.handleRequest(this.testRequest, (RestfulGateway)testingRestfulGateway)).eventuallyFailsWith(ExecutionException.class).withCauseInstanceOf(RestHandlerException.class).satisfies(new ThrowingConsumer[]{e -> {
            AbstractComparableAssert cfr_ignored_0 = (AbstractComparableAssert)Assertions.assertThat((Comparable)((RestHandlerException)e.getCause()).getHttpResponseStatus()).isEqualTo((Object)HttpResponseStatus.NOT_FOUND);
        }});
    }
}

