/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.metrics;

import java.time.Duration;
import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.metrics.util.InterceptingOperatorMetricGroup;
import org.apache.flink.runtime.scheduler.metrics.JobStatusMetrics;
import org.apache.flink.runtime.scheduler.metrics.StateTimeMetric;
import org.apache.flink.runtime.scheduler.metrics.StateTimeMetricTest;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.ManualClock;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class JobStatusMetricsTest {
    JobStatusMetricsTest() {
    }

    @Test
    void testStateMetric() {
        JobStatusMetrics jobStatusMetrics = new JobStatusMetrics(0L, StateTimeMetricTest.enable(MetricOptions.JobStatusMetrics.STATE, MetricOptions.JobStatusMetrics.CURRENT_TIME, MetricOptions.JobStatusMetrics.TOTAL_TIME));
        StateTimeMetric metric = jobStatusMetrics.createTimeMetric(JobStatus.RUNNING);
        Assertions.assertThat((long)metric.getBinary()).isEqualTo(0L);
        jobStatusMetrics.jobStatusChanges(new JobID(), JobStatus.RUNNING, 1L);
        Assertions.assertThat((long)metric.getBinary()).isEqualTo(1L);
        jobStatusMetrics.jobStatusChanges(new JobID(), JobStatus.RESTARTING, 2L);
        Assertions.assertThat((long)metric.getBinary()).isEqualTo(0L);
    }

    @Test
    void testCurrentTimeMetric() {
        ManualClock clock = new ManualClock();
        JobStatusMetrics jobStatusMetrics = new JobStatusMetrics(0L, StateTimeMetricTest.enable(MetricOptions.JobStatusMetrics.STATE, MetricOptions.JobStatusMetrics.CURRENT_TIME, MetricOptions.JobStatusMetrics.TOTAL_TIME), (Clock)clock);
        StateTimeMetric metric = jobStatusMetrics.createTimeMetric(JobStatus.RUNNING);
        Assertions.assertThat((long)metric.getCurrentTime()).isEqualTo(0L);
        jobStatusMetrics.jobStatusChanges(new JobID(), JobStatus.RUNNING, 1L);
        clock.advanceTime(Duration.ofMillis(11L));
        Assertions.assertThat((long)metric.getCurrentTime()).isEqualTo(10L);
        jobStatusMetrics.jobStatusChanges(new JobID(), JobStatus.RESTARTING, 15L);
        Assertions.assertThat((long)metric.getCurrentTime()).isEqualTo(0L);
    }

    @Test
    void testTotalTimeMetric() {
        ManualClock clock = new ManualClock(0L);
        JobStatusMetrics jobStatusMetrics = new JobStatusMetrics(0L, StateTimeMetricTest.enable(MetricOptions.JobStatusMetrics.STATE, MetricOptions.JobStatusMetrics.CURRENT_TIME, MetricOptions.JobStatusMetrics.TOTAL_TIME), (Clock)clock);
        StateTimeMetric metric = jobStatusMetrics.createTimeMetric(JobStatus.RUNNING);
        Assertions.assertThat((long)metric.getTotalTime()).isEqualTo(0L);
        jobStatusMetrics.jobStatusChanges(new JobID(), JobStatus.RUNNING, clock.absoluteTimeMillis());
        clock.advanceTime(Duration.ofMillis(10L));
        Assertions.assertThat((long)metric.getTotalTime()).isEqualTo(10L);
        jobStatusMetrics.jobStatusChanges(new JobID(), JobStatus.RESTARTING, clock.absoluteTimeMillis());
        clock.advanceTime(Duration.ofMillis(4L));
        Assertions.assertThat((long)metric.getTotalTime()).isEqualTo(10L);
        jobStatusMetrics.jobStatusChanges(new JobID(), JobStatus.RUNNING, clock.absoluteTimeMillis());
        clock.advanceTime(Duration.ofMillis(1L));
        Assertions.assertThat((long)metric.getTotalTime()).isEqualTo(11L);
    }

    @Test
    void testStatusSelection() {
        InterceptingOperatorMetricGroup metricGroup = new InterceptingOperatorMetricGroup();
        JobStatusMetrics jobStatusMetrics = new JobStatusMetrics(0L, StateTimeMetricTest.enable(MetricOptions.JobStatusMetrics.STATE));
        jobStatusMetrics.registerMetrics((MetricGroup)metricGroup);
        Map<JobStatus, StateTimeMetricTest.StatusMetricSet> registeredMetrics = StateTimeMetricTest.extractMetrics(metricGroup);
        for (JobStatus value : JobStatus.values()) {
            if (value.isTerminalState() || value == JobStatus.RECONCILING) {
                Assertions.assertThat(registeredMetrics).doesNotContainKey((Object)value);
                continue;
            }
            Assertions.assertThat(registeredMetrics).containsKey((Object)value);
        }
    }
}

