/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.shuffle;

import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.shuffle.PartitionDescriptor;
import org.apache.flink.runtime.shuffle.ProducerDescriptor;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.apache.flink.runtime.shuffle.ShuffleMaster;
import org.apache.flink.util.Preconditions;

public class TestingShuffleMaster
implements ShuffleMaster<ShuffleDescriptor> {
    boolean autoCompleteRegistration = true;
    boolean throwExceptionalOnRegistration = false;
    private final Queue<Tuple2<PartitionDescriptor, ProducerDescriptor>> pendingPartitionRegistrations = new ArrayBlockingQueue<Tuple2<PartitionDescriptor, ProducerDescriptor>>(4);
    private final Queue<CompletableFuture<ShuffleDescriptor>> pendingPartitionRegistrationResponses = new ArrayBlockingQueue<CompletableFuture<ShuffleDescriptor>>(4);
    private final Queue<ShuffleDescriptor> externallyReleasedPartitions = new ArrayBlockingQueue<ShuffleDescriptor>(4);

    public CompletableFuture<ShuffleDescriptor> registerPartitionWithProducer(JobID jobID, PartitionDescriptor partitionDescriptor, ProducerDescriptor producerDescriptor) {
        if (this.throwExceptionalOnRegistration) {
            throw new RuntimeException("Forced partition registration failure");
        }
        if (this.autoCompleteRegistration) {
            return CompletableFuture.completedFuture(this.createShuffleDescriptor(partitionDescriptor, producerDescriptor));
        }
        CompletableFuture<ShuffleDescriptor> response = new CompletableFuture<ShuffleDescriptor>();
        this.pendingPartitionRegistrations.add((Tuple2<PartitionDescriptor, ProducerDescriptor>)new Tuple2((Object)partitionDescriptor, (Object)producerDescriptor));
        this.pendingPartitionRegistrationResponses.add(response);
        return response;
    }

    private ShuffleDescriptor createShuffleDescriptor(PartitionDescriptor partitionDescriptor, ProducerDescriptor producerDescriptor) {
        ResultPartitionID resultPartitionId = new ResultPartitionID(partitionDescriptor.getPartitionId(), producerDescriptor.getProducerExecutionId());
        return new TestingShuffleDescriptor(resultPartitionId, producerDescriptor.getProducerLocation());
    }

    public void releasePartitionExternally(ShuffleDescriptor shuffleDescriptor) {
        this.externallyReleasedPartitions.add(shuffleDescriptor);
    }

    public Queue<ShuffleDescriptor> getExternallyReleasedPartitions() {
        return this.externallyReleasedPartitions;
    }

    public void setAutoCompleteRegistration(boolean autoCompleteRegistration) {
        this.autoCompleteRegistration = autoCompleteRegistration;
    }

    public void setThrowExceptionalOnRegistration(boolean throwExceptionalOnRegistration) {
        this.throwExceptionalOnRegistration = throwExceptionalOnRegistration;
    }

    public void completeAllPendingRegistrations() {
        this.processPendingRegistrations((response, tuple) -> response.complete(this.createShuffleDescriptor((PartitionDescriptor)tuple.f0, (ProducerDescriptor)tuple.f1)));
    }

    public void failAllPendingRegistrations() {
        this.processPendingRegistrations((response, ignore) -> response.completeExceptionally(new Exception("Forced partition registration failure")));
    }

    private void processPendingRegistrations(BiConsumer<CompletableFuture<ShuffleDescriptor>, Tuple2<PartitionDescriptor, ProducerDescriptor>> processor) {
        Tuple2<PartitionDescriptor, ProducerDescriptor> tuple;
        Preconditions.checkState((this.pendingPartitionRegistrationResponses.size() == this.pendingPartitionRegistrations.size() ? 1 : 0) != 0);
        while ((tuple = this.pendingPartitionRegistrations.poll()) != null) {
            processor.accept(this.pendingPartitionRegistrationResponses.poll(), tuple);
        }
    }

    private static class TestingShuffleDescriptor
    implements ShuffleDescriptor {
        private final ResultPartitionID resultPartitionId;
        private final ResourceID location;

        TestingShuffleDescriptor(ResultPartitionID resultPartitionId, ResourceID location) {
            this.resultPartitionId = resultPartitionId;
            this.location = location;
        }

        public ResultPartitionID getResultPartitionID() {
            return this.resultPartitionId;
        }

        public Optional<ResourceID> storesLocalResourcesOn() {
            return Optional.of(this.location);
        }
    }
}

