/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.assertj.core.api.Assertions;

public class TestDuplicateSerializer
extends TypeSerializer<Integer> {
    private static final long serialVersionUID = 1L;
    private static final Integer ZERO = 0;
    private boolean disabled = false;

    public boolean isImmutableType() {
        return true;
    }

    public TypeSerializer<Integer> duplicate() {
        return new TestDuplicateSerializer();
    }

    public Integer createInstance() {
        return ZERO;
    }

    public Integer copy(Integer from) {
        return from;
    }

    public Integer copy(Integer from, Integer reuse) {
        return from;
    }

    public int getLength() {
        return 4;
    }

    public void serialize(Integer record, DataOutputView target) throws IOException {
        Assertions.assertThat((boolean)this.disabled).isFalse();
        target.writeInt(record.intValue());
    }

    public Integer deserialize(DataInputView source) throws IOException {
        Assertions.assertThat((boolean)this.disabled).isFalse();
        return source.readInt();
    }

    public Integer deserialize(Integer reuse, DataInputView source) throws IOException {
        Assertions.assertThat((boolean)this.disabled).isFalse();
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        Assertions.assertThat((boolean)this.disabled).isFalse();
        target.writeInt(source.readInt());
    }

    public boolean equals(Object obj) {
        return obj instanceof TestDuplicateSerializer;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }

    public void disable() {
        this.disabled = true;
    }

    public TypeSerializerSnapshot<Integer> snapshotConfiguration() {
        throw new UnsupportedOperationException();
    }
}

