/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.core.testutils.CheckedThread;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.CompositeBuffer;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.runtime.io.network.partition.BufferReaderWriterUtil;
import org.apache.flink.runtime.io.network.partition.BufferWithSubpartition;
import org.apache.flink.runtime.io.network.partition.DataBufferTest;
import org.apache.flink.runtime.io.network.partition.PartitionedFile;
import org.apache.flink.runtime.io.network.partition.PartitionedFileReader;
import org.apache.flink.runtime.io.network.partition.PartitionedFileWriter;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class PartitionedFileWriteReadTest {
    @TempDir
    private Path tempPath;

    PartitionedFileWriteReadTest() {
    }

    @Test
    void testWriteAndReadPartitionedFile() throws Exception {
        int subpartition;
        int numSubpartitions = 10;
        int bufferSize = 1024;
        int numBuffers = 1000;
        int numRegions = 10;
        List[] buffersWritten = new List[numSubpartitions];
        List[] buffersRead = new List[numSubpartitions];
        List[] regionStat = new List[numSubpartitions];
        for (int subpartition2 = 0; subpartition2 < numSubpartitions; ++subpartition2) {
            buffersWritten[subpartition2] = new ArrayList();
            buffersRead[subpartition2] = new ArrayList();
            regionStat[subpartition2] = new ArrayList();
        }
        PartitionedFile partitionedFile = this.createPartitionedFile(numSubpartitions, bufferSize, numBuffers, numRegions, buffersWritten, regionStat, this.createPartitionedFileWriter(numSubpartitions));
        FileChannel dataFileChannel = this.openFileChannel(partitionedFile.getDataFilePath());
        FileChannel indexFileChannel = this.openFileChannel(partitionedFile.getIndexFilePath());
        for (subpartition = 0; subpartition < numSubpartitions; ++subpartition) {
            PartitionedFileReader fileReader = new PartitionedFileReader(partitionedFile, subpartition, dataFileChannel, indexFileChannel, BufferReaderWriterUtil.allocatedHeaderBuffer(), PartitionedFileWriteReadTest.createAndConfigIndexEntryBuffer());
            while (fileReader.hasRemaining()) {
                int subIndex = subpartition;
                fileReader.readCurrentRegion(PartitionedFileWriteReadTest.allocateBuffers(bufferSize), FreeingBufferRecycler.INSTANCE, buffer -> this.addReadBuffer((Buffer)buffer, buffersRead[subIndex]));
            }
        }
        IOUtils.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{dataFileChannel, indexFileChannel});
        for (subpartition = 0; subpartition < numSubpartitions; ++subpartition) {
            Assertions.assertThat((List)buffersWritten[subpartition]).hasSameSizeAs((Iterable)buffersRead[subpartition]);
            for (int i = 0; i < buffersWritten[subpartition].size(); ++i) {
                this.assertBufferEquals((Buffer)buffersWritten[subpartition].get(i), (Buffer)buffersRead[subpartition].get(i));
            }
        }
    }

    private PartitionedFile createPartitionedFile(int numSubpartitions, int bufferSize, int numBuffers, int numRegions, List<Buffer>[] buffersWritten, List<Tuple2<Long, Long>>[] regionStat, PartitionedFileWriter fileWriter) throws IOException {
        Random random = new Random(1111L);
        long currentOffset = 0L;
        block0: for (int region = 0; region < numRegions; ++region) {
            int subpartition;
            int i;
            boolean isBroadcastRegion = random.nextBoolean();
            fileWriter.startNewRegion(isBroadcastRegion);
            List[] bufferWithSubpartitions = new List[numSubpartitions];
            for (i = 0; i < numSubpartitions; ++i) {
                bufferWithSubpartitions[i] = new ArrayList();
            }
            for (i = 0; i < numBuffers; ++i) {
                Buffer buffer = this.createBuffer(random, bufferSize);
                if (isBroadcastRegion) {
                    for (subpartition = 0; subpartition < numSubpartitions; ++subpartition) {
                        buffersWritten[subpartition].add(buffer);
                        bufferWithSubpartitions[subpartition].add(new BufferWithSubpartition(buffer, subpartition));
                    }
                    continue;
                }
                subpartition = random.nextInt(numSubpartitions);
                buffersWritten[subpartition].add(buffer);
                bufferWithSubpartitions[subpartition].add(new BufferWithSubpartition(buffer, subpartition));
            }
            int[] writeOrder = DataBufferTest.getRandomSubpartitionOrder(numSubpartitions);
            for (int index = 0; index < numSubpartitions; ++index) {
                subpartition = writeOrder[index];
                fileWriter.writeBuffers(bufferWithSubpartitions[subpartition]);
                long totalBytes = PartitionedFileWriteReadTest.getTotalBytes(bufferWithSubpartitions[subpartition]);
                if (isBroadcastRegion) {
                    for (int j = 0; j < numSubpartitions; ++j) {
                        regionStat[j].add((Tuple2<Long, Long>)Tuple2.of((Object)currentOffset, (Object)totalBytes));
                    }
                    currentOffset += totalBytes;
                    continue block0;
                }
                regionStat[subpartition].add((Tuple2<Long, Long>)Tuple2.of((Object)currentOffset, (Object)totalBytes));
                currentOffset += totalBytes;
            }
        }
        return fileWriter.finish();
    }

    private static long getTotalBytes(List<BufferWithSubpartition> bufferWithSubpartitions) {
        long totalBytes = 0L;
        for (BufferWithSubpartition bufferWithSubpartition : bufferWithSubpartitions) {
            totalBytes += (long)(bufferWithSubpartition.getBuffer().readableBytes() + 8);
        }
        return totalBytes;
    }

    private void addReadBuffer(Buffer buffer, List<Buffer> buffersRead) {
        int numBytes = buffer.readableBytes();
        MemorySegment segment = MemorySegmentFactory.allocateUnpooledSegment((int)numBytes);
        Buffer fullBuffer = ((CompositeBuffer)buffer).getFullBufferData(MemorySegmentFactory.allocateUnpooledSegment((int)numBytes));
        segment.put(0, fullBuffer.getNioBufferReadable(), fullBuffer.readableBytes());
        buffersRead.add((Buffer)new NetworkBuffer(segment, ignore -> {}, fullBuffer.getDataType(), fullBuffer.isCompressed(), fullBuffer.readableBytes()));
        fullBuffer.recycleBuffer();
    }

    private static Queue<MemorySegment> allocateBuffers(int bufferSize) {
        int numBuffers = 2;
        LinkedList<MemorySegment> readBuffers = new LinkedList<MemorySegment>();
        while (numBuffers-- > 0) {
            readBuffers.add(MemorySegmentFactory.allocateUnpooledSegment((int)bufferSize));
        }
        return readBuffers;
    }

    @Test
    void testWriteAndReadWithEmptySubpartition() throws Exception {
        int numRegions = 10;
        int numSubpartitions = 5;
        int bufferSize = 1024;
        Random random = new Random(1111L);
        ArrayDeque[] subpartitionBuffers = new ArrayDeque[numSubpartitions];
        List[] buffersRead = new List[numSubpartitions];
        for (int subpartition = 0; subpartition < numSubpartitions; ++subpartition) {
            subpartitionBuffers[subpartition] = new ArrayDeque();
            buffersRead[subpartition] = new ArrayList();
        }
        PartitionedFileWriter fileWriter = this.createPartitionedFileWriter(numSubpartitions);
        for (int region = 0; region < numRegions; ++region) {
            fileWriter.startNewRegion(false);
            for (int subpartition = 0; subpartition < numSubpartitions; ++subpartition) {
                if (!random.nextBoolean()) continue;
                Buffer buffer2 = this.createBuffer(random, bufferSize);
                subpartitionBuffers[subpartition].add(buffer2);
                fileWriter.writeBuffers(this.getBufferWithSubpartitions(buffer2, subpartition));
            }
        }
        PartitionedFile partitionedFile = fileWriter.finish();
        FileChannel dataFileChannel = this.openFileChannel(partitionedFile.getDataFilePath());
        FileChannel indexFileChannel = this.openFileChannel(partitionedFile.getIndexFilePath());
        for (int subpartition = 0; subpartition < numSubpartitions; ++subpartition) {
            PartitionedFileReader fileReader = new PartitionedFileReader(partitionedFile, subpartition, dataFileChannel, indexFileChannel, BufferReaderWriterUtil.allocatedHeaderBuffer(), PartitionedFileWriteReadTest.createAndConfigIndexEntryBuffer());
            int bufferIndex = 0;
            while (fileReader.hasRemaining()) {
                int subIndex = subpartition;
                fileReader.readCurrentRegion(PartitionedFileWriteReadTest.allocateBuffers(bufferSize), FreeingBufferRecycler.INSTANCE, buffer -> this.addReadBuffer((Buffer)buffer, buffersRead[subIndex]));
                Buffer buffer3 = (Buffer)buffersRead[subIndex].get(bufferIndex++);
                this.assertBufferEquals((Buffer)Preconditions.checkNotNull((Object)((Buffer)subpartitionBuffers[subpartition].poll())), buffer3);
            }
            Assertions.assertThat((Collection)subpartitionBuffers[subpartition]).isEmpty();
        }
        IOUtils.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{dataFileChannel, indexFileChannel});
    }

    private void assertBufferEquals(Buffer expected, Buffer actual) {
        Assertions.assertThat((Comparable)expected.getDataType()).isEqualTo((Object)actual.getDataType());
        Assertions.assertThat((Comparable)expected.getNioBufferReadable()).isEqualTo((Object)actual.getNioBufferReadable());
    }

    private Buffer createBuffer(Random random, int bufferSize) {
        boolean isBuffer = random.nextBoolean();
        Buffer.DataType dataType = isBuffer ? Buffer.DataType.DATA_BUFFER : Buffer.DataType.EVENT_BUFFER;
        int dataSize = random.nextInt(bufferSize) + 1;
        byte[] data = new byte[dataSize];
        return new NetworkBuffer(MemorySegmentFactory.wrap((byte[])data), buf -> {}, dataType, dataSize);
    }

    @Test
    void testNotWriteDataOfTheSameSubpartitionTogether() throws Exception {
        PartitionedFileWriter partitionedFileWriter = this.createPartitionedFileWriter(2);
        try {
            MemorySegment segment = MemorySegmentFactory.allocateUnpooledSegment((int)1024);
            Assertions.assertThatThrownBy(() -> {
                NetworkBuffer buffer1 = new NetworkBuffer(segment, buf -> {});
                partitionedFileWriter.writeBuffers(this.getBufferWithSubpartitions((Buffer)buffer1, 1));
                NetworkBuffer buffer2 = new NetworkBuffer(segment, buf -> {});
                partitionedFileWriter.writeBuffers(this.getBufferWithSubpartitions((Buffer)buffer2, 0));
                NetworkBuffer buffer3 = new NetworkBuffer(segment, buf -> {});
                partitionedFileWriter.writeBuffers(this.getBufferWithSubpartitions((Buffer)buffer3, 1));
            }).isInstanceOf(IllegalStateException.class);
        }
        finally {
            partitionedFileWriter.finish();
        }
    }

    @Test
    void testWriteFinishedPartitionedFile() throws Exception {
        PartitionedFileWriter partitionedFileWriter = this.createAndFinishPartitionedFileWriter();
        MemorySegment segment = MemorySegmentFactory.allocateUnpooledSegment((int)1024);
        NetworkBuffer buffer = new NetworkBuffer(segment, buf -> {});
        Assertions.assertThatThrownBy(() -> partitionedFileWriter.writeBuffers(this.getBufferWithSubpartitions((Buffer)buffer, 0))).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void testFinishPartitionedFileWriterTwice() throws Exception {
        PartitionedFileWriter partitionedFileWriter = this.createAndFinishPartitionedFileWriter();
        Assertions.assertThatThrownBy(() -> partitionedFileWriter.finish()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void testReadEmptyPartitionedFile() throws Exception {
        int bufferSize = 1024;
        int numSubpartitions = 2;
        int targetSubpartition = 1;
        PartitionedFile partitionedFile = this.createEmptyPartitionedFile();
        List[] buffersRead = new List[numSubpartitions];
        for (int subpartition = 0; subpartition < numSubpartitions; ++subpartition) {
            buffersRead[subpartition] = new ArrayList();
        }
        FileChannel dataFileChannel = this.openFileChannel(partitionedFile.getDataFilePath());
        FileChannel indexFileChannel = this.openFileChannel(partitionedFile.getIndexFilePath());
        PartitionedFileReader partitionedFileReader = new PartitionedFileReader(partitionedFile, 1, dataFileChannel, indexFileChannel, BufferReaderWriterUtil.allocatedHeaderBuffer(), PartitionedFileWriteReadTest.createAndConfigIndexEntryBuffer());
        partitionedFileReader.readCurrentRegion(PartitionedFileWriteReadTest.allocateBuffers(bufferSize), FreeingBufferRecycler.INSTANCE, buffer -> this.addReadBuffer((Buffer)buffer, buffersRead[targetSubpartition]));
        Assertions.assertThat((List)buffersRead[targetSubpartition]).isEmpty();
        IOUtils.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{dataFileChannel, indexFileChannel});
    }

    @Test
    void testMultipleThreadGetIndexEntry() throws Exception {
        int numSubpartitions = 5;
        int bufferSize = 1024;
        int numBuffers = 100;
        int numRegions = 10;
        List[] buffersWritten = new List[5];
        List[] buffersRead = new List[5];
        final List[] regionStat = new List[5];
        for (int subpartition = 0; subpartition < 5; ++subpartition) {
            buffersWritten[subpartition] = new ArrayList();
            buffersRead[subpartition] = new ArrayList();
            regionStat[subpartition] = new ArrayList();
        }
        final PartitionedFile partitionedFile = this.createPartitionedFile(5, 1024, 100, 10, buffersWritten, regionStat, this.createPartitionedFileWriter(5, 80, 80));
        FileChannel dataFileChannel = this.openFileChannel(partitionedFile.getDataFilePath());
        final FileChannel indexFileChannel = this.openFileChannel(partitionedFile.getIndexFilePath());
        CheckedThread[] readers = new CheckedThread[5];
        for (int i = 0; i < 5; ++i) {
            final int subpartition = i;
            readers[i] = new CheckedThread(){

                public void go() throws Exception {
                    ByteBuffer indexEntryBuffer = PartitionedFileWriteReadTest.createAndConfigIndexEntryBuffer();
                    for (int region = 0; region < 10; ++region) {
                        partitionedFile.getIndexEntry(indexFileChannel, indexEntryBuffer, region, subpartition);
                        long offset = indexEntryBuffer.getLong();
                        long regionBytes = indexEntryBuffer.getLong();
                        Assertions.assertThat((long)offset).isEqualTo(((Tuple2)regionStat[subpartition].get((int)region)).f0);
                        Assertions.assertThat((long)regionBytes).isEqualTo(((Tuple2)regionStat[subpartition].get((int)region)).f1);
                    }
                }
            };
        }
        for (CheckedThread reader : readers) {
            reader.start();
        }
        for (CheckedThread reader : readers) {
            reader.sync();
        }
        IOUtils.closeAllQuietly((AutoCloseable[])new AutoCloseable[]{dataFileChannel, indexFileChannel});
    }

    private FileChannel openFileChannel(Path path) throws IOException {
        return FileChannel.open(path, StandardOpenOption.READ);
    }

    private List<BufferWithSubpartition> getBufferWithSubpartitions(Buffer buffer, int subpartitionIndex) {
        return Collections.singletonList(new BufferWithSubpartition(buffer, subpartitionIndex));
    }

    private PartitionedFile createEmptyPartitionedFile() throws IOException {
        PartitionedFileWriter partitionedFileWriter = this.createPartitionedFileWriter(2);
        return partitionedFileWriter.finish();
    }

    private PartitionedFileWriter createPartitionedFileWriter(int numSubpartitions) throws IOException {
        return this.createPartitionedFileWriter(numSubpartitions, 640);
    }

    private PartitionedFileWriter createPartitionedFileWriter(int numSubpartitions, int minIndexBufferSize, int maxIndexBufferSize) throws IOException {
        return new PartitionedFileWriter(numSubpartitions, minIndexBufferSize, maxIndexBufferSize, this.tempPath.toString());
    }

    private PartitionedFileWriter createPartitionedFileWriter(int numSubpartitions, int maxIndexBufferSize) throws IOException {
        return new PartitionedFileWriter(numSubpartitions, maxIndexBufferSize, this.tempPath.toString());
    }

    private PartitionedFileWriter createAndFinishPartitionedFileWriter() throws IOException {
        PartitionedFileWriter partitionedFileWriter = this.createPartitionedFileWriter(1);
        partitionedFileWriter.finish();
        return partitionedFileWriter;
    }

    public static ByteBuffer createAndConfigIndexEntryBuffer() {
        ByteBuffer indexEntryBuffer = ByteBuffer.allocateDirect(16);
        BufferReaderWriterUtil.configureByteBuffer((ByteBuffer)indexEntryBuffer);
        return indexEntryBuffer;
    }
}

