/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph.topology;

import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.IntermediateDataSet;
import org.apache.flink.runtime.jobgraph.JobEdge;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobGraphTestUtils;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.topology.DefaultLogicalResultTest;
import org.apache.flink.runtime.jobgraph.topology.DefaultLogicalTopology;
import org.apache.flink.runtime.jobgraph.topology.DefaultLogicalVertex;
import org.apache.flink.runtime.jobgraph.topology.DefaultLogicalVertexTest;
import org.apache.flink.shaded.guava32.com.google.common.collect.Iterables;
import org.apache.flink.util.IterableUtils;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultLogicalTopologyTest
extends TestLogger {
    private JobGraph jobGraph;
    private DefaultLogicalTopology logicalTopology;

    @Before
    public void setUp() throws Exception {
        this.jobGraph = this.createJobGraph();
        this.logicalTopology = DefaultLogicalTopology.fromJobGraph((JobGraph)this.jobGraph);
    }

    @Test
    public void testGetVertices() {
        List jobVertices = this.jobGraph.getVerticesSortedTopologicallyFromSources();
        Iterable logicalVertices = this.logicalTopology.getVertices();
        Assert.assertEquals((long)Iterables.size((Iterable)jobVertices), (long)Iterables.size((Iterable)logicalVertices));
        Iterator jobVertexIterator = jobVertices.iterator();
        Iterator logicalVertexIterator = logicalVertices.iterator();
        while (jobVertexIterator.hasNext()) {
            DefaultLogicalTopologyTest.assertVertexAndConnectedResultsEquals((JobVertex)jobVertexIterator.next(), (DefaultLogicalVertex)logicalVertexIterator.next());
        }
    }

    @Test
    public void testGetLogicalPipelinedRegions() {
        Assert.assertEquals((long)2L, (long)IterableUtils.toStream((Iterable)this.logicalTopology.getAllPipelinedRegions()).count());
    }

    private JobGraph createJobGraph() {
        JobVertex[] jobVertices = new JobVertex[3];
        int parallelism = 3;
        jobVertices[0] = ExecutionGraphTestUtils.createNoOpVertex("v1", 3);
        jobVertices[1] = ExecutionGraphTestUtils.createNoOpVertex("v2", 3);
        jobVertices[2] = ExecutionGraphTestUtils.createNoOpVertex("v3", 3);
        jobVertices[1].connectNewDataSetAsInput(jobVertices[0], DistributionPattern.ALL_TO_ALL, ResultPartitionType.PIPELINED);
        jobVertices[2].connectNewDataSetAsInput(jobVertices[1], DistributionPattern.ALL_TO_ALL, ResultPartitionType.BLOCKING);
        return JobGraphTestUtils.streamingJobGraph(jobVertices);
    }

    private static void assertVertexAndConnectedResultsEquals(JobVertex jobVertex, DefaultLogicalVertex logicalVertex) {
        DefaultLogicalVertexTest.assertVertexInfoEquals(jobVertex, logicalVertex);
        List<IntermediateDataSet> consumedResults = jobVertex.getInputs().stream().map(JobEdge::getSource).collect(Collectors.toList());
        DefaultLogicalResultTest.assertResultsEquals(consumedResults, logicalVertex.getConsumedResults());
        List producedResults = jobVertex.getProducedDataSets();
        DefaultLogicalResultTest.assertResultsEquals(producedResults, logicalVertex.getProducedResults());
    }
}

