/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.core.failure.FailureEnricher;
import org.apache.flink.core.testutils.AllCallbackWrapper;
import org.apache.flink.core.testutils.CustomExtension;
import org.apache.flink.runtime.blob.BlobWriter;
import org.apache.flink.runtime.blocklist.BlocklistOperations;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.executiongraph.JobStatusListener;
import org.apache.flink.runtime.io.network.partition.JobMasterPartitionTracker;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobGraphTestUtils;
import org.apache.flink.runtime.jobmaster.DefaultSlotPoolServiceSchedulerFactory;
import org.apache.flink.runtime.jobmaster.ExecutionDeploymentTracker;
import org.apache.flink.runtime.jobmaster.JobManagerSharedServices;
import org.apache.flink.runtime.jobmaster.JobMaster;
import org.apache.flink.runtime.jobmaster.JobMasterException;
import org.apache.flink.runtime.jobmaster.SlotPoolServiceSchedulerFactory;
import org.apache.flink.runtime.jobmaster.TestingJobManagerSharedServicesBuilder;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPoolService;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPoolServiceFactory;
import org.apache.flink.runtime.jobmaster.slotpool.TestingSlotPoolServiceBuilder;
import org.apache.flink.runtime.jobmaster.utils.JobMasterBuilder;
import org.apache.flink.runtime.metrics.groups.JobManagerJobMetricGroup;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.TestingRpcServiceExtension;
import org.apache.flink.runtime.scheduler.SchedulerNG;
import org.apache.flink.runtime.scheduler.SchedulerNGFactory;
import org.apache.flink.runtime.scheduler.TestingSchedulerNG;
import org.apache.flink.runtime.shuffle.ShuffleMaster;
import org.apache.flink.util.FlinkRuntimeException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.slf4j.Logger;

class JobMasterSchedulerTest {
    private static final TestingRpcServiceExtension TESTING_RPC_SERVICE_EXTENSION = new TestingRpcServiceExtension();
    @RegisterExtension
    private static final AllCallbackWrapper<TestingRpcServiceExtension> RPC_SERVICE_EXTENSION_WRAPPER = new AllCallbackWrapper((CustomExtension)TESTING_RPC_SERVICE_EXTENSION);

    JobMasterSchedulerTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testIfStartSchedulingFailsJobMasterFails() throws Exception {
        FailingSchedulerFactory schedulerFactory = new FailingSchedulerFactory();
        JobMasterBuilder.TestingOnCompletionActions onCompletionActions = new JobMasterBuilder.TestingOnCompletionActions();
        JobManagerSharedServices jobManagerSharedServices = new TestingJobManagerSharedServicesBuilder().build();
        try {
            JobMaster jobMaster = new JobMasterBuilder(JobGraphTestUtils.emptyJobGraph(), TESTING_RPC_SERVICE_EXTENSION.getTestingRpcService()).withSlotPoolServiceSchedulerFactory((SlotPoolServiceSchedulerFactory)DefaultSlotPoolServiceSchedulerFactory.create((SlotPoolServiceFactory)TestingSlotPoolServiceBuilder.newBuilder(), (SchedulerNGFactory)schedulerFactory)).withOnCompletionActions(onCompletionActions).withJobManagerSharedServices(jobManagerSharedServices).createJobMaster();
            jobMaster.start();
            Assertions.assertThat((Throwable)onCompletionActions.getJobMasterFailedFuture().join()).isInstanceOf(JobMasterException.class);
            try {
                jobMaster.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            jobManagerSharedServices.shutdown();
        }
    }

    private static final class FailingSchedulerFactory
    implements SchedulerNGFactory {
        private FailingSchedulerFactory() {
        }

        public SchedulerNG createInstance(Logger log, JobGraph jobGraph, Executor ioExecutor, Configuration jobMasterConfiguration, SlotPoolService slotPoolService, ScheduledExecutorService futureExecutor, ClassLoader userCodeLoader, CheckpointRecoveryFactory checkpointRecoveryFactory, Duration rpcTimeout, BlobWriter blobWriter, JobManagerJobMetricGroup jobManagerJobMetricGroup, Duration slotRequestTimeout, ShuffleMaster<?> shuffleMaster, JobMasterPartitionTracker partitionTracker, ExecutionDeploymentTracker executionDeploymentTracker, long initializationTimestamp, ComponentMainThreadExecutor mainThreadExecutor, FatalErrorHandler fatalErrorHandler, JobStatusListener jobStatusListener, Collection<FailureEnricher> failureEnrichers, BlocklistOperations blocklistOperations) {
            return TestingSchedulerNG.newBuilder().setStartSchedulingRunnable(() -> {
                throw new FlinkRuntimeException("Could not start scheduling.");
            }).build();
        }

        public JobManagerOptions.SchedulerType getSchedulerType() {
            return JobManagerOptions.SchedulerType.Default;
        }
    }
}

