/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import java.util.Optional;
import org.apache.flink.runtime.rest.messages.job.savepoints.SavepointTriggerRequestBody;
import org.apache.flink.runtime.rest.messages.job.savepoints.stop.StopWithSavepointRequestBody;
import org.apache.flink.runtime.rest.util.RestMapperUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class SavepointHandlerRequestBodyTest {
    @Test
    void testSavepointRequestCanBeParsedFromEmptyObject() throws JsonProcessingException {
        SavepointTriggerRequestBody defaultParseResult = SavepointHandlerRequestBodyTest.getDefaultParseResult(SavepointTriggerRequestBody.class);
        Assertions.assertThat((boolean)defaultParseResult.isCancelJob()).isFalse();
        Assertions.assertThat((Optional)defaultParseResult.getTargetDirectory()).isNotPresent();
    }

    @Test
    void testStopWithSavepointRequestCanBeParsedFromEmptyObject() throws JsonProcessingException {
        StopWithSavepointRequestBody defaultParseResult = SavepointHandlerRequestBodyTest.getDefaultParseResult(StopWithSavepointRequestBody.class);
        Assertions.assertThat((boolean)defaultParseResult.shouldDrain()).isFalse();
        Assertions.assertThat((Optional)defaultParseResult.getTargetDirectory()).isNotPresent();
    }

    private static <T> T getDefaultParseResult(Class<T> clazz) throws JsonProcessingException {
        ObjectMapper mapper = RestMapperUtils.getStrictObjectMapper();
        return (T)mapper.readValue("{}", clazz);
    }
}

