/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.core.testutils.CompletedScheduledFuture;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.failure.FailureEnricherUtils;
import org.apache.flink.runtime.scheduler.ExecutionGraphHandler;
import org.apache.flink.runtime.scheduler.OperatorCoordinatorHandler;
import org.apache.flink.runtime.scheduler.adaptive.ExecutingTest;
import org.apache.flink.runtime.scheduler.adaptive.MockStateWithExecutionGraphContext;
import org.apache.flink.runtime.scheduler.adaptive.Restarting;
import org.apache.flink.runtime.scheduler.adaptive.State;
import org.apache.flink.runtime.scheduler.adaptive.StateTrackingMockExecutionGraph;
import org.apache.flink.runtime.scheduler.adaptive.StateValidator;
import org.apache.flink.runtime.scheduler.adaptive.TestingOperatorCoordinatorHandler;
import org.apache.flink.runtime.scheduler.adaptive.WaitingForResourcesTest;
import org.apache.flink.runtime.scheduler.exceptionhistory.ExceptionHistoryEntry;
import org.apache.flink.runtime.scheduler.exceptionhistory.RootExceptionHistoryEntry;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RestartingTest {
    private static final Logger log = LoggerFactory.getLogger(RestartingTest.class);

    RestartingTest() {
    }

    @Test
    void testExecutionGraphCancellationOnEnter() throws Exception {
        try (MockRestartingContext ctx = new MockRestartingContext();){
            StateTrackingMockExecutionGraph mockExecutionGraph = new StateTrackingMockExecutionGraph();
            this.createRestartingState(ctx, mockExecutionGraph);
            Assertions.assertThat((Comparable)mockExecutionGraph.getState()).isEqualTo((Object)JobStatus.CANCELLING);
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testTransitionToSubsequentStateWhenCancellationComplete(boolean forcedRestart) throws Exception {
        try (MockRestartingContext ctx = new MockRestartingContext();){
            Restarting restarting = this.createRestartingState(ctx, forcedRestart);
            if (forcedRestart) {
                ctx.setExpectCreatingExecutionGraph();
            } else {
                ctx.setExpectWaitingForResources();
            }
            restarting.onGloballyTerminalState(JobStatus.CANCELED);
        }
    }

    @Test
    void testCancel() throws Exception {
        try (MockRestartingContext ctx = new MockRestartingContext();){
            Restarting restarting = this.createRestartingState(ctx);
            ctx.setExpectCancelling(WaitingForResourcesTest.assertNonNull());
            restarting.cancel();
        }
    }

    @Test
    void testSuspendWithJobInCancellingState() throws Exception {
        this.testSuspend(false);
    }

    @Test
    void testSuspendWithJobInCancelledState() throws Exception {
        this.testSuspend(true);
    }

    private void testSuspend(boolean cancellationCompleted) throws Exception {
        try (MockRestartingContext ctx = new MockRestartingContext();){
            StateTrackingMockExecutionGraph executionGraph = new StateTrackingMockExecutionGraph();
            Restarting restarting = this.createRestartingState(ctx, executionGraph);
            if (cancellationCompleted) {
                executionGraph.completeTerminationFuture(JobStatus.CANCELED);
            }
            ctx.setExpectFinished(archivedExecutionGraph -> Assertions.assertThat((Comparable)archivedExecutionGraph.getState()).isEqualTo((Object)JobStatus.SUSPENDED));
            RuntimeException cause = new RuntimeException("suspend");
            restarting.suspend((Throwable)cause);
        }
    }

    @Test
    void testGlobalFailuresAreIgnored() throws Exception {
        try (MockRestartingContext ctx = new MockRestartingContext();){
            Restarting restarting = this.createRestartingState(ctx);
            restarting.handleGlobalFailure((Throwable)new RuntimeException(), FailureEnricherUtils.EMPTY_FAILURE_LABELS);
            ctx.assertNoStateTransition();
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testStateDoesNotExposeGloballyTerminalExecutionGraph(boolean forcedRestart) throws Exception {
        try (MockRestartingContext ctx = new MockRestartingContext();){
            StateTrackingMockExecutionGraph mockExecutionGraph = new StateTrackingMockExecutionGraph();
            Restarting restarting = this.createRestartingState(ctx, mockExecutionGraph, forcedRestart);
            if (forcedRestart) {
                ctx.setExpectCreatingExecutionGraph();
            } else {
                ctx.setExpectWaitingForResources();
            }
            mockExecutionGraph.completeTerminationFuture(JobStatus.CANCELED);
            Assertions.assertThat((Comparable)restarting.getExecutionGraph().getState()).isEqualTo((Object)JobStatus.CANCELED);
            Assertions.assertThat((Comparable)restarting.getJobStatus()).isEqualTo((Object)JobStatus.RESTARTING);
            Assertions.assertThat((Comparable)restarting.getJob().getState()).isEqualTo((Object)JobStatus.RESTARTING);
            Assertions.assertThat((long)restarting.getJob().getStatusTimestamp(JobStatus.CANCELED)).isZero();
        }
    }

    public Restarting createRestartingState(MockRestartingContext ctx, boolean forcedRestart) {
        return this.createRestartingState(ctx, new StateTrackingMockExecutionGraph(), forcedRestart);
    }

    public Restarting createRestartingState(MockRestartingContext ctx, ExecutionGraph executionGraph) {
        return this.createRestartingState(ctx, executionGraph, false);
    }

    public Restarting createRestartingState(MockRestartingContext ctx, ExecutionGraph executionGraph, boolean forcedRestart) {
        ExecutionGraphHandler executionGraphHandler = new ExecutionGraphHandler(executionGraph, log, (Executor)ctx.getMainThreadExecutor(), ctx.getMainThreadExecutor());
        TestingOperatorCoordinatorHandler operatorCoordinatorHandler = new TestingOperatorCoordinatorHandler();
        executionGraph.transitionToRunning();
        return new Restarting((Restarting.Context)ctx, executionGraph, executionGraphHandler, (OperatorCoordinatorHandler)operatorCoordinatorHandler, log, Duration.ZERO, forcedRestart, ClassLoader.getSystemClassLoader(), new ArrayList());
    }

    public Restarting createRestartingState(MockRestartingContext ctx) {
        return this.createRestartingState(ctx, new StateTrackingMockExecutionGraph());
    }

    private static class MockRestartingContext
    extends MockStateWithExecutionGraphContext
    implements Restarting.Context {
        private final StateValidator<ExecutingTest.CancellingArguments> cancellingStateValidator = new StateValidator("Cancelling");
        private final StateValidator<ExecutionGraph> waitingForResourcesStateValidator = new StateValidator("WaitingForResources");
        private final StateValidator<ExecutionGraph> creatingExecutionGraphStateValidator = new StateValidator("CreatingExecutionGraph");

        private MockRestartingContext() {
        }

        public void setExpectCancelling(Consumer<ExecutingTest.CancellingArguments> asserter) {
            this.cancellingStateValidator.expectInput(asserter);
        }

        public void setExpectWaitingForResources() {
            this.waitingForResourcesStateValidator.expectInput(WaitingForResourcesTest.assertNonNull());
        }

        public void setExpectCreatingExecutionGraph() {
            this.creatingExecutionGraphStateValidator.expectInput(WaitingForResourcesTest.assertNonNull());
        }

        public void goToCanceling(ExecutionGraph executionGraph, ExecutionGraphHandler executionGraphHandler, OperatorCoordinatorHandler operatorCoordinatorHandler, List<ExceptionHistoryEntry> failureCollection) {
            this.cancellingStateValidator.validateInput(new ExecutingTest.CancellingArguments(executionGraph, executionGraphHandler, operatorCoordinatorHandler));
            this.hadStateTransition = true;
        }

        @Override
        public void archiveFailure(RootExceptionHistoryEntry failure) {
        }

        public void goToWaitingForResources(@Nullable ExecutionGraph previousExecutionGraph) {
            this.waitingForResourcesStateValidator.validateInput(previousExecutionGraph);
            this.hadStateTransition = true;
        }

        public void goToCreatingExecutionGraph(@Nullable ExecutionGraph previousExecutionGraph) {
            this.creatingExecutionGraphStateValidator.validateInput(previousExecutionGraph);
            this.hadStateTransition = true;
        }

        public ScheduledFuture<?> runIfState(State expectedState, Runnable action, Duration delay) {
            if (!this.hadStateTransition) {
                action.run();
            }
            return CompletedScheduledFuture.create(null);
        }

        @Override
        public void close() throws Exception {
            super.close();
            this.cancellingStateValidator.close();
            this.waitingForResourcesStateValidator.close();
            this.creatingExecutionGraphStateValidator.close();
        }
    }
}

