/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.strategy;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.scheduler.strategy.PartialFinishedInputConsumableDecider;
import org.apache.flink.runtime.scheduler.strategy.ResultPartitionState;
import org.apache.flink.runtime.scheduler.strategy.SchedulingExecutionVertex;
import org.apache.flink.runtime.scheduler.strategy.TestingSchedulingExecutionVertex;
import org.apache.flink.runtime.scheduler.strategy.TestingSchedulingTopology;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class PartialFinishedInputConsumableDeciderTest {
    PartialFinishedInputConsumableDeciderTest() {
    }

    @Test
    void testNotFinishedBlockingInput() {
        TestingSchedulingTopology topology = new TestingSchedulingTopology();
        List<TestingSchedulingExecutionVertex> producers = topology.addExecutionVertices().withParallelism(2).finish();
        List<TestingSchedulingExecutionVertex> consumer = topology.addExecutionVertices().withParallelism(2).finish();
        topology.connectAllToAll(producers, consumer).withResultPartitionState(ResultPartitionState.CREATED).withResultPartitionType(ResultPartitionType.BLOCKING).finish();
        PartialFinishedInputConsumableDecider inputConsumableDecider = PartialFinishedInputConsumableDeciderTest.createPartialFinishedInputConsumableDecider();
        Assertions.assertThat((boolean)inputConsumableDecider.isInputConsumable((SchedulingExecutionVertex)consumer.get(0), Collections.emptySet(), new HashMap())).isFalse();
        Assertions.assertThat((boolean)inputConsumableDecider.isInputConsumable((SchedulingExecutionVertex)consumer.get(1), Collections.emptySet(), new HashMap())).isFalse();
    }

    @Test
    void testPartialFinishedBlockingInput() {
        TestingSchedulingTopology topology = new TestingSchedulingTopology();
        List<TestingSchedulingExecutionVertex> producers = topology.addExecutionVertices().withParallelism(2).finish();
        List<TestingSchedulingExecutionVertex> consumer = topology.addExecutionVertices().withParallelism(2).finish();
        topology.connectAllToAll(producers, consumer).withResultPartitionState(ResultPartitionState.CREATED).withResultPartitionType(ResultPartitionType.BLOCKING).finish();
        topology.getResultPartition(producers.get(0).getProducedResults().iterator().next().getId()).markFinished();
        PartialFinishedInputConsumableDecider inputConsumableDecider = PartialFinishedInputConsumableDeciderTest.createPartialFinishedInputConsumableDecider();
        Assertions.assertThat((boolean)inputConsumableDecider.isInputConsumable((SchedulingExecutionVertex)consumer.get(0), Collections.emptySet(), new HashMap())).isFalse();
        Assertions.assertThat((boolean)inputConsumableDecider.isInputConsumable((SchedulingExecutionVertex)consumer.get(1), Collections.emptySet(), new HashMap())).isFalse();
    }

    @Test
    void testAllFinishedBlockingInput() {
        TestingSchedulingTopology topology = new TestingSchedulingTopology();
        List<TestingSchedulingExecutionVertex> producers = topology.addExecutionVertices().withParallelism(2).finish();
        List<TestingSchedulingExecutionVertex> consumer = topology.addExecutionVertices().withParallelism(2).finish();
        topology.connectAllToAll(producers, consumer).withResultPartitionState(ResultPartitionState.ALL_DATA_PRODUCED).withResultPartitionType(ResultPartitionType.BLOCKING).finish();
        PartialFinishedInputConsumableDecider inputConsumableDecider = PartialFinishedInputConsumableDeciderTest.createPartialFinishedInputConsumableDecider();
        Assertions.assertThat((boolean)inputConsumableDecider.isInputConsumable((SchedulingExecutionVertex)consumer.get(0), Collections.emptySet(), new HashMap())).isTrue();
        Assertions.assertThat((boolean)inputConsumableDecider.isInputConsumable((SchedulingExecutionVertex)consumer.get(1), Collections.emptySet(), new HashMap())).isTrue();
    }

    @Test
    void testNotFinishedHybridInput() {
        TestingSchedulingTopology topology = new TestingSchedulingTopology();
        List<TestingSchedulingExecutionVertex> producers = topology.addExecutionVertices().withParallelism(2).finish();
        List<TestingSchedulingExecutionVertex> consumer = topology.addExecutionVertices().withParallelism(2).finish();
        topology.connectAllToAll(producers, consumer).withResultPartitionState(ResultPartitionState.CREATED).withResultPartitionType(ResultPartitionType.HYBRID_FULL).finish();
        PartialFinishedInputConsumableDecider inputConsumableDecider = PartialFinishedInputConsumableDeciderTest.createPartialFinishedInputConsumableDecider();
        Assertions.assertThat((boolean)inputConsumableDecider.isInputConsumable((SchedulingExecutionVertex)consumer.get(0), Collections.emptySet(), new HashMap())).isFalse();
        Assertions.assertThat((boolean)inputConsumableDecider.isInputConsumable((SchedulingExecutionVertex)consumer.get(1), Collections.emptySet(), new HashMap())).isFalse();
    }

    @Test
    void testPartialFinishedHybridInput() {
        TestingSchedulingTopology topology = new TestingSchedulingTopology();
        List<TestingSchedulingExecutionVertex> producers = topology.addExecutionVertices().withParallelism(2).finish();
        List<TestingSchedulingExecutionVertex> consumer = topology.addExecutionVertices().withParallelism(2).finish();
        topology.connectAllToAll(producers, consumer).withResultPartitionState(ResultPartitionState.ALL_DATA_PRODUCED).withResultPartitionType(ResultPartitionType.HYBRID_FULL).finish();
        topology.getResultPartition(producers.get(0).getProducedResults().iterator().next().getId()).markFinished();
        PartialFinishedInputConsumableDecider inputConsumableDecider = PartialFinishedInputConsumableDeciderTest.createPartialFinishedInputConsumableDecider();
        Assertions.assertThat((boolean)inputConsumableDecider.isInputConsumable((SchedulingExecutionVertex)consumer.get(0), Collections.emptySet(), new HashMap())).isTrue();
        Assertions.assertThat((boolean)inputConsumableDecider.isInputConsumable((SchedulingExecutionVertex)consumer.get(1), Collections.emptySet(), new HashMap())).isTrue();
    }

    @Test
    void testAllFinishedHybridInput() {
        TestingSchedulingTopology topology = new TestingSchedulingTopology();
        List<TestingSchedulingExecutionVertex> producers = topology.addExecutionVertices().withParallelism(2).finish();
        List<TestingSchedulingExecutionVertex> consumer = topology.addExecutionVertices().withParallelism(2).finish();
        topology.connectAllToAll(producers, consumer).withResultPartitionState(ResultPartitionState.ALL_DATA_PRODUCED).withResultPartitionType(ResultPartitionType.HYBRID_FULL).finish();
        PartialFinishedInputConsumableDecider inputConsumableDecider = PartialFinishedInputConsumableDeciderTest.createPartialFinishedInputConsumableDecider();
        Assertions.assertThat((boolean)inputConsumableDecider.isInputConsumable((SchedulingExecutionVertex)consumer.get(0), Collections.emptySet(), new HashMap())).isTrue();
        Assertions.assertThat((boolean)inputConsumableDecider.isInputConsumable((SchedulingExecutionVertex)consumer.get(1), Collections.emptySet(), new HashMap())).isTrue();
    }

    private static PartialFinishedInputConsumableDecider createPartialFinishedInputConsumableDecider() {
        return new PartialFinishedInputConsumableDecider();
    }
}

