/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.memory;

import java.io.IOException;
import java.util.HashMap;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.runtime.state.memory.ByteStreamStateHandle;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ByteStreamStateHandleTest {
    ByteStreamStateHandleTest() {
    }

    @Test
    void testStreamSeekAndPos() throws IOException {
        byte[] data = new byte[]{34, 25, 22, 66, 88, 54};
        ByteStreamStateHandle handle = new ByteStreamStateHandle("name", data);
        for (int i = data.length; i >= 0; --i) {
            FSDataInputStream in = handle.openInputStream();
            in.seek((long)i);
            Assertions.assertThat((long)in.getPos()).isEqualTo((long)i);
            if (i < data.length) {
                Assertions.assertThat((int)in.read()).isEqualTo((int)data[i]);
                Assertions.assertThat((long)in.getPos()).isEqualTo((long)(i + 1));
                continue;
            }
            Assertions.assertThat((int)in.read()).isEqualTo(-1);
            Assertions.assertThat((long)in.getPos()).isEqualTo((long)i);
        }
        FSDataInputStream in = handle.openInputStream();
        in.seek((long)data.length);
        Assertions.assertThat((int)in.read()).isEqualTo(-1);
        Assertions.assertThat((int)in.read()).isEqualTo(-1);
        Assertions.assertThat((int)in.read()).isEqualTo(-1);
        Assertions.assertThat((long)in.getPos()).isEqualTo((long)data.length);
    }

    @Test
    void testStreamSeekOutOfBounds() {
        int len = 10;
        ByteStreamStateHandle handle = new ByteStreamStateHandle("name", new byte[10]);
        Assertions.assertThatThrownBy(() -> handle.openInputStream().seek(-2L)).isInstanceOf(IOException.class);
        Assertions.assertThatThrownBy(() -> handle.openInputStream().seek(11L)).isInstanceOf(IOException.class);
        Assertions.assertThatThrownBy(() -> handle.openInputStream().seek(2147483747L)).isInstanceOf(IOException.class);
    }

    @Test
    void testBulkRead() throws IOException {
        byte[] data = new byte[]{34, 25, 22, 66};
        ByteStreamStateHandle handle = new ByteStreamStateHandle("name", data);
        int targetLen = 8;
        for (int start = 0; start < data.length; ++start) {
            for (int num = 0; num < 8; ++num) {
                FSDataInputStream in = handle.openInputStream();
                in.seek((long)start);
                byte[] target = new byte[8];
                int read = in.read(target, 8 - num, num);
                Assertions.assertThat((int)read).isEqualTo(Math.min(num, data.length - start));
                for (int i = 0; i < read; ++i) {
                    Assertions.assertThat((byte)target[8 - num + i]).isEqualTo(data[start + i]);
                }
                int newPos = start + read;
                Assertions.assertThat((long)in.getPos()).isEqualTo((long)newPos);
                Assertions.assertThat((int)in.read()).isEqualTo(newPos < data.length ? data[newPos] : -1);
            }
        }
    }

    @Test
    void testBulkReadINdexOutOfBounds() throws IOException {
        ByteStreamStateHandle handle = new ByteStreamStateHandle("name", new byte[10]);
        Assertions.assertThatThrownBy(() -> handle.openInputStream().read(new byte[10], -1, 5)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> handle.openInputStream().read(new byte[10], 10, 5)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> handle.openInputStream().read(new byte[10], 0, -2)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> handle.openInputStream().read(new byte[10], 5, 6)).isInstanceOf(IndexOutOfBoundsException.class);
        Assertions.assertThatThrownBy(() -> handle.openInputStream().read(new byte[10], 5, Integer.MAX_VALUE)).isInstanceOf(IndexOutOfBoundsException.class);
    }

    @Test
    void testStreamWithEmptyByteArray() throws IOException {
        byte[] data = new byte[]{};
        ByteStreamStateHandle handle = new ByteStreamStateHandle("name", data);
        try (FSDataInputStream in = handle.openInputStream();){
            byte[] dataGot = new byte[1];
            Assertions.assertThat((int)in.read(dataGot, 0, 0)).isZero();
            Assertions.assertThat((int)in.read()).isEqualTo(-1);
        }
    }

    @Test
    void testCollectSizeStats() {
        final byte[] data = new byte[5];
        ByteStreamStateHandle handle = new ByteStreamStateHandle("name", data);
        StateObject.StateObjectSizeStatsCollector statsCollector = StateObject.StateObjectSizeStatsCollector.create();
        handle.collectSizeStats(statsCollector);
        org.junit.jupiter.api.Assertions.assertEquals((Object)new HashMap<StateObject.StateObjectLocation, Long>(){
            {
                this.put(StateObject.StateObjectLocation.LOCAL_MEMORY, Long.valueOf(data.length));
            }
        }, (Object)statsCollector.getStats());
    }
}

