/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util.bash;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.cache.DistributedCache;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationFileMigrationUtils;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.runtime.util.bash.FlinkConfigLoader;
import org.apache.flink.testutils.junit.utils.TempDirUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class FlinkConfigLoaderTest {
    private static final String TEST_CONFIG_KEY = "test.key";
    private static final String TEST_CONFIG_VALUE = "test_value";
    @TempDir
    private Path confDir;

    @BeforeEach
    void setUp() throws IOException {
        File flinkConfFile = TempDirUtils.newFile((Path)this.confDir.toAbsolutePath(), (String)"config.yaml");
        FileWriter fw = new FileWriter(flinkConfFile);
        fw.write("test.key: test_value\n");
        fw.close();
    }

    @Test
    void testLoadConfigurationConfigDirLongOpt() throws Exception {
        String[] args = new String[]{"--configDir", this.confDir.toFile().getAbsolutePath()};
        Configuration configuration = FlinkConfigLoader.loadConfiguration((String[])args);
        this.verifyConfiguration(configuration, TEST_CONFIG_KEY, TEST_CONFIG_VALUE);
    }

    @Test
    void testloadAndModifyConfigurationConfigDirLongOpt() throws Exception {
        String[] args = new String[]{"--configDir", this.confDir.toFile().getAbsolutePath()};
        List list = FlinkConfigLoader.loadAndModifyConfiguration((String[])args);
        Assertions.assertThat((List)list).containsExactly((Object[])new String[]{"test:", "  key: test_value"});
    }

    @Test
    void testLoadConfigurationConfigDirShortOpt() throws Exception {
        String[] args = new String[]{"-c", this.confDir.toFile().getAbsolutePath()};
        Configuration configuration = FlinkConfigLoader.loadConfiguration((String[])args);
        this.verifyConfiguration(configuration, TEST_CONFIG_KEY, TEST_CONFIG_VALUE);
    }

    @Test
    void testloadAndModifyConfigurationConfigDirShortOpt() throws Exception {
        String[] args = new String[]{"-c", this.confDir.toFile().getAbsolutePath()};
        List list = FlinkConfigLoader.loadAndModifyConfiguration((String[])args);
        Assertions.assertThat((List)list).containsExactly((Object[])new String[]{"test:", "  key: test_value"});
    }

    @Test
    void testLoadConfigurationDynamicPropertyWithSpace() throws Exception {
        String[] args = new String[]{"--configDir", this.confDir.toFile().getAbsolutePath(), "-D", "key=value"};
        Configuration configuration = FlinkConfigLoader.loadConfiguration((String[])args);
        this.verifyConfiguration(configuration, "key", "value");
    }

    @Test
    void testloadAndModifyConfigurationDynamicPropertyWithSpace() throws Exception {
        String[] args = new String[]{"--configDir", this.confDir.toFile().getAbsolutePath(), "-D", "key=value"};
        List list = FlinkConfigLoader.loadAndModifyConfiguration((String[])args);
        Assertions.assertThat((List)list).containsExactly((Object[])new String[]{"test:", "  key: test_value", "key: value"});
    }

    @Test
    void testLoadConfigurationDynamicPropertyWithoutSpace() throws Exception {
        String[] args = new String[]{"--configDir", this.confDir.toFile().getAbsolutePath(), "-Dkey=value"};
        Configuration configuration = FlinkConfigLoader.loadConfiguration((String[])args);
        this.verifyConfiguration(configuration, "key", "value");
    }

    @Test
    void testloadAndModifyConfigurationDynamicPropertyWithoutSpace() throws Exception {
        String[] args = new String[]{"--configDir", this.confDir.toFile().getAbsolutePath(), "-Dkey=value"};
        List list = FlinkConfigLoader.loadAndModifyConfiguration((String[])args);
        Assertions.assertThat((List)list).containsExactly((Object[])new String[]{"test:", "  key: test_value", "key: value"});
    }

    @Test
    void testLoadConfigurationIgnoreUnknownToken() throws Exception {
        String[] args = new String[]{"unknown", "-u", "--configDir", this.confDir.toFile().getAbsolutePath(), "--unknown", "-Dkey=value"};
        Configuration configuration = FlinkConfigLoader.loadConfiguration((String[])args);
        this.verifyConfiguration(configuration, TEST_CONFIG_KEY, TEST_CONFIG_VALUE);
        this.verifyConfiguration(configuration, "key", "value");
    }

    @Test
    void testloadAndModifyConfigurationIgnoreUnknownToken() throws Exception {
        String[] args = new String[]{"unknown", "-u", "--configDir", this.confDir.toFile().getAbsolutePath(), "--unknown", "-Dkey=value"};
        List list = FlinkConfigLoader.loadAndModifyConfiguration((String[])args);
        Assertions.assertThat((List)list).containsExactly((Object[])new String[]{"test:", "  key: test_value", "key: value"});
    }

    @Test
    void testloadAndModifyConfigurationRemoveKeysMatched() throws Exception {
        String key = "key";
        String[] args = new String[]{"--configDir", this.confDir.toFile().getAbsolutePath(), String.format("-D%s=value", key), "--removeKey", key};
        List list = FlinkConfigLoader.loadAndModifyConfiguration((String[])args);
        Assertions.assertThat((List)list).containsExactly((Object[])new String[]{"test:", "  key: test_value"});
    }

    @Test
    void testloadAndModifyConfigurationRemoveKeysNotMatched() throws Exception {
        String key = "key";
        String value = "value";
        String removeKey = "removeKey";
        String[] args = new String[]{"--configDir", this.confDir.toFile().getAbsolutePath(), String.format("-D%s=%s", key, value), "--removeKey", removeKey};
        List list = FlinkConfigLoader.loadAndModifyConfiguration((String[])args);
        Assertions.assertThat((List)list).containsExactly((Object[])new String[]{"test:", "  key: test_value", key + ": " + value});
    }

    @Test
    void testloadAndModifyConfigurationRemoveKeyValuesMatched() throws Exception {
        String removeKey = "removeKey";
        String removeValue = "removeValue";
        String[] args = new String[]{"--configDir", this.confDir.toFile().getAbsolutePath(), String.format("-D%s=%s", removeKey, removeValue), "--removeKeyValue", String.format("%s=%s", removeKey, removeValue)};
        List list = FlinkConfigLoader.loadAndModifyConfiguration((String[])args);
        Assertions.assertThat((List)list).containsExactly((Object[])new String[]{"test:", "  key: test_value"});
    }

    @Test
    void testloadAndModifyConfigurationRemoveKeyValuesNotMatched() throws Exception {
        String removeKey = "removeKey";
        String removeValue = "removeValue";
        String nonExistentValue = "nonExistentValue";
        String[] args = new String[]{"--configDir", this.confDir.toFile().getAbsolutePath(), String.format("-D%s=%s", removeKey, removeValue), "--removeKeyValue", String.format("%s=%s", removeKey, nonExistentValue)};
        List list = FlinkConfigLoader.loadAndModifyConfiguration((String[])args);
        Assertions.assertThat((List)list).containsExactlyInAnyOrder((Object[])new String[]{"test:", "  key: test_value", removeKey + ": " + removeValue});
    }

    @Test
    void testloadAndModifyConfigurationReplaceKeyValuesMatched() throws Exception {
        String newValue = "newValue";
        String[] args = new String[]{"--configDir", this.confDir.toFile().getAbsolutePath(), "--replaceKeyValue", String.format("%s,%s,%s", TEST_CONFIG_KEY, TEST_CONFIG_VALUE, newValue)};
        List list = FlinkConfigLoader.loadAndModifyConfiguration((String[])args);
        Assertions.assertThat((List)list).containsExactly((Object[])new String[]{"test:", "  key: " + newValue});
    }

    @Test
    void testloadAndModifyConfigurationReplaceKeyValuesNotMatched() throws Exception {
        String nonExistentValue = "nonExistentValue";
        String newValue = "newValue";
        String[] args = new String[]{"--configDir", this.confDir.toFile().getAbsolutePath(), "--replaceKeyValue", String.format("%s,%s,%s", TEST_CONFIG_KEY, nonExistentValue, newValue)};
        List list = FlinkConfigLoader.loadAndModifyConfiguration((String[])args);
        Assertions.assertThat((List)list).containsExactly((Object[])new String[]{"test:", "  key: test_value"});
    }

    @Test
    void testloadAndModifyConfigurationWithFlatten() throws Exception {
        String[] args = new String[]{"-c", this.confDir.toFile().getAbsolutePath(), "-flatten"};
        List list = FlinkConfigLoader.loadAndModifyConfiguration((String[])args);
        Assertions.assertThat((List)list).containsExactly((Object[])new String[]{"test.key: test_value"});
    }

    @Test
    void testMigrateLegacyConfigToStandardYaml() throws Exception {
        File file = new File(this.confDir.toFile(), "flink-conf.yaml");
        try (FileWriter fw = new FileWriter(file);){
            fw.write("test.key: test_value\n");
            fw.write("pipeline.cached-files: name:file1,path:'file:///tmp/file1';name:file2,path:'hdfs:///tmp/file2'\n");
        }
        Map configuration = ConfigurationFileMigrationUtils.loadLegacyYAMLResource((File)file);
        File newConfigFolder = TempDirUtils.newFolder((Path)this.confDir);
        try (FileWriter fw = new FileWriter(TempDirUtils.newFile((Path)newConfigFolder.toPath(), (String)"config.yaml"));){
            String[] args = new String[]{"-c", this.confDir.toFile().getAbsolutePath()};
            for (String line : FlinkConfigLoader.migrateLegacyConfigurationToStandardYaml((String[])args)) {
                fw.write(line + "\n");
            }
        }
        Configuration standardYamlConfig = GlobalConfiguration.loadConfiguration((String)newConfigFolder.toString());
        Assertions.assertThat((String)configuration.getOrDefault(TEST_CONFIG_KEY, null)).isEqualTo(standardYamlConfig.getString(TEST_CONFIG_KEY, null));
        List cachedFiles = (List)ConfigurationUtils.convertToList(configuration.get(PipelineOptions.CACHED_FILES.key()), String.class);
        Assertions.assertThat((List)DistributedCache.parseCachedFilesFromString((List)cachedFiles)).isEqualTo((Object)DistributedCache.parseCachedFilesFromString((List)((List)standardYamlConfig.get(PipelineOptions.CACHED_FILES))));
    }

    private void verifyConfiguration(Configuration config, String key, String expectedValue) {
        ConfigOption option = ConfigOptions.key((String)key).stringType().noDefaultValue();
        Assertions.assertThat((String)((String)config.get(option))).isEqualTo(expectedValue);
    }
}

