/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.throughput;

import java.time.Duration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.util.Preconditions;

public final class BufferDebloatConfiguration {
    private final Duration targetTotalTime;
    private final int maxBufferSize;
    private final int minBufferSize;
    private final int bufferDebloatThresholdPercentages;
    private final int numberOfSamples;
    private final boolean enabled;

    private BufferDebloatConfiguration(boolean enabled, Duration targetTotalTime, int maxBufferSize, int minBufferSize, int bufferDebloatThresholdPercentages, int numberOfSamples) {
        this.targetTotalTime = (Duration)Preconditions.checkNotNull((Object)targetTotalTime);
        this.maxBufferSize = maxBufferSize;
        this.minBufferSize = minBufferSize;
        this.bufferDebloatThresholdPercentages = bufferDebloatThresholdPercentages;
        this.numberOfSamples = numberOfSamples;
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Duration getTargetTotalTime() {
        return this.targetTotalTime;
    }

    public int getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public int getMinBufferSize() {
        return this.minBufferSize;
    }

    public int getBufferDebloatThresholdPercentages() {
        return this.bufferDebloatThresholdPercentages;
    }

    public int getNumberOfSamples() {
        return this.numberOfSamples;
    }

    public static BufferDebloatConfiguration fromConfiguration(ReadableConfig config) {
        Duration targetTotalTime = (Duration)config.get(TaskManagerOptions.BUFFER_DEBLOAT_TARGET);
        int maxBufferSize = Math.toIntExact(((MemorySize)config.get(TaskManagerOptions.MEMORY_SEGMENT_SIZE)).getBytes());
        int minBufferSize = Math.toIntExact(((MemorySize)config.get(TaskManagerOptions.MIN_MEMORY_SEGMENT_SIZE)).getBytes());
        int bufferDebloatThresholdPercentages = (Integer)config.get(TaskManagerOptions.BUFFER_DEBLOAT_THRESHOLD_PERCENTAGES);
        int numberOfSamples = (Integer)config.get(TaskManagerOptions.BUFFER_DEBLOAT_SAMPLES);
        Preconditions.checkArgument((maxBufferSize > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((minBufferSize > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((numberOfSamples > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((maxBufferSize >= minBufferSize ? 1 : 0) != 0);
        Preconditions.checkArgument(((double)targetTotalTime.toMillis() > 0.0 ? 1 : 0) != 0);
        return new BufferDebloatConfiguration((Boolean)config.get(TaskManagerOptions.BUFFER_DEBLOAT_ENABLED), targetTotalTime, maxBufferSize, minBufferSize, bufferDebloatThresholdPercentages, numberOfSamples);
    }
}

