/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.checkpoint.CheckpointCoordinatorTestingUtils;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.StateObjectCollection;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.checkpoint.channel.ResultSubpartitionInfo;
import org.apache.flink.runtime.state.InputChannelStateHandle;
import org.apache.flink.runtime.state.ResultSubpartitionStateHandle;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.memory.ByteStreamStateHandle;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class OperatorSubtaskStateTest {
    OperatorSubtaskStateTest() {
    }

    @Test
    void testDiscardDuplicatedDelegatesOnce() {
        DiscardOnceStreamStateHandle delegate = new DiscardOnceStreamStateHandle();
        OperatorSubtaskState.builder().setInputChannelState(new StateObjectCollection(Arrays.asList(this.buildInputChannelHandle((StreamStateHandle)delegate, 1), this.buildInputChannelHandle((StreamStateHandle)delegate, 2)))).setResultSubpartitionState(new StateObjectCollection(Arrays.asList(this.buildSubpartitionHandle((StreamStateHandle)delegate, 4), this.buildSubpartitionHandle((StreamStateHandle)delegate, 3)))).build().discardState();
    }

    @Test
    void testToBuilderCorrectness() throws IOException {
        OperatorSubtaskState operatorSubtaskState = (OperatorSubtaskState)CheckpointCoordinatorTestingUtils.generateSampleOperatorSubtaskState().f1;
        OperatorSubtaskState operatorSubtaskStateCopy = operatorSubtaskState.toBuilder().build();
        Assertions.assertThat((boolean)EqualsBuilder.reflectionEquals((Object)operatorSubtaskState, (Object)operatorSubtaskStateCopy, (String[])new String[0])).isTrue();
    }

    @Test
    void testGetDiscardables() throws IOException {
        Tuple2<List<StateObject>, OperatorSubtaskState> opStates = CheckpointCoordinatorTestingUtils.generateSampleOperatorSubtaskState();
        List states = (List)opStates.f0;
        OperatorSubtaskState operatorSubtaskState = (OperatorSubtaskState)opStates.f1;
        List<StateObject> discardables = Arrays.asList((StateObject)states.get(0), (StateObject)states.get(1), (StateObject)states.get(2), (StateObject)states.get(3), ((InputChannelStateHandle)states.get(4)).getDelegate(), ((ResultSubpartitionStateHandle)states.get(5)).getDelegate());
        Assertions.assertThat(new HashSet(operatorSubtaskState.getDiscardables())).isEqualTo(new HashSet<StateObject>(discardables));
    }

    private ResultSubpartitionStateHandle buildSubpartitionHandle(StreamStateHandle delegate, int subPartitionIdx1) {
        return new ResultSubpartitionStateHandle(new ResultSubpartitionInfo(0, subPartitionIdx1), delegate, Collections.singletonList(0L));
    }

    private InputChannelStateHandle buildInputChannelHandle(StreamStateHandle delegate, int inputChannelIdx) {
        return new InputChannelStateHandle(new InputChannelInfo(0, inputChannelIdx), delegate, Collections.singletonList(0L));
    }

    private static class DiscardOnceStreamStateHandle
    extends ByteStreamStateHandle {
        private static final long serialVersionUID = 1L;
        private boolean discarded = false;

        DiscardOnceStreamStateHandle() {
            super("test", new byte[0]);
        }

        public void discardState() {
            super.discardState();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.discarded).as("state was discarded twice", new Object[0])).isFalse();
            this.discarded = true;
        }
    }
}

