/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.sort;

import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.memory.MemoryManagerBuilder;
import org.apache.flink.runtime.operators.sort.IndexedSortable;
import org.apache.flink.runtime.operators.sort.NormalizedKeySorter;
import org.apache.flink.runtime.operators.sort.QuickSort;
import org.apache.flink.runtime.operators.testutils.DummyInvokable;
import org.apache.flink.runtime.operators.testutils.TestData;
import org.apache.flink.util.MutableObjectIterator;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class NormalizedKeySorterTest {
    private static final long SEED = 649180756312423613L;
    private static final long SEED2 = 97652436586326573L;
    private static final int KEY_MAX = Integer.MAX_VALUE;
    private static final int VALUE_LENGTH = 118;
    private static final int MEMORY_SIZE = 0x4000000;
    private static final int MEMORY_PAGE_SIZE = 32768;
    private MemoryManager memoryManager;

    NormalizedKeySorterTest() {
    }

    @BeforeEach
    void beforeTest() {
        this.memoryManager = MemoryManagerBuilder.newBuilder().setMemorySize(0x4000000L).setPageSize(32768).build();
    }

    @AfterEach
    void afterTest() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.memoryManager.verifyEmpty()).withFailMessage("Memory Leak: Some memory has not been returned to the memory manager.", new Object[0])).isTrue();
        if (this.memoryManager != null) {
            this.memoryManager.shutdown();
            this.memoryManager = null;
        }
    }

    private NormalizedKeySorter<Tuple2<Integer, String>> newSortBuffer(List<MemorySegment> memory) throws Exception {
        return new NormalizedKeySorter(TestData.getIntStringTupleSerializer(), TestData.getIntStringTupleComparator(), memory);
    }

    @Test
    void testWriteAndRead() throws Exception {
        int numSegments = 2048;
        List memory = this.memoryManager.allocatePages((Object)new DummyInvokable(), 2048);
        NormalizedKeySorter<Tuple2<Integer, String>> sorter = this.newSortBuffer(memory);
        TestData.TupleGenerator generator = new TestData.TupleGenerator(649180756312423613L, Integer.MAX_VALUE, 118, TestData.TupleGenerator.KeyMode.RANDOM, TestData.TupleGenerator.ValueMode.RANDOM_LENGTH);
        Tuple2 record = new Tuple2();
        int num = -1;
        do {
            generator.next((Tuple2<Integer, String>)record);
            ++num;
        } while (sorter.write((Object)record));
        generator.reset();
        Tuple2 readTarget = new Tuple2();
        int i = 0;
        while (i < num) {
            generator.next((Tuple2<Integer, String>)record);
            readTarget = (Tuple2)sorter.getRecord((Object)readTarget, i++);
            int rk = (Integer)readTarget.f0;
            int gk = (Integer)record.f0;
            String rv = (String)readTarget.f1;
            String gv = (String)record.f1;
            ((AbstractIntegerAssert)Assertions.assertThat((int)rk).withFailMessage("The re-read key is wrong", new Object[0])).isEqualTo(gk);
            ((AbstractStringAssert)Assertions.assertThat((String)rv).withFailMessage("The re-read value is wrong", new Object[0])).isEqualTo(gv);
        }
        sorter.dispose();
        this.memoryManager.release((Collection)memory);
    }

    @Test
    void testWriteAndIterator() throws Exception {
        int numSegments = 2048;
        List memory = this.memoryManager.allocatePages((Object)new DummyInvokable(), 2048);
        NormalizedKeySorter<Tuple2<Integer, String>> sorter = this.newSortBuffer(memory);
        TestData.TupleGenerator generator = new TestData.TupleGenerator(649180756312423613L, Integer.MAX_VALUE, 118, TestData.TupleGenerator.KeyMode.RANDOM, TestData.TupleGenerator.ValueMode.RANDOM_LENGTH);
        Tuple2 record = new Tuple2();
        do {
            generator.next((Tuple2<Integer, String>)record);
        } while (sorter.write((Object)record));
        generator.reset();
        MutableObjectIterator iter = sorter.getIterator();
        Tuple2 readTarget = new Tuple2();
        while ((readTarget = (Tuple2)iter.next((Object)readTarget)) != null) {
            generator.next((Tuple2<Integer, String>)record);
            int rk = (Integer)readTarget.f0;
            int gk = (Integer)record.f0;
            String rv = (String)readTarget.f1;
            String gv = (String)record.f1;
            ((AbstractIntegerAssert)Assertions.assertThat((int)rk).withFailMessage("The re-read key is wrong", new Object[0])).isEqualTo(gk);
            ((AbstractStringAssert)Assertions.assertThat((String)rv).withFailMessage("The re-read value is wrong", new Object[0])).isEqualTo(gv);
        }
        sorter.dispose();
        this.memoryManager.release((Collection)memory);
    }

    @Test
    void testReset() throws Exception {
        int numSegments = 2048;
        List memory = this.memoryManager.allocatePages((Object)new DummyInvokable(), 2048);
        NormalizedKeySorter<Tuple2<Integer, String>> sorter = this.newSortBuffer(memory);
        TestData.TupleGenerator generator = new TestData.TupleGenerator(649180756312423613L, Integer.MAX_VALUE, 118, TestData.TupleGenerator.KeyMode.RANDOM, TestData.TupleGenerator.ValueMode.FIX_LENGTH);
        Tuple2 record = new Tuple2();
        int num = -1;
        do {
            generator.next((Tuple2<Integer, String>)record);
            ++num;
        } while (sorter.write((Object)record));
        sorter.reset();
        generator = new TestData.TupleGenerator(97652436586326573L, Integer.MAX_VALUE, 118, TestData.TupleGenerator.KeyMode.RANDOM, TestData.TupleGenerator.ValueMode.FIX_LENGTH);
        int num2 = -1;
        do {
            generator.next((Tuple2<Integer, String>)record);
            ++num2;
        } while (sorter.write((Object)record));
        ((AbstractIntegerAssert)Assertions.assertThat((int)num2).withFailMessage("The number of records written after the reset was not the same as before.", new Object[0])).isEqualTo(num);
        generator.reset();
        Tuple2 readTarget = new Tuple2();
        int i = 0;
        while (i < num) {
            generator.next((Tuple2<Integer, String>)record);
            readTarget = (Tuple2)sorter.getRecord((Object)readTarget, i++);
            int rk = (Integer)readTarget.f0;
            int gk = (Integer)record.f0;
            String rv = (String)readTarget.f1;
            String gv = (String)record.f1;
            ((AbstractIntegerAssert)Assertions.assertThat((int)rk).withFailMessage("The re-read key is wrong", new Object[0])).isEqualTo(gk);
            ((AbstractStringAssert)Assertions.assertThat((String)rv).withFailMessage("The re-read value is wrong", new Object[0])).isEqualTo(gv);
        }
        sorter.dispose();
        this.memoryManager.release((Collection)memory);
    }

    @Test
    void testSwap() throws Exception {
        int numSegments = 2048;
        List memory = this.memoryManager.allocatePages((Object)new DummyInvokable(), 2048);
        NormalizedKeySorter<Tuple2<Integer, String>> sorter = this.newSortBuffer(memory);
        TestData.TupleGenerator generator = new TestData.TupleGenerator(649180756312423613L, Integer.MAX_VALUE, 118, TestData.TupleGenerator.KeyMode.RANDOM, TestData.TupleGenerator.ValueMode.RANDOM_LENGTH);
        Tuple2 record = new Tuple2();
        int num = -1;
        do {
            generator.next((Tuple2<Integer, String>)record);
            ++num;
        } while (sorter.write((Object)record));
        int start = 0;
        int end = num - 1;
        while (start < end) {
            sorter.swap(start++, end--);
        }
        generator.reset();
        Tuple2 readTarget = new Tuple2();
        int i = num - 1;
        while (i >= 0) {
            generator.next((Tuple2<Integer, String>)record);
            readTarget = (Tuple2)sorter.getRecord((Object)readTarget, i--);
            int rk = (Integer)readTarget.f0;
            int gk = (Integer)record.f0;
            String rv = (String)readTarget.f1;
            String gv = (String)record.f1;
            ((AbstractIntegerAssert)Assertions.assertThat((int)rk).withFailMessage("The re-read key is wrong", new Object[0])).isEqualTo(gk);
            ((AbstractStringAssert)Assertions.assertThat((String)rv).withFailMessage("The re-read value is wrong", new Object[0])).isEqualTo(gv);
        }
        sorter.dispose();
        this.memoryManager.release((Collection)memory);
    }

    @Test
    void testCompare() throws Exception {
        int numSegments = 2048;
        List memory = this.memoryManager.allocatePages((Object)new DummyInvokable(), 2048);
        NormalizedKeySorter<Tuple2<Integer, String>> sorter = this.newSortBuffer(memory);
        TestData.TupleGenerator generator = new TestData.TupleGenerator(649180756312423613L, Integer.MAX_VALUE, 118, TestData.TupleGenerator.KeyMode.SORTED, TestData.TupleGenerator.ValueMode.RANDOM_LENGTH);
        Tuple2 record = new Tuple2();
        int num = -1;
        do {
            generator.next((Tuple2<Integer, String>)record);
            ++num;
        } while (sorter.write((Object)record));
        Random rnd = new Random(1298361512624847226L);
        for (int i = 0; i < 2 * num; ++i) {
            int pos1 = rnd.nextInt(num);
            int pos2 = rnd.nextInt(num);
            int cmp = sorter.compare(pos1, pos2);
            if (pos1 < pos2) {
                Assertions.assertThat((int)cmp).isLessThanOrEqualTo(0);
                continue;
            }
            Assertions.assertThat((int)cmp).isGreaterThanOrEqualTo(0);
        }
        sorter.dispose();
        this.memoryManager.release((Collection)memory);
    }

    @Test
    void testSort() throws Exception {
        int NUM_RECORDS = 559273;
        int numSegments = 2048;
        List memory = this.memoryManager.allocatePages((Object)new DummyInvokable(), 2048);
        NormalizedKeySorter<Tuple2<Integer, String>> sorter = this.newSortBuffer(memory);
        TestData.TupleGenerator generator = new TestData.TupleGenerator(649180756312423613L, Integer.MAX_VALUE, 118, TestData.TupleGenerator.KeyMode.RANDOM, TestData.TupleGenerator.ValueMode.RANDOM_LENGTH);
        Tuple2 record = new Tuple2();
        int num = 0;
        do {
            generator.next((Tuple2<Integer, String>)record);
        } while (sorter.write((Object)record) && ++num < 559273);
        QuickSort qs = new QuickSort();
        qs.sort(sorter);
        MutableObjectIterator iter = sorter.getIterator();
        Tuple2 readTarget = new Tuple2();
        iter.next((Object)readTarget);
        int last = (Integer)readTarget.f0;
        while ((readTarget = (Tuple2)iter.next((Object)readTarget)) != null) {
            int current = (Integer)readTarget.f0;
            int cmp = last - current;
            ((AbstractIntegerAssert)Assertions.assertThat((int)cmp).withFailMessage("Next key is not larger or equal to previous key.", new Object[0])).isLessThanOrEqualTo(0);
            last = current;
        }
        sorter.dispose();
        this.memoryManager.release((Collection)memory);
    }

    @Test
    void testSortShortStringKeys() throws Exception {
        int numSegments = 2048;
        List memory = this.memoryManager.allocatePages((Object)new DummyInvokable(), 2048);
        TypeComparator accessors = TestData.getIntStringTupleTypeInfo().createComparator(new int[]{1}, new boolean[]{true}, 0, new ExecutionConfig());
        NormalizedKeySorter sorter = new NormalizedKeySorter(TestData.getIntStringTupleSerializer(), accessors, memory);
        TestData.TupleGenerator generator = new TestData.TupleGenerator(649180756312423613L, Integer.MAX_VALUE, 5, TestData.TupleGenerator.KeyMode.RANDOM, TestData.TupleGenerator.ValueMode.FIX_LENGTH);
        Tuple2 record = new Tuple2();
        do {
            generator.next((Tuple2<Integer, String>)record);
        } while (sorter.write((Object)record));
        QuickSort qs = new QuickSort();
        qs.sort((IndexedSortable)sorter);
        MutableObjectIterator iter = sorter.getIterator();
        Tuple2 readTarget = new Tuple2();
        iter.next((Object)readTarget);
        String last = (String)readTarget.f1;
        while ((readTarget = (Tuple2)iter.next((Object)readTarget)) != null) {
            String current = (String)readTarget.f1;
            int cmp = last.compareTo(current);
            ((AbstractIntegerAssert)Assertions.assertThat((int)cmp).withFailMessage("Next value is not larger or equal to previous value.", new Object[0])).isLessThanOrEqualTo(0);
            last = current;
        }
        sorter.dispose();
        this.memoryManager.release((Collection)memory);
    }

    @Test
    void testSortLongStringKeys() throws Exception {
        int numSegments = 2048;
        List memory = this.memoryManager.allocatePages((Object)new DummyInvokable(), 2048);
        TypeComparator accessors = TestData.getIntStringTupleTypeInfo().createComparator(new int[]{1}, new boolean[]{true}, 0, new ExecutionConfig());
        NormalizedKeySorter sorter = new NormalizedKeySorter(TestData.getIntStringTupleSerializer(), accessors, memory);
        TestData.TupleGenerator generator = new TestData.TupleGenerator(649180756312423613L, Integer.MAX_VALUE, 118, TestData.TupleGenerator.KeyMode.RANDOM, TestData.TupleGenerator.ValueMode.FIX_LENGTH);
        Tuple2 record = new Tuple2();
        do {
            generator.next((Tuple2<Integer, String>)record);
        } while (sorter.write((Object)record));
        QuickSort qs = new QuickSort();
        qs.sort((IndexedSortable)sorter);
        MutableObjectIterator iter = sorter.getIterator();
        Tuple2 readTarget = new Tuple2();
        iter.next((Object)readTarget);
        String last = (String)readTarget.f1;
        while ((readTarget = (Tuple2)iter.next((Object)readTarget)) != null) {
            String current = (String)readTarget.f1;
            int cmp = last.compareTo(current);
            ((AbstractIntegerAssert)Assertions.assertThat((int)cmp).withFailMessage("Next value is not larger or equal to previous value.", new Object[0])).isLessThanOrEqualTo(0);
            last = current;
        }
        sorter.dispose();
        this.memoryManager.release((Collection)memory);
    }
}

