/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationGroup;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationGroupImpl;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.runtime.scheduler.SlotSharingStrategy;
import org.apache.flink.runtime.scheduler.strategy.SchedulingTopology;
import org.apache.flink.runtime.scheduler.strategy.TestingSchedulingExecutionVertex;
import org.apache.flink.runtime.scheduler.strategy.TestingSchedulingTopology;
import org.apache.flink.shaded.guava32.com.google.common.collect.Sets;
import org.apache.flink.util.Preconditions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

abstract class AbstractSlotSharingStrategyTest {
    protected TestingSchedulingTopology topology;
    protected JobVertexID jobVertexId1;
    protected JobVertexID jobVertexId2;
    protected SlotSharingGroup slotSharingGroup;
    protected SlotSharingGroup slotSharingGroup1;
    protected SlotSharingGroup slotSharingGroup2;

    AbstractSlotSharingStrategyTest() {
    }

    @BeforeEach
    protected void setup() {
        this.topology = new TestingSchedulingTopology();
        this.jobVertexId1 = new JobVertexID();
        this.jobVertexId2 = new JobVertexID();
        this.slotSharingGroup = new SlotSharingGroup();
        this.slotSharingGroup1 = new SlotSharingGroup();
        this.slotSharingGroup2 = new SlotSharingGroup();
    }

    @Test
    void testSetSlotSharingGroupResource() {
        TestingSchedulingExecutionVertex ev10 = this.topology.newExecutionVertex(this.jobVertexId1, 0);
        TestingSchedulingExecutionVertex ev11 = this.topology.newExecutionVertex(this.jobVertexId1, 1);
        TestingSchedulingExecutionVertex ev20 = this.topology.newExecutionVertex(this.jobVertexId2, 0);
        ResourceProfile resourceProfile1 = ResourceProfile.fromResources((double)1.0, (int)10);
        this.slotSharingGroup1.addVertexToGroup(this.jobVertexId1);
        this.slotSharingGroup1.setResourceProfile(resourceProfile1);
        ResourceProfile resourceProfile2 = ResourceProfile.fromResources((double)2.0, (int)20);
        this.slotSharingGroup2.addVertexToGroup(this.jobVertexId2);
        this.slotSharingGroup2.setResourceProfile(resourceProfile2);
        SlotSharingStrategy strategy = this.getSlotSharingStrategy(this.topology, Sets.newHashSet((Object[])new SlotSharingGroup[]{this.slotSharingGroup1, this.slotSharingGroup2}), Sets.newHashSet());
        Assertions.assertThat((Collection)strategy.getExecutionSlotSharingGroups()).hasSize(3);
        Assertions.assertThat((Object)strategy.getExecutionSlotSharingGroup(ev10.getId()).getResourceProfile()).isEqualTo((Object)resourceProfile1);
        Assertions.assertThat((Object)strategy.getExecutionSlotSharingGroup(ev11.getId()).getResourceProfile()).isEqualTo((Object)resourceProfile1);
        Assertions.assertThat((Object)strategy.getExecutionSlotSharingGroup(ev20.getId()).getResourceProfile()).isEqualTo((Object)resourceProfile2);
    }

    protected abstract SlotSharingStrategy getSlotSharingStrategy(SchedulingTopology var1, Set<SlotSharingGroup> var2, Set<CoLocationGroup> var3);

    protected void renderTopology(TestingSchedulingTopology topology, List<TestingJobVertexInfo> mockedJobVertices, List<Tuple2<JobVertexID, List<TestingSchedulingExecutionVertex>>> jobVertexInfos) {
        for (TestingJobVertexInfo testingJobVertexInfo : mockedJobVertices) {
            ArrayList<TestingSchedulingExecutionVertex> tSEVs = new ArrayList<TestingSchedulingExecutionVertex>();
            for (int subIndex = 0; subIndex < testingJobVertexInfo.parallelism; ++subIndex) {
                tSEVs.add(topology.newExecutionVertex(testingJobVertexInfo.jobVertex.getID(), subIndex));
            }
            jobVertexInfos.add((Tuple2<JobVertexID, List<TestingSchedulingExecutionVertex>>)Tuple2.of((Object)testingJobVertexInfo.jobVertex.getID(), tSEVs));
        }
    }

    protected static class TestingJobVertexInfo {
        final JobVertex jobVertex = new JobVertex(null, new JobVertexID());
        @Nonnull
        SlotSharingGroup slotSharingGroup;
        @Nullable
        CoLocationGroup coLocationGroup;
        int parallelism;

        public TestingJobVertexInfo(int parallelism, @Nonnull SlotSharingGroup slotSharingGroup, @Nullable CoLocationGroup coLocationGroup) {
            Preconditions.checkArgument((parallelism > 0 ? 1 : 0) != 0);
            this.parallelism = parallelism;
            this.slotSharingGroup = slotSharingGroup;
            this.coLocationGroup = coLocationGroup;
            this.slotSharingGroup.addVertexToGroup(this.jobVertex.getID());
            if (this.coLocationGroup != null) {
                ((CoLocationGroupImpl)this.coLocationGroup).addVertex(this.jobVertex);
            }
        }
    }
}

