/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adapter;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.DefaultExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.scheduler.adapter.DefaultExecutionTopology;
import org.apache.flink.runtime.scheduler.adapter.DefaultExecutionVertex;
import org.apache.flink.runtime.scheduler.adapter.DefaultResultPartition;
import org.apache.flink.runtime.scheduler.adapter.DefaultSchedulingPipelinedRegion;
import org.apache.flink.runtime.scheduler.strategy.ConsumedPartitionGroup;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.util.JobVertexConnectionUtils;
import org.apache.flink.shaded.guava32.com.google.common.collect.Iterables;
import org.apache.flink.testutils.TestingUtils;
import org.apache.flink.testutils.executor.TestExecutorExtension;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class DefaultSchedulingPipelinedRegionTest {
    @RegisterExtension
    private static final TestExecutorExtension<ScheduledExecutorService> EXECUTOR_EXTENSION = TestingUtils.defaultExecutorExtension();

    DefaultSchedulingPipelinedRegionTest() {
    }

    @Test
    void gettingUnknownVertexThrowsException() {
        Map resultPartitionById = Collections.emptyMap();
        DefaultSchedulingPipelinedRegion pipelinedRegion = new DefaultSchedulingPipelinedRegion(Collections.emptySet(), resultPartitionById::get);
        ExecutionVertexID unknownVertexId = new ExecutionVertexID(new JobVertexID(), 0);
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> pipelinedRegion.getVertex(unknownVertexId)).withFailMessage("Expected exception not thrown", new Object[0])).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining(unknownVertexId + " not found");
    }

    @Test
    void returnsVertices() {
        DefaultExecutionVertex vertex = new DefaultExecutionVertex(new ExecutionVertexID(new JobVertexID(), 0), Collections.emptyList(), () -> ExecutionState.CREATED, Collections.emptyList(), partitionID -> {
            throw new UnsupportedOperationException();
        });
        Set<DefaultExecutionVertex> vertices = Collections.singleton(vertex);
        Map resultPartitionById = Collections.emptyMap();
        DefaultSchedulingPipelinedRegion pipelinedRegion = new DefaultSchedulingPipelinedRegion(vertices, resultPartitionById::get);
        Iterator vertexIterator = pipelinedRegion.getVertices().iterator();
        Assertions.assertThat(vertexIterator).hasNext();
        Assertions.assertThat((Object)((DefaultExecutionVertex)vertexIterator.next())).isSameAs((Object)vertex);
        Assertions.assertThat((boolean)vertexIterator.hasNext()).isFalse();
    }

    @Test
    void returnsIncidentBlockingPartitions() throws Exception {
        JobVertex a = ExecutionGraphTestUtils.createNoOpVertex(1);
        JobVertex b = ExecutionGraphTestUtils.createNoOpVertex(1);
        JobVertex c = ExecutionGraphTestUtils.createNoOpVertex(1);
        JobVertex d = ExecutionGraphTestUtils.createNoOpVertex(1);
        JobVertex e = ExecutionGraphTestUtils.createNoOpVertex(1);
        JobVertexConnectionUtils.connectNewDataSetAsInput(b, a, DistributionPattern.POINTWISE, ResultPartitionType.BLOCKING);
        JobVertexConnectionUtils.connectNewDataSetAsInput(c, b, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
        JobVertexConnectionUtils.connectNewDataSetAsInput(d, b, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
        JobVertexConnectionUtils.connectNewDataSetAsInput(e, c, DistributionPattern.POINTWISE, ResultPartitionType.BLOCKING);
        JobVertexConnectionUtils.connectNewDataSetAsInput(e, d, DistributionPattern.POINTWISE, ResultPartitionType.PIPELINED);
        DefaultExecutionGraph simpleTestGraph = ExecutionGraphTestUtils.createExecutionGraph((ScheduledExecutorService)EXECUTOR_EXTENSION.getExecutor(), a, b, c, d, e);
        DefaultExecutionTopology topology = DefaultExecutionTopology.fromExecutionGraph((DefaultExecutionGraph)simpleTestGraph);
        DefaultSchedulingPipelinedRegion firstPipelinedRegion = topology.getPipelinedRegionOfVertex(new ExecutionVertexID(a.getID(), 0));
        DefaultSchedulingPipelinedRegion secondPipelinedRegion = topology.getPipelinedRegionOfVertex(new ExecutionVertexID(e.getID(), 0));
        DefaultExecutionVertex vertexB0 = topology.getVertex(new ExecutionVertexID(b.getID(), 0));
        IntermediateResultPartitionID b0ConsumedResultPartition = ((DefaultResultPartition)Iterables.getOnlyElement((Iterable)vertexB0.getConsumedResults())).getId();
        HashSet<IntermediateResultPartitionID> secondPipelinedRegionConsumedResults = new HashSet<IntermediateResultPartitionID>();
        for (ConsumedPartitionGroup consumedPartitionGroup : secondPipelinedRegion.getAllNonPipelinedConsumedPartitionGroups()) {
            for (IntermediateResultPartitionID partitionId : consumedPartitionGroup) {
                if (secondPipelinedRegion.contains(topology.getResultPartition(partitionId).getProducer().getId())) continue;
                secondPipelinedRegionConsumedResults.add(partitionId);
            }
        }
        Assertions.assertThat((boolean)firstPipelinedRegion.getAllNonPipelinedConsumedPartitionGroups().iterator().hasNext()).isFalse();
        Assertions.assertThat(secondPipelinedRegionConsumedResults).contains((Object[])new IntermediateResultPartitionID[]{b0ConsumedResultPartition});
    }
}

