/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.testutils;

import java.util.ArrayList;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.runtime.entrypoint.ClusterEntrypoint;
import org.apache.flink.runtime.entrypoint.StandaloneSessionClusterEntrypoint;
import org.apache.flink.runtime.testutils.TestJvmProcess;
import org.apache.flink.util.ParameterTool;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatcherProcess
extends TestJvmProcess {
    private static final Logger LOG = LoggerFactory.getLogger(DispatcherProcess.class);
    private final int id;
    private final Configuration config;
    private final String[] jvmArgs;

    public DispatcherProcess(int id, Configuration config) throws Exception {
        Preconditions.checkArgument((id >= 0 ? 1 : 0) != 0, (Object)"Negative ID");
        this.id = id;
        this.config = (Configuration)Preconditions.checkNotNull((Object)config, (String)"Configuration");
        ArrayList<Object> args = new ArrayList<Object>();
        for (Map.Entry entry : config.toMap().entrySet()) {
            args.add("--" + (String)entry.getKey());
            args.add((String)entry.getValue());
        }
        this.jvmArgs = new String[args.size()];
        args.toArray(this.jvmArgs);
    }

    @Override
    public String getName() {
        return "Dispatcher " + this.id;
    }

    @Override
    public String[] getMainMethodArgs() {
        return this.jvmArgs;
    }

    @Override
    public String getEntryPointClassName() {
        return DispatcherProcessEntryPoint.class.getName();
    }

    public Configuration getConfig() {
        return this.config;
    }

    public String toString() {
        return String.format("DispatcherProcess(id=%d)", this.id);
    }

    public static class DispatcherProcessEntryPoint {
        private static final Logger LOG = LoggerFactory.getLogger(DispatcherProcessEntryPoint.class);

        public static void main(String[] args) {
            try {
                ParameterTool params = ParameterTool.fromArgs((String[])args);
                Configuration config = params.getConfiguration();
                LOG.info("Configuration: {}.", (Object)config);
                config.set(JobManagerOptions.PORT, (Object)0);
                config.set(RestOptions.BIND_PORT, (Object)"0");
                StandaloneSessionClusterEntrypoint clusterEntrypoint = new StandaloneSessionClusterEntrypoint(config);
                ClusterEntrypoint.runClusterEntrypoint((ClusterEntrypoint)clusterEntrypoint);
            }
            catch (Throwable t) {
                LOG.error("Failed to start Dispatcher process", t);
                System.exit(1);
            }
        }
    }
}

