/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriter;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.runtime.io.network.buffer.BufferConsumerWithPartialRecordLength;
import org.apache.flink.runtime.io.network.logger.NetworkActionsLogger;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.ChannelStateHolder;
import org.apache.flink.runtime.io.network.partition.PipelinedSubpartitionView;
import org.apache.flink.runtime.io.network.partition.PrioritizedDeque;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.shaded.guava32.com.google.common.collect.Iterators;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelinedSubpartition
extends ResultSubpartition
implements ChannelStateHolder {
    private static final Logger LOG = LoggerFactory.getLogger(PipelinedSubpartition.class);
    private static final int DEFAULT_PRIORITY_SEQUENCE_NUMBER = -1;
    private final int receiverExclusiveBuffersPerChannel;
    final PrioritizedDeque<BufferConsumerWithPartialRecordLength> buffers = new PrioritizedDeque();
    @GuardedBy(value="buffers")
    private int buffersInBacklog;
    PipelinedSubpartitionView readView;
    private boolean isFinished;
    @GuardedBy(value="buffers")
    private boolean flushRequested;
    volatile boolean isReleased;
    private long totalNumberOfBuffers;
    private long totalNumberOfBytes;
    private ChannelStateWriter channelStateWriter;
    private int bufferSize;
    @GuardedBy(value="buffers")
    private CompletableFuture<List<Buffer>> channelStateFuture;
    @GuardedBy(value="buffers")
    private long channelStateCheckpointId;
    @GuardedBy(value="buffers")
    boolean isBlocked = false;
    int sequenceNumber = 0;

    PipelinedSubpartition(int index, int receiverExclusiveBuffersPerChannel, int startingBufferSize, ResultPartition parent) {
        super(index, parent);
        Preconditions.checkArgument((receiverExclusiveBuffersPerChannel >= 0 ? 1 : 0) != 0, (Object)"Buffers per channel must be non-negative.");
        this.receiverExclusiveBuffersPerChannel = receiverExclusiveBuffersPerChannel;
        this.bufferSize = startingBufferSize;
    }

    @Override
    public void setChannelStateWriter(ChannelStateWriter channelStateWriter) {
        Preconditions.checkState((this.channelStateWriter == null ? 1 : 0) != 0, (Object)"Already initialized");
        this.channelStateWriter = (ChannelStateWriter)Preconditions.checkNotNull((Object)channelStateWriter);
    }

    @Override
    public int add(BufferConsumer bufferConsumer, int partialRecordLength) {
        return this.add(bufferConsumer, partialRecordLength, false);
    }

    public boolean isSupportChannelStateRecover() {
        return true;
    }

    @Override
    public int finish() throws IOException {
        BufferConsumer eventBufferConsumer = EventSerializer.toBufferConsumer(EndOfPartitionEvent.INSTANCE, false);
        this.add(eventBufferConsumer, 0, true);
        LOG.debug("{}: Finished {}.", (Object)this.parent.getOwningTaskName(), (Object)this);
        return eventBufferConsumer.getWrittenBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int add(BufferConsumer bufferConsumer, int partialRecordLength, boolean finish) {
        int newBufferSize;
        boolean notifyDataAvailable;
        Preconditions.checkNotNull((Object)bufferConsumer);
        int prioritySequenceNumber = -1;
        PrioritizedDeque<BufferConsumerWithPartialRecordLength> prioritizedDeque = this.buffers;
        synchronized (prioritizedDeque) {
            if (this.isFinished || this.isReleased) {
                bufferConsumer.close();
                return -1;
            }
            if (this.addBuffer(bufferConsumer, partialRecordLength)) {
                prioritySequenceNumber = this.sequenceNumber;
            }
            this.updateStatistics(bufferConsumer);
            this.increaseBuffersInBacklog(bufferConsumer);
            notifyDataAvailable = finish || this.shouldNotifyDataAvailable();
            this.isFinished |= finish;
            newBufferSize = this.bufferSize;
        }
        this.notifyPriorityEvent(prioritySequenceNumber);
        if (notifyDataAvailable) {
            this.notifyDataAvailable();
        }
        return newBufferSize;
    }

    @GuardedBy(value="buffers")
    private boolean addBuffer(BufferConsumer bufferConsumer, int partialRecordLength) {
        assert (Thread.holdsLock(this.buffers));
        if (bufferConsumer.getDataType().hasPriority()) {
            return this.processPriorityBuffer(bufferConsumer, partialRecordLength);
        }
        if (Buffer.DataType.TIMEOUTABLE_ALIGNED_CHECKPOINT_BARRIER == bufferConsumer.getDataType()) {
            this.processTimeoutableCheckpointBarrier(bufferConsumer);
        }
        this.buffers.add(new BufferConsumerWithPartialRecordLength(bufferConsumer, partialRecordLength));
        return false;
    }

    @GuardedBy(value="buffers")
    private boolean processPriorityBuffer(BufferConsumer bufferConsumer, int partialRecordLength) {
        this.buffers.addPriorityElement(new BufferConsumerWithPartialRecordLength(bufferConsumer, partialRecordLength));
        int numPriorityElements = this.buffers.getNumPriorityElements();
        CheckpointBarrier barrier = this.parseCheckpointBarrier(bufferConsumer);
        if (barrier != null) {
            Preconditions.checkState((boolean)barrier.getCheckpointOptions().isUnalignedCheckpoint(), (Object)"Only unaligned checkpoints should be priority events");
            Iterator<BufferConsumerWithPartialRecordLength> iterator = this.buffers.iterator();
            Iterators.advance(iterator, (int)numPriorityElements);
            ArrayList<Buffer> inflightBuffers = new ArrayList<Buffer>();
            while (iterator.hasNext()) {
                BufferConsumer buffer = iterator.next().getBufferConsumer();
                if (!buffer.isBuffer()) continue;
                BufferConsumer bc = buffer.copy();
                try {
                    inflightBuffers.add(bc.build());
                }
                finally {
                    if (bc == null) continue;
                    bc.close();
                }
            }
            if (!inflightBuffers.isEmpty()) {
                this.channelStateWriter.addOutputData(barrier.getId(), this.subpartitionInfo, -2, inflightBuffers.toArray(new Buffer[0]));
            }
        }
        return this.needNotifyPriorityEvent();
    }

    @GuardedBy(value="buffers")
    private boolean needNotifyPriorityEvent() {
        assert (Thread.holdsLock(this.buffers));
        return this.buffers.getNumPriorityElements() == 1 && !this.isBlocked;
    }

    @GuardedBy(value="buffers")
    private void processTimeoutableCheckpointBarrier(BufferConsumer bufferConsumer) {
        CheckpointBarrier barrier = this.parseAndCheckTimeoutableCheckpointBarrier(bufferConsumer);
        this.channelStateWriter.addOutputDataFuture(barrier.getId(), this.subpartitionInfo, -2, this.createChannelStateFuture(barrier.getId()));
    }

    @GuardedBy(value="buffers")
    private CompletableFuture<List<Buffer>> createChannelStateFuture(long checkpointId) {
        assert (Thread.holdsLock(this.buffers));
        if (this.channelStateFuture != null) {
            this.completeChannelStateFuture(null, new IllegalStateException(String.format("%s has uncompleted channelStateFuture of checkpointId=%s, but it received a new timeoutable checkpoint barrier of checkpointId=%s, it maybe a bug due to currently not supported concurrent unaligned checkpoint.", this, this.channelStateCheckpointId, checkpointId)));
        }
        this.channelStateFuture = new CompletableFuture();
        this.channelStateCheckpointId = checkpointId;
        return this.channelStateFuture;
    }

    @GuardedBy(value="buffers")
    private void completeChannelStateFuture(List<Buffer> channelResult, Throwable e) {
        assert (Thread.holdsLock(this.buffers));
        if (e != null) {
            this.channelStateFuture.completeExceptionally(e);
        } else {
            this.channelStateFuture.complete(channelResult);
        }
        this.channelStateFuture = null;
    }

    @GuardedBy(value="buffers")
    private boolean isChannelStateFutureAvailable(long checkpointId) {
        assert (Thread.holdsLock(this.buffers));
        return this.channelStateFuture != null && this.channelStateCheckpointId == checkpointId;
    }

    private CheckpointBarrier parseAndCheckTimeoutableCheckpointBarrier(BufferConsumer bufferConsumer) {
        CheckpointBarrier barrier = this.parseCheckpointBarrier(bufferConsumer);
        Preconditions.checkArgument((barrier != null ? 1 : 0) != 0, (Object)"Parse the timeoutable Checkpoint Barrier failed.");
        Preconditions.checkState((barrier.getCheckpointOptions().isTimeoutable() && Buffer.DataType.TIMEOUTABLE_ALIGNED_CHECKPOINT_BARRIER == bufferConsumer.getDataType() ? 1 : 0) != 0);
        return barrier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void alignedBarrierTimeout(long checkpointId) throws IOException {
        int prioritySequenceNumber = -1;
        PrioritizedDeque<BufferConsumerWithPartialRecordLength> prioritizedDeque = this.buffers;
        synchronized (prioritizedDeque) {
            if (!this.isChannelStateFutureAvailable(checkpointId)) {
                return;
            }
            ArrayList<Buffer> inflightBuffers = new ArrayList<Buffer>();
            try {
                if (this.findInflightBuffersAndMakeBarrierToPriority(checkpointId, inflightBuffers)) {
                    prioritySequenceNumber = this.sequenceNumber;
                }
            }
            catch (IOException e) {
                inflightBuffers.forEach(Buffer::recycleBuffer);
                this.completeChannelStateFuture(null, e);
                throw e;
            }
            this.completeChannelStateFuture(inflightBuffers, null);
        }
        this.notifyPriorityEvent(prioritySequenceNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abortCheckpoint(long checkpointId, CheckpointException cause) {
        PrioritizedDeque<BufferConsumerWithPartialRecordLength> prioritizedDeque = this.buffers;
        synchronized (prioritizedDeque) {
            if (this.isChannelStateFutureAvailable(checkpointId)) {
                this.completeChannelStateFuture(null, cause);
            }
        }
    }

    @GuardedBy(value="buffers")
    private boolean findInflightBuffersAndMakeBarrierToPriority(long checkpointId, List<Buffer> inflightBuffers) throws IOException {
        int numPriorityElements = this.buffers.getNumPriorityElements();
        Iterator<BufferConsumerWithPartialRecordLength> iterator = this.buffers.iterator();
        Iterators.advance(iterator, (int)numPriorityElements);
        BufferConsumerWithPartialRecordLength element = null;
        CheckpointBarrier barrier = null;
        while (iterator.hasNext()) {
            BufferConsumerWithPartialRecordLength next = iterator.next();
            BufferConsumer bufferConsumer = next.getBufferConsumer();
            if (Buffer.DataType.TIMEOUTABLE_ALIGNED_CHECKPOINT_BARRIER == bufferConsumer.getDataType()) {
                barrier = this.parseAndCheckTimeoutableCheckpointBarrier(bufferConsumer);
                if (barrier.getId() != checkpointId) continue;
                element = next;
                break;
            }
            if (!bufferConsumer.isBuffer()) continue;
            BufferConsumer bc = bufferConsumer.copy();
            try {
                inflightBuffers.add(bc.build());
            }
            finally {
                if (bc == null) continue;
                bc.close();
            }
        }
        Preconditions.checkNotNull(element, (String)"The checkpoint barrier=%d don't find in %s.", (Object[])new Object[]{checkpointId, this.toString()});
        this.makeBarrierToPriority(element, barrier);
        return this.needNotifyPriorityEvent();
    }

    private void makeBarrierToPriority(BufferConsumerWithPartialRecordLength oldElement, CheckpointBarrier barrier) throws IOException {
        this.buffers.getAndRemove(oldElement::equals);
        this.buffers.addPriorityElement(new BufferConsumerWithPartialRecordLength(EventSerializer.toBufferConsumer(barrier.asUnaligned(), true), 0));
    }

    @Nullable
    private CheckpointBarrier parseCheckpointBarrier(BufferConsumer bufferConsumer) {
        CheckpointBarrier barrier;
        try (BufferConsumer bc = bufferConsumer.copy();){
            Buffer buffer = bc.build();
            try {
                AbstractEvent event = EventSerializer.fromBuffer(buffer, this.getClass().getClassLoader());
                barrier = event instanceof CheckpointBarrier ? (CheckpointBarrier)event : null;
            }
            catch (IOException e) {
                throw new IllegalStateException("Should always be able to deserialize in-memory event", e);
            }
            finally {
                buffer.recycleBuffer();
            }
        }
        return barrier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        PipelinedSubpartitionView view;
        PrioritizedDeque<BufferConsumerWithPartialRecordLength> prioritizedDeque = this.buffers;
        synchronized (prioritizedDeque) {
            if (this.isReleased) {
                return;
            }
            for (BufferConsumerWithPartialRecordLength buffer : this.buffers) {
                buffer.getBufferConsumer().close();
            }
            this.buffers.clear();
            if (this.channelStateFuture != null) {
                IllegalStateException exception = new IllegalStateException("The PipelinedSubpartition is released");
                this.completeChannelStateFuture(null, exception);
            }
            view = this.readView;
            this.readView = null;
            this.isReleased = true;
        }
        LOG.debug("{}: Released {}.", (Object)this.parent.getOwningTaskName(), (Object)this);
        if (view != null) {
            view.releaseAllResources();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    ResultSubpartition.BufferAndBacklog pollBuffer() {
        PrioritizedDeque<BufferConsumerWithPartialRecordLength> prioritizedDeque = this.buffers;
        synchronized (prioritizedDeque) {
            if (this.isBlocked) {
                return null;
            }
            Buffer buffer = null;
            if (this.buffers.isEmpty()) {
                this.flushRequested = false;
            }
            while (!this.buffers.isEmpty()) {
                BufferConsumerWithPartialRecordLength bufferConsumerWithPartialRecordLength = this.buffers.peek();
                BufferConsumer bufferConsumer = bufferConsumerWithPartialRecordLength.getBufferConsumer();
                if (Buffer.DataType.TIMEOUTABLE_ALIGNED_CHECKPOINT_BARRIER == bufferConsumer.getDataType()) {
                    this.completeTimeoutableCheckpointBarrier(bufferConsumer);
                }
                buffer = this.buildSliceBuffer(bufferConsumerWithPartialRecordLength);
                Preconditions.checkState((bufferConsumer.isFinished() || this.buffers.size() == 1 ? 1 : 0) != 0, (Object)"When there are multiple buffers, an unfinished bufferConsumer can not be at the head of the buffers queue.");
                if (this.buffers.size() == 1) {
                    this.flushRequested = false;
                }
                if (bufferConsumer.isFinished()) {
                    Objects.requireNonNull(this.buffers.poll()).getBufferConsumer().close();
                    this.decreaseBuffersInBacklogUnsafe(bufferConsumer.isBuffer());
                }
                if (this.receiverExclusiveBuffersPerChannel == 0 && bufferConsumer.isFinished() || buffer.readableBytes() > 0) break;
                buffer.recycleBuffer();
                buffer = null;
                if (bufferConsumer.isFinished()) continue;
                break;
            }
            if (buffer == null) {
                return null;
            }
            if (buffer.getDataType().isBlockingUpstream()) {
                this.isBlocked = true;
            }
            this.updateStatistics(buffer);
            NetworkActionsLogger.traceOutput("PipelinedSubpartition#pollBuffer", buffer, this.parent.getOwningTaskName(), this.subpartitionInfo);
            return new ResultSubpartition.BufferAndBacklog(buffer, this.getBuffersInBacklogUnsafe(), this.isDataAvailableUnsafe() ? this.getNextBufferTypeUnsafe() : Buffer.DataType.NONE, this.sequenceNumber++);
        }
    }

    @GuardedBy(value="buffers")
    private void completeTimeoutableCheckpointBarrier(BufferConsumer bufferConsumer) {
        CheckpointBarrier barrier = this.parseAndCheckTimeoutableCheckpointBarrier(bufferConsumer);
        if (!this.isChannelStateFutureAvailable(barrier.getId())) {
            return;
        }
        this.completeChannelStateFuture(Collections.emptyList(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resumeConsumption() {
        PrioritizedDeque<BufferConsumerWithPartialRecordLength> prioritizedDeque = this.buffers;
        synchronized (prioritizedDeque) {
            Preconditions.checkState((boolean)this.isBlocked, (Object)"Should be blocked by checkpoint.");
            this.isBlocked = false;
        }
    }

    public void acknowledgeAllDataProcessed() {
        this.parent.onSubpartitionAllDataProcessed(this.subpartitionInfo.getSubPartitionIdx());
    }

    @Override
    public boolean isReleased() {
        return this.isReleased;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PipelinedSubpartitionView createReadView(BufferAvailabilityListener availabilityListener) {
        PrioritizedDeque<BufferConsumerWithPartialRecordLength> prioritizedDeque = this.buffers;
        synchronized (prioritizedDeque) {
            Preconditions.checkState((!this.isReleased ? 1 : 0) != 0);
            Preconditions.checkState((this.readView == null ? 1 : 0) != 0, (String)"Subpartition %s of is being (or already has been) consumed, but pipelined subpartitions can only be consumed once.", (Object[])new Object[]{this.getSubPartitionIndex(), this.parent.getPartitionId()});
            LOG.debug("{}: Creating read view for subpartition {} of partition {}.", new Object[]{this.parent.getOwningTaskName(), this.getSubPartitionIndex(), this.parent.getPartitionId()});
            this.readView = new PipelinedSubpartitionView(this, availabilityListener);
        }
        return this.readView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSubpartitionView.AvailabilityWithBacklog getAvailabilityAndBacklog(boolean isCreditAvailable) {
        PrioritizedDeque<BufferConsumerWithPartialRecordLength> prioritizedDeque = this.buffers;
        synchronized (prioritizedDeque) {
            boolean isAvailable = isCreditAvailable ? this.isDataAvailableUnsafe() : this.getNextBufferTypeUnsafe().isEvent();
            return new ResultSubpartitionView.AvailabilityWithBacklog(isAvailable, this.getBuffersInBacklogUnsafe());
        }
    }

    @GuardedBy(value="buffers")
    private boolean isDataAvailableUnsafe() {
        assert (Thread.holdsLock(this.buffers));
        return !this.isBlocked && (this.flushRequested || this.getNumberOfFinishedBuffers() > 0);
    }

    private Buffer.DataType getNextBufferTypeUnsafe() {
        assert (Thread.holdsLock(this.buffers));
        BufferConsumerWithPartialRecordLength first = this.buffers.peek();
        return first != null ? first.getBufferConsumer().getDataType() : Buffer.DataType.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfQueuedBuffers() {
        PrioritizedDeque<BufferConsumerWithPartialRecordLength> prioritizedDeque = this.buffers;
        synchronized (prioritizedDeque) {
            return this.buffers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bufferSize(int desirableNewBufferSize) {
        if (desirableNewBufferSize < 0) {
            throw new IllegalArgumentException("New buffer size can not be less than zero");
        }
        PrioritizedDeque<BufferConsumerWithPartialRecordLength> prioritizedDeque = this.buffers;
        synchronized (prioritizedDeque) {
            this.bufferSize = desirableNewBufferSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        boolean hasReadView;
        boolean finished;
        long numBytes;
        long numBuffers;
        PrioritizedDeque<BufferConsumerWithPartialRecordLength> prioritizedDeque = this.buffers;
        synchronized (prioritizedDeque) {
            numBuffers = this.getTotalNumberOfBuffersUnsafe();
            numBytes = this.getTotalNumberOfBytesUnsafe();
            finished = this.isFinished;
            hasReadView = this.readView != null;
        }
        return String.format("%s#%d [number of buffers: %d (%d bytes), number of buffers in backlog: %d, finished? %s, read view? %s]", this.getClass().getSimpleName(), this.getSubPartitionIndex(), numBuffers, numBytes, this.getBuffersInBacklogUnsafe(), finished, hasReadView);
    }

    @Override
    public int unsynchronizedGetNumberOfQueuedBuffers() {
        return Math.max(this.buffers.size(), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        boolean notifyDataAvailable;
        PrioritizedDeque<BufferConsumerWithPartialRecordLength> prioritizedDeque = this.buffers;
        synchronized (prioritizedDeque) {
            if (this.buffers.isEmpty() || this.flushRequested) {
                return;
            }
            boolean isDataAvailableInUnfinishedBuffer = this.buffers.size() == 1 && this.buffers.peek().getBufferConsumer().isDataAvailable();
            notifyDataAvailable = !this.isBlocked && isDataAvailableInUnfinishedBuffer;
            this.flushRequested = this.buffers.size() > 1 || isDataAvailableInUnfinishedBuffer;
        }
        if (notifyDataAvailable) {
            this.notifyDataAvailable();
        }
    }

    @Override
    protected long getTotalNumberOfBuffersUnsafe() {
        return this.totalNumberOfBuffers;
    }

    @Override
    protected long getTotalNumberOfBytesUnsafe() {
        return this.totalNumberOfBytes;
    }

    Throwable getFailureCause() {
        return this.parent.getFailureCause();
    }

    private void updateStatistics(BufferConsumer buffer) {
        ++this.totalNumberOfBuffers;
    }

    private void updateStatistics(Buffer buffer) {
        this.totalNumberOfBytes += (long)buffer.getSize();
    }

    @GuardedBy(value="buffers")
    private void decreaseBuffersInBacklogUnsafe(boolean isBuffer) {
        assert (Thread.holdsLock(this.buffers));
        if (isBuffer) {
            --this.buffersInBacklog;
        }
    }

    @GuardedBy(value="buffers")
    private void increaseBuffersInBacklog(BufferConsumer buffer) {
        assert (Thread.holdsLock(this.buffers));
        if (buffer != null && buffer.isBuffer()) {
            ++this.buffersInBacklog;
        }
    }

    @Override
    public int getBuffersInBacklogUnsafe() {
        if (this.isBlocked || this.buffers.isEmpty()) {
            return 0;
        }
        if (this.flushRequested || this.isFinished || !((BufferConsumerWithPartialRecordLength)Preconditions.checkNotNull((Object)this.buffers.peekLast())).getBufferConsumer().isBuffer()) {
            return this.buffersInBacklog;
        }
        return Math.max(this.buffersInBacklog - 1, 0);
    }

    @GuardedBy(value="buffers")
    private boolean shouldNotifyDataAvailable() {
        return this.readView != null && !this.flushRequested && !this.isBlocked && this.getNumberOfFinishedBuffers() == 1;
    }

    private void notifyDataAvailable() {
        PipelinedSubpartitionView readView = this.readView;
        if (readView != null) {
            readView.notifyDataAvailable();
        }
    }

    private void notifyPriorityEvent(int prioritySequenceNumber) {
        PipelinedSubpartitionView readView = this.readView;
        if (readView != null && prioritySequenceNumber != -1) {
            readView.notifyPriorityEvent(prioritySequenceNumber);
        }
    }

    private int getNumberOfFinishedBuffers() {
        assert (Thread.holdsLock(this.buffers));
        int numBuffers = this.buffers.size();
        if (numBuffers == 1 && this.buffers.peekLast().getBufferConsumer().isFinished()) {
            return 1;
        }
        return Math.max(0, numBuffers - 1);
    }

    Buffer buildSliceBuffer(BufferConsumerWithPartialRecordLength buffer) {
        return buffer.build();
    }

    @VisibleForTesting
    BufferConsumerWithPartialRecordLength getNextBuffer() {
        return this.buffers.poll();
    }

    @VisibleForTesting
    CompletableFuture<List<Buffer>> getChannelStateFuture() {
        return this.channelStateFuture;
    }

    @VisibleForTesting
    public long getChannelStateCheckpointId() {
        return this.channelStateCheckpointId;
    }
}

