/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.metrics.Metric;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.MetricRegistryImpl;
import org.apache.flink.runtime.metrics.MetricRegistryTestUtils;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.metrics.groups.AbstractMetricGroup;
import org.apache.flink.runtime.metrics.groups.InternalOperatorMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskManagerMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskMetricGroup;
import org.apache.flink.runtime.metrics.scope.ScopeFormat;
import org.apache.flink.runtime.metrics.util.DummyCharacterFilter;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TaskMetricGroupTest {
    private MetricRegistryImpl registry;

    TaskMetricGroupTest() {
    }

    @BeforeEach
    void setup() {
        this.registry = new MetricRegistryImpl(MetricRegistryTestUtils.defaultMetricRegistryConfiguration());
    }

    @AfterEach
    void teardown() throws Exception {
        if (this.registry != null) {
            this.registry.closeAsync().get();
        }
    }

    @Test
    void testGenerateScopeDefault() {
        TaskManagerMetricGroup tmGroup = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)this.registry, (String)"theHostName", (ResourceID)new ResourceID("test-tm-id"));
        TaskMetricGroup taskGroup = tmGroup.addJob(new JobID(), "myJobName").addTask(ExecutionGraphTestUtils.createExecutionAttemptId(new JobVertexID(), 13, 2), "aTaskName");
        Assertions.assertThat((Object[])taskGroup.getScopeComponents()).containsExactly((Object[])new String[]{"theHostName", "taskmanager", "test-tm-id", "myJobName", "aTaskName", "13"});
        Assertions.assertThat((String)taskGroup.getMetricIdentifier("name")).isEqualTo("theHostName.taskmanager.test-tm-id.myJobName.aTaskName.13.name");
    }

    @Test
    void testGenerateScopeCustom() throws Exception {
        Configuration cfg = new Configuration();
        cfg.set(MetricOptions.SCOPE_NAMING_TM, (Object)"abc");
        cfg.set(MetricOptions.SCOPE_NAMING_TM_JOB, (Object)"def");
        cfg.set(MetricOptions.SCOPE_NAMING_TASK, (Object)"<tm_id>.<job_id>.<task_id>.<task_attempt_id>");
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.fromConfiguration(cfg));
        JobID jid = new JobID();
        JobVertexID vertexId = new JobVertexID();
        ExecutionAttemptID executionId = ExecutionGraphTestUtils.createExecutionAttemptId(vertexId, 13, 2);
        TaskManagerMetricGroup tmGroup = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)registry, (String)"theHostName", (ResourceID)new ResourceID("test-tm-id"));
        TaskMetricGroup taskGroup = tmGroup.addJob(jid, "myJobName").addTask(executionId, "aTaskName");
        Assertions.assertThat((Object[])taskGroup.getScopeComponents()).containsExactly((Object[])new String[]{"test-tm-id", jid.toString(), vertexId.toString(), executionId.toString()});
        Assertions.assertThat((String)taskGroup.getMetricIdentifier("name")).isEqualTo(String.format("test-tm-id.%s.%s.%s.name", jid, vertexId, executionId));
        registry.closeAsync().get();
    }

    @Test
    void testGenerateScopeWilcard() throws Exception {
        Configuration cfg = new Configuration();
        cfg.set(MetricOptions.SCOPE_NAMING_TASK, (Object)"*.<task_attempt_id>.<subtask_index>");
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.fromConfiguration(cfg));
        ExecutionAttemptID executionId = ExecutionGraphTestUtils.createExecutionAttemptId(new JobVertexID(), 13, 1);
        TaskManagerMetricGroup tmGroup = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)registry, (String)"theHostName", (ResourceID)new ResourceID("test-tm-id"));
        TaskMetricGroup taskGroup = tmGroup.addJob(new JobID(), "myJobName").addTask(executionId, "aTaskName");
        Assertions.assertThat((Object[])taskGroup.getScopeComponents()).containsExactly((Object[])new String[]{"theHostName", "taskmanager", "test-tm-id", "myJobName", executionId.toString(), "13"});
        Assertions.assertThat((String)taskGroup.getMetricIdentifier("name")).isEqualTo("theHostName.taskmanager.test-tm-id.myJobName." + executionId + ".13.name");
        registry.closeAsync().get();
    }

    @Test
    void testCreateQueryServiceMetricInfo() {
        JobID jid = new JobID();
        JobVertexID vid = new JobVertexID();
        ExecutionAttemptID eid = ExecutionGraphTestUtils.createExecutionAttemptId(vid, 4, 5);
        TaskManagerMetricGroup tm = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)this.registry, (String)"host", (ResourceID)new ResourceID("id"));
        TaskMetricGroup task = tm.addJob(jid, "jobname").addTask(eid, "taskName");
        QueryScopeInfo.TaskQueryScopeInfo info = task.createQueryServiceMetricInfo((CharacterFilter)new DummyCharacterFilter());
        Assertions.assertThat((String)info.scope).isEmpty();
        Assertions.assertThat((String)info.jobID).isEqualTo(jid.toString());
        Assertions.assertThat((String)info.vertexID).isEqualTo(vid.toString());
        Assertions.assertThat((int)info.subtaskIndex).isEqualTo(4);
    }

    @Test
    void testTaskMetricGroupCleanup() throws Exception {
        CountingMetricRegistry registry = new CountingMetricRegistry(new Configuration());
        TaskManagerMetricGroup taskManagerMetricGroup = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)registry, (String)"localhost", (ResourceID)new ResourceID("0"));
        int initialMetricsCount = registry.getNumberRegisteredMetrics();
        TaskMetricGroup taskMetricGroup = taskManagerMetricGroup.addJob(new JobID(), "job").addTask(ExecutionGraphTestUtils.createExecutionAttemptId(), "task");
        Assertions.assertThat((int)registry.getNumberRegisteredMetrics()).isGreaterThan(initialMetricsCount);
        taskMetricGroup.close();
        Assertions.assertThat((int)registry.getNumberRegisteredMetrics()).isEqualTo(initialMetricsCount);
        registry.closeAsync().get();
    }

    @Test
    void testOperatorNameTruncation() throws Exception {
        Configuration cfg = new Configuration();
        cfg.set(MetricOptions.SCOPE_NAMING_OPERATOR, (Object)ScopeFormat.SCOPE_OPERATOR_NAME);
        MetricRegistryImpl registry = new MetricRegistryImpl(MetricRegistryTestUtils.fromConfiguration(cfg));
        TaskManagerMetricGroup tm = TaskManagerMetricGroup.createTaskManagerMetricGroup((MetricRegistry)registry, (String)"host", (ResourceID)new ResourceID("id"));
        TaskMetricGroup taskMetricGroup = tm.addJob(new JobID(), "jobname").addTask(ExecutionGraphTestUtils.createExecutionAttemptId(), "task");
        String originalName = new String(new char[100]).replace("\u0000", "-");
        InternalOperatorMetricGroup operatorMetricGroup = taskMetricGroup.getOrAddOperator(originalName);
        String storedName = operatorMetricGroup.getScopeComponents()[0];
        Assertions.assertThat((int)storedName.length()).isEqualTo(80);
        Assertions.assertThat((String)originalName.substring(0, 80)).isEqualTo(storedName);
        registry.closeAsync().get();
    }

    private static class CountingMetricRegistry
    extends MetricRegistryImpl {
        private int counter = 0;

        CountingMetricRegistry(Configuration config) {
            super(MetricRegistryTestUtils.fromConfiguration(config));
        }

        public void register(Metric metric, String metricName, AbstractMetricGroup<?> group) {
            super.register(metric, metricName, group);
            ++this.counter;
        }

        public void unregister(Metric metric, String metricName, AbstractMetricGroup<?> group) {
            super.unregister(metric, metricName, group);
            --this.counter;
        }

        int getNumberRegisteredMetrics() {
            return this.counter;
        }
    }
}

