/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.throughput;

import java.time.Duration;
import org.apache.flink.runtime.throughput.ThroughputCalculator;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.ManualClock;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ThroughputCalculatorTest {
    ThroughputCalculatorTest() {
    }

    @Test
    void testCorrectThroughputCalculation() {
        ManualClock clock = new ManualClock();
        ThroughputCalculator throughputCalculator = new ThroughputCalculator((Clock)clock);
        throughputCalculator.incomingDataSize(6666L);
        clock.advanceTime(Duration.ofMillis(1L));
        throughputCalculator.incomingDataSize(3333L);
        clock.advanceTime(Duration.ofMillis(33L));
        throughputCalculator.incomingDataSize(1L);
        clock.advanceTime(Duration.ofMillis(66L));
        Assertions.assertThat((long)throughputCalculator.calculateThroughput()).isEqualTo(100000L);
    }

    @Test
    void testResetValueAfterCalculation() {
        ManualClock clock = new ManualClock();
        ThroughputCalculator throughputCalculator = new ThroughputCalculator((Clock)clock);
        throughputCalculator.incomingDataSize(666L);
        clock.advanceTime(Duration.ofMillis(100L));
        Assertions.assertThat((long)throughputCalculator.calculateThroughput()).isEqualTo(6660L);
        Assertions.assertThat((long)throughputCalculator.calculateThroughput()).isEqualTo(6660L);
        clock.advanceTime(Duration.ofMillis(1L));
        Assertions.assertThat((long)throughputCalculator.calculateThroughput()).isZero();
    }

    @Test
    void testIgnoringIdleTime() {
        ManualClock clock = new ManualClock();
        ThroughputCalculator throughputCalculator = new ThroughputCalculator((Clock)clock);
        throughputCalculator.incomingDataSize(7L);
        clock.advanceTime(Duration.ofMillis(1L));
        throughputCalculator.pauseMeasurement();
        clock.advanceTime(Duration.ofMillis(9L));
        throughputCalculator.incomingDataSize(3L);
        clock.advanceTime(Duration.ofMillis(1L));
        Assertions.assertThat((long)throughputCalculator.calculateThroughput()).isEqualTo(5000L);
    }

    @Test
    void testCalculationDuringIdleTime() {
        ManualClock clock = new ManualClock();
        ThroughputCalculator throughputCalculator = new ThroughputCalculator((Clock)clock);
        throughputCalculator.incomingDataSize(10L);
        clock.advanceTime(Duration.ofMillis(1L));
        throughputCalculator.pauseMeasurement();
        clock.advanceTime(Duration.ofMillis(9L));
        Assertions.assertThat((long)throughputCalculator.calculateThroughput()).isEqualTo(10000L);
    }

    @Test
    void testMultiplyIdleEnd() {
        ManualClock clock = new ManualClock();
        ThroughputCalculator throughputCalculator = new ThroughputCalculator((Clock)clock);
        throughputCalculator.incomingDataSize(10L);
        clock.advanceTime(Duration.ofMillis(3L));
        throughputCalculator.resumeMeasurement();
        clock.advanceTime(Duration.ofMillis(3L));
        throughputCalculator.resumeMeasurement();
        clock.advanceTime(Duration.ofMillis(3L));
        throughputCalculator.resumeMeasurement();
        clock.advanceTime(Duration.ofMillis(1L));
        Assertions.assertThat((long)throughputCalculator.calculateThroughput()).isEqualTo(1000L);
    }

    @Test
    void testNotRestartTimerOnCalculationDuringIdleTime() {
        ManualClock clock = new ManualClock();
        ThroughputCalculator throughputCalculator = new ThroughputCalculator((Clock)clock);
        throughputCalculator.pauseMeasurement();
        throughputCalculator.calculateThroughput();
        clock.advanceTime(Duration.ofMillis(9L));
        throughputCalculator.incomingDataSize(10L);
        clock.advanceTime(Duration.ofMillis(1L));
        Assertions.assertThat((long)throughputCalculator.calculateThroughput()).isEqualTo(10000L);
    }
}

